/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.field;

import java.text.NumberFormat;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Slider;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import jidefx.scene.control.field.PopupField;
import jidefx.scene.control.field.popup.PopupContent;
import jidefx.scene.control.field.verifier.IntegerDigitsPatternVerifier;

public class IntegerField
extends PopupField<Integer> {
    private IntegerProperty _maxProperty;
    private IntegerProperty _minProperty;
    private static final String STYLE_CLASS_DEFAULT = "integer-field";

    public IntegerField() {
        this(0, 100, 0);
    }

    public IntegerField(int min, int max) {
        this(min, max, min);
    }

    public IntegerField(int min, int max, int value) {
        this.setMin(min);
        this.setMax(max);
        this.setValue(value);
    }

    @Override
    protected void initializeStyle() {
        super.initializeStyle();
        this.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_DEFAULT});
    }

    private void initializePatternVerifiers(int min, int max) {
        this.getPatternVerifiers().put((Object)"n", (Object)new IntegerDigitsPatternVerifier<Integer>(min, max){

            @Override
            public Number toTargetValue(Integer fieldValue) {
                return fieldValue;
            }

            @Override
            public Integer fromTargetValue(Integer previousFieldValue, Number targetValue) {
                return targetValue.intValue();
            }
        });
    }

    public IntegerProperty maxProperty() {
        if (this._maxProperty == null) {
            this._maxProperty = new SimpleIntegerProperty(this, "max"){

                protected void invalidated() {
                    super.invalidated();
                    IntegerField.this.initializePatternVerifiers(IntegerField.this.getMin(), this.get());
                }
            };
        }
        return this._maxProperty;
    }

    public int getMax() {
        return this.maxProperty().get();
    }

    public void setMax(int maxValue) {
        this.maxProperty().set(maxValue);
    }

    public IntegerProperty minProperty() {
        if (this._minProperty == null) {
            this._minProperty = new SimpleIntegerProperty(this, "min"){

                protected void invalidated() {
                    super.invalidated();
                    IntegerField.this.initializePatternVerifiers(this.get(), IntegerField.this.getMax());
                }
            };
        }
        return this._minProperty;
    }

    public int getMin() {
        return this.minProperty().get();
    }

    public void setMin(int min) {
        this.minProperty().set(min);
    }

    @Override
    protected void initializePattern() {
        super.initializePattern();
        final NumberFormat format = NumberFormat.getIntegerInstance();
        format.setGroupingUsed(false);
        this.setStringConverter(new StringConverter<Integer>(){

            public String toString(Integer object) {
                return object != null ? format.format(object) : null;
            }

            public Integer fromString(String string) {
                try {
                    return Integer.parseInt(string);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        });
        this.initializePatternVerifiers(this.getMin(), this.getMax());
        this.setPattern("n");
    }

    @Override
    protected void initializeTextField() {
        super.initializeTextField();
        this.setPopupContentFactory(new Callback<Integer, PopupContent<Integer>>(){

            public PopupContent<Integer> call(Integer param) {
                return new IntegerSliderPopupContent((Integer)IntegerField.this.getValue());
            }
        });
    }

    public class IntegerSliderPopupContent
    extends VBox
    implements PopupContent<Integer> {
        private static final String STYLE_CLASS_DEFAULT = "popup-content";
        private final Slider _slider;
        private ObjectProperty<Integer> _value;

        public IntegerSliderPopupContent(int value) {
            this.getStylesheets().add((Object)PopupContent.class.getResource("PopupContent.css").toExternalForm());
            this.getStyleClass().add((Object)STYLE_CLASS_DEFAULT);
            this._slider = new Slider(0.0, 100.0, (double)value);
            this._slider.maxProperty().bind((ObservableValue)IntegerField.this.maxProperty());
            this._slider.minProperty().bind((ObservableValue)IntegerField.this.minProperty());
            this.getChildren().add((Object)this._slider);
            this._value = new SimpleObjectProperty();
            this._slider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                    IntegerSliderPopupContent.this._value.set((Object)newValue.intValue());
                }
            });
        }

        @Override
        public ObservableValue<Integer> valueProperty() {
            return this._value;
        }

        @Override
        public Integer getValue() {
            return (int)this._slider.getValue();
        }

        @Override
        public void setValue(Integer value) {
            this._slider.setValue((double)value.intValue());
        }
    }
}

