/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.combobox;

import com.jidefx.scene.control.skin.combobox.FormattedComboBoxSkin;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import jidefx.scene.control.editor.Editor;
import jidefx.scene.control.field.FormattedTextField;
import jidefx.scene.control.field.popup.PopupContent;

public class FormattedComboBox<T>
extends ComboBoxBase<T>
implements Editor<T> {
    private static final String STYLE_CLASS_COMBO_BOX = "combo-box";
    private static final String STYLE_CLASS_FORMATTED_COMBO_BOX = "formatted-combo-box";
    private ObjectProperty<Callback<T, PopupContent<T>>> _popupContentFactory;
    private ReadOnlyObjectWrapper<FormattedTextField<T>> editor;

    public FormattedComboBox() {
        this(null);
    }

    public FormattedComboBox(T value) {
        this.initializeComboBox();
        this.initializeStyle();
        this.registerListeners();
        this.setValue(value);
    }

    protected void initializeStyle() {
        this.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_COMBO_BOX, STYLE_CLASS_FORMATTED_COMBO_BOX});
    }

    protected void initializeComboBox() {
    }

    protected void registerListeners() {
    }

    public final void setPopupContentFactory(Callback<T, PopupContent<T>> value) {
        this.popupContentFactoryProperty().set(value);
    }

    public final Callback<T, PopupContent<T>> getPopupContentFactory() {
        return (Callback)this.popupContentFactoryProperty().get();
    }

    public ObjectProperty<Callback<T, PopupContent<T>>> popupContentFactoryProperty() {
        if (this._popupContentFactory == null) {
            this._popupContentFactory = new SimpleObjectProperty((Object)this, "popupContentFactory");
        }
        return this._popupContentFactory;
    }

    public final FormattedTextField<T> getEditor() {
        return (FormattedTextField)this.editorProperty().get();
    }

    public final ReadOnlyObjectProperty<FormattedTextField<T>> editorProperty() {
        if (this.editor == null) {
            this.editor = new ReadOnlyObjectWrapper((Object)this, "editor");
            FormattedTextField<T> field = this.createFormattedTextField();
            field.valueProperty().bindBidirectional((Property)this.valueProperty());
            field.setComboBoxLike(false);
            this.editor.set(field);
        }
        return this.editor.getReadOnlyProperty();
    }

    protected FormattedTextField<T> createFormattedTextField() {
        return new FormattedTextField();
    }

    protected Skin<?> createDefaultSkin() {
        return new FormattedComboBoxSkin(this);
    }

    @Override
    public ObservableValue<T> observableValue() {
        return this.valueProperty();
    }
}

