/*
 * Decompiled with CFR 0.152.
 */
package com.jidefx.scene.control.skin.combobox;

import com.jidefx.scene.control.behavior.combobox.FormattedComboBoxBehavior;
import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.behavior.ComboBoxBaseBehavior;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.scene.control.Skinnable;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import jidefx.scene.control.combobox.FormattedComboBox;
import jidefx.scene.control.field.FormattedTextField;
import jidefx.scene.control.field.popup.PopupContent;

public class FormattedComboBoxSkin<T>
extends ComboBoxPopupControl<T> {
    private final FormattedComboBox<T> comboBox;
    private FormattedTextField<T> textField;
    private PopupContent<T> _popupContent;
    private String initialTextFieldValue = null;
    private static PseudoClass CONTAINS_FOCUS_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"contains-focus");

    public FormattedComboBoxSkin(final FormattedComboBox<T> comboBox) {
        super(comboBox, new FormattedComboBoxBehavior<T>(comboBox));
        this.comboBox = comboBox;
        this.textField = this.getInputNode();
        if (this.textField != null) {
            this.getChildren().add(this.textField);
        }
        comboBox.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean hasFocus) {
                if (comboBox.isEditable() && hasFocus.booleanValue()) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            FormattedComboBoxSkin.this.textField.requestFocus();
                        }
                    });
                }
            }
        });
        comboBox.addEventFilter(KeyEvent.ANY, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent ke) {
                if (FormattedComboBoxSkin.this.textField == null) {
                    return;
                }
                if (ke.getCode() == KeyCode.ENTER) {
                    FormattedComboBoxSkin.this.setTextFromTextFieldIntoComboBoxValue();
                    if (!com.sun.javafx.scene.control.skin.Utils.isTwoLevelFocus()) {
                        ke.consume();
                    }
                } else if (ke.getCode() == KeyCode.F4 && KeyEvent.KEY_RELEASED.equals(ke.getEventType())) {
                    if (comboBox.isShowing()) {
                        comboBox.hide();
                    } else {
                        comboBox.show();
                    }
                    ke.consume();
                } else if (ke.getCode() == KeyCode.F10 || ke.getCode() == KeyCode.ESCAPE) {
                    ke.consume();
                }
            }
        });
        this.registerChangeListener((ObservableValue)comboBox.promptTextProperty(), "PROMPT_TEXT");
        this.registerChangeListener((ObservableValue)comboBox.popupContentFactoryProperty(), "POPUP_CONTENT_FACTORY");
        this.registerChangeListener((ObservableValue)comboBox.valueProperty(), "VALUE");
        this.registerChangeListener((ObservableValue)comboBox.editorProperty(), "EDITABLE");
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        switch (p) {
            case "PROMPT_TEXT": {
                this.updateDisplayNode();
                break;
            }
            case "POPUP_CONTENT_FACTORY": {
                this.updatePopupContentFactory();
                break;
            }
            case "EDITABLE": {
                this.updateEditable();
                break;
            }
            case "EDITOR": {
                this.getInputNode();
                break;
            }
            case "VALUE": {
                this.updateValue();
            }
        }
    }

    public Node getDisplayNode() {
        FormattedTextField<T> displayNode = this.getInputNode();
        this.updateDisplayNode();
        return displayNode;
    }

    public Node getPopupContent() {
        if (this._popupContent == null) {
            this._popupContent = this.createPopupContent();
        }
        return (Node)this._popupContent;
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return 50.0;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return 2.147483647E9;
    }

    private void updateValue() {
        Object newValue = this.comboBox.getValue();
        if (this._popupContent != null) {
            ((PopupContent)this.getPopupContent()).setValue(newValue);
        }
    }

    private FormattedTextField<T> getInputNode() {
        if (this.textField != null) {
            return this.textField;
        }
        this.textField = this.comboBox.getEditor();
        this.textField.setFocusTraversable(true);
        this.textField.promptTextProperty().bindBidirectional((Property)this.comboBox.promptTextProperty());
        this.initialTextFieldValue = this.textField.getText();
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean hasFocus) {
                if (!hasFocus.booleanValue()) {
                    FormattedComboBoxSkin.this.setTextFromTextFieldIntoComboBoxValue();
                    FormattedComboBoxSkin.this.pseudoClassStateChanged(CONTAINS_FOCUS_PSEUDOCLASS_STATE, false);
                } else {
                    FormattedComboBoxSkin.this.pseudoClassStateChanged(CONTAINS_FOCUS_PSEUDOCLASS_STATE, true);
                }
            }
        });
        return this.textField;
    }

    private void updateDisplayNode() {
        Object value = this.comboBox.getValue();
        if (this.initialTextFieldValue != null && !this.initialTextFieldValue.isEmpty()) {
            this.textField.setText(this.initialTextFieldValue);
            this.initialTextFieldValue = null;
        } else {
            this.comboBox.setValue(value);
        }
    }

    private void updateEditable() {
        this.textField.setEditable(this.comboBox.isEditable());
    }

    private void setTextFromTextFieldIntoComboBoxValue() {
        this.comboBox.setValue(this.textField.getValue());
    }

    private void updatePopupContentFactory() {
        this._popupContent = this.createPopupContent();
    }

    private PopupContent<T> createPopupContent() {
        PopupContent pane = (PopupContent)this.comboBox.getPopupContentFactory().call(this.comboBox.getValue());
        pane.valueProperty().addListener(new ChangeListener<T>(){

            public void changed(ObservableValue<? extends T> observable, T oldValue, T newValue) {
                FormattedComboBoxSkin.this.comboBox.setValue(newValue);
            }
        });
        return pane;
    }

    protected PopupControl getPopup() {
        if (this.popup == null) {
            this.createPopup();
        }
        return this.popup;
    }

    protected void createPopup() {
        this.popup = new PopupControl(){
            {
                this.setSkin((Skin)new Skin<Skinnable>(){

                    public Skinnable getSkinnable() {
                        return FormattedComboBoxSkin.this.getSkinnable();
                    }

                    public Node getNode() {
                        return FormattedComboBoxSkin.this.getPopupContent();
                    }

                    public void dispose() {
                    }
                });
            }

            public Styleable getStyleableParent() {
                return FormattedComboBoxSkin.this.getSkinnable();
            }
        };
        this.popup.getStyleClass().add((Object)"combo-box-popup");
        this.popup.setAutoHide(true);
        this.popup.setAutoFix(true);
        this.popup.setHideOnEscape(true);
        this.popup.setOnAutoHide((EventHandler)new EventHandler<Event>(){

            public void handle(Event e) {
                ((ComboBoxBaseBehavior)FormattedComboBoxSkin.this.getBehavior()).onAutoHide();
            }
        });
        this.popup.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                if (t.getTarget() == FormattedComboBoxSkin.this.getPopupContent()) {
                    ((ComboBoxBaseBehavior)FormattedComboBoxSkin.this.getBehavior()).onAutoHide();
                }
            }
        });
        InvalidationListener layoutPosListener = new InvalidationListener(){

            public void invalidated(Observable o) {
                FormattedComboBoxSkin.this.reconfigurePopup();
            }
        };
        ((ComboBoxBase)this.getSkinnable()).layoutXProperty().addListener(layoutPosListener);
        ((ComboBoxBase)this.getSkinnable()).layoutYProperty().addListener(layoutPosListener);
        ((ComboBoxBase)this.getSkinnable()).widthProperty().addListener(layoutPosListener);
    }

    void reconfigurePopup() {
        if (!this.getPopup().isShowing()) {
            return;
        }
        Point2D p = this.getPrefPopupPosition();
        this.reconfigurePopup(p.getX(), p.getY(), this.getPopupContent().prefWidth(1.0), this.getPopupContent().prefHeight(1.0));
    }

    void reconfigurePopup(double x, double y, double minWidth, double minHeight) {
        if (!this.getPopup().isShowing()) {
            return;
        }
        if (x > -1.0) {
            this.getPopup().setX(x);
        }
        if (y > -1.0) {
            this.getPopup().setY(y);
        }
        if (minWidth > -1.0) {
            this.getPopup().setMinWidth(minWidth);
        }
        if (minHeight > -1.0) {
            this.getPopup().setMinHeight(minHeight);
        }
    }

    private Point2D getPrefPopupPosition() {
        double dx = 0.0;
        dx += ((ComboBoxBase)this.getSkinnable()).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT ? -1.0 : 1.0;
        return Utils.pointRelativeTo((Node)this.getSkinnable(), (Node)this.getPopupContent(), (HPos)HPos.RIGHT, (VPos)VPos.BOTTOM, (double)(-this.getPopup().prefWidth(-1.0)), (double)0.0, (boolean)false);
    }
}

