/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.v3.client.internal;

import com.influxdb.v3.client.write.WritePrecision;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;

public final class NanosecondConverter {
    private static final BigInteger NANOS_PER_SECOND = BigInteger.valueOf(1000000000L);
    private static final BigInteger MICRO_PER_NANOS = BigInteger.valueOf(1000L);
    private static final BigInteger MILLIS_PER_NANOS = BigInteger.valueOf(1000000L);
    private static final BigInteger SECONDS_PER_NANOS = BigInteger.valueOf(1000000000L);
    private static final Map<WritePrecision, Function<BigInteger, BigInteger>> FROM_NANOS = new HashMap<WritePrecision, Function<BigInteger, BigInteger>>();
    private static final Map<WritePrecision, Function<BigInteger, BigInteger>> TO_NANOS;

    private NanosecondConverter() {
    }

    @Nullable
    public static BigInteger convertToNanos(@Nullable Number timestamp, WritePrecision precision) {
        if (timestamp == null) {
            return null;
        }
        BigInteger t = timestamp instanceof BigDecimal ? ((BigDecimal)timestamp).toBigInteger() : (timestamp instanceof BigInteger ? (BigInteger)timestamp : BigInteger.valueOf(timestamp.longValue()));
        return TO_NANOS.get((Object)precision).apply(t);
    }

    public static BigInteger convert(Instant instant, WritePrecision precision) {
        BigInteger nanos = BigInteger.valueOf(instant.getEpochSecond()).multiply(NANOS_PER_SECOND).add(BigInteger.valueOf(instant.getNano()));
        return FROM_NANOS.get((Object)precision).apply(nanos);
    }

    @Nullable
    public static BigInteger getTimestampNano(@Nonnull Object value, @Nonnull Field field) {
        BigInteger result = null;
        if (value instanceof Long) {
            if (field.getFieldType().getType() instanceof ArrowType.Timestamp) {
                TimeUnit timeUnit;
                ArrowType.Timestamp type = (ArrowType.Timestamp)field.getFieldType().getType();
                switch (type.getUnit()) {
                    case SECOND: {
                        timeUnit = TimeUnit.SECONDS;
                        break;
                    }
                    case MILLISECOND: {
                        timeUnit = TimeUnit.MILLISECONDS;
                        break;
                    }
                    case MICROSECOND: {
                        timeUnit = TimeUnit.MICROSECONDS;
                        break;
                    }
                    default: {
                        timeUnit = TimeUnit.NANOSECONDS;
                    }
                }
                long nanoseconds = TimeUnit.NANOSECONDS.convert((Long)value, timeUnit);
                Instant instant = Instant.ofEpochSecond(0L, nanoseconds);
                result = NanosecondConverter.convertInstantToNano(instant);
            } else {
                Instant instant = Instant.ofEpochMilli((Long)value);
                result = NanosecondConverter.convertInstantToNano(instant);
            }
        } else if (value instanceof LocalDateTime) {
            Instant instant = ((LocalDateTime)value).toInstant(ZoneOffset.UTC);
            result = NanosecondConverter.convertInstantToNano(instant);
        }
        return result;
    }

    @Nullable
    private static BigInteger convertInstantToNano(@Nonnull Instant instant) {
        WritePrecision writePrecision = WritePrecision.NS;
        BigInteger convertedTime = NanosecondConverter.convert(instant, writePrecision);
        return NanosecondConverter.convertToNanos(convertedTime, writePrecision);
    }

    static {
        FROM_NANOS.put(WritePrecision.S, timestamp -> timestamp.divide(SECONDS_PER_NANOS));
        FROM_NANOS.put(WritePrecision.MS, timestamp -> timestamp.divide(MILLIS_PER_NANOS));
        FROM_NANOS.put(WritePrecision.US, timestamp -> timestamp.divide(MICRO_PER_NANOS));
        FROM_NANOS.put(WritePrecision.NS, Function.identity());
        TO_NANOS = new HashMap<WritePrecision, Function<BigInteger, BigInteger>>();
        TO_NANOS.put(WritePrecision.S, timestamp -> timestamp.multiply(SECONDS_PER_NANOS));
        TO_NANOS.put(WritePrecision.MS, timestamp -> timestamp.multiply(MILLIS_PER_NANOS));
        TO_NANOS.put(WritePrecision.US, timestamp -> timestamp.multiply(MICRO_PER_NANOS));
        TO_NANOS.put(WritePrecision.NS, Function.identity());
    }
}

