/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.user;

import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.mail.MailAddress;
import com.icegreen.greenmail.mail.MovingMessage;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.MessageDeliveryHandler;
import com.icegreen.greenmail.user.UserException;
import com.icegreen.greenmail.user.UserImpl;
import jakarta.mail.MessagingException;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserManager {
    private static final Logger log = LoggerFactory.getLogger(UserManager.class);
    private final Map<String, GreenMailUser> loginToUser = new ConcurrentHashMap<String, GreenMailUser>();
    private final Map<String, GreenMailUser> emailToUser = new ConcurrentHashMap<String, GreenMailUser>();
    private final ImapHostManager imapHostManager;
    private boolean authRequired = true;
    private MessageDeliveryHandler messageDeliveryHandler = (msg, mailAddress) -> {
        GreenMailUser user = this.getUserByEmail(mailAddress.getEmail());
        if (null == user) {
            String login = mailAddress.getEmail();
            String email = mailAddress.getEmail();
            String password = mailAddress.getEmail();
            user = this.createUser(email, login, password);
            log.info("Created user login {} for address {} with password {} because it didn't exist before.", new Object[]{login, email, password});
        }
        return user;
    };

    public UserManager(ImapHostManager imapHostManager) {
        this.imapHostManager = imapHostManager;
    }

    public GreenMailUser getUser(String login) {
        return this.loginToUser.get(UserManager.normalizerUserName(login));
    }

    public GreenMailUser getUserByEmail(String email) {
        return this.emailToUser.get(UserManager.normalizerUserName(email));
    }

    public GreenMailUser createUser(String email, String login, String password) throws UserException {
        log.debug("Creating user {}", (Object)email);
        UserImpl user = new UserImpl(email, login, password, this.imapHostManager);
        user.create();
        this.loginToUser.put(UserManager.normalizerUserName(user.getLogin()), user);
        this.emailToUser.put(UserManager.normalizerUserName(user.getEmail()), user);
        return user;
    }

    public void deleteUser(GreenMailUser user) {
        log.debug("Deleting user {}", (Object)user);
        GreenMailUser deletedUser = this.loginToUser.remove(UserManager.normalizerUserName(user.getLogin()));
        if (deletedUser != null) {
            this.emailToUser.remove(UserManager.normalizerUserName(deletedUser.getEmail()));
            deletedUser.delete();
        }
    }

    public Collection<GreenMailUser> listUser() {
        return Collections.unmodifiableCollection(this.loginToUser.values());
    }

    public boolean test(String userId, String password) {
        log.debug("Authenticating user {}", (Object)userId);
        GreenMailUser u = this.getUser(userId);
        if (!this.authRequired) {
            if (null == u) {
                try {
                    this.createUser(userId, userId, password);
                }
                catch (UserException e) {
                    throw new IllegalStateException("Failed to create user with userid=" + userId, e);
                }
            }
            return true;
        }
        return null != u && this.checkPassword(u.getPassword(), password);
    }

    private boolean checkPassword(String expectedPassword, String password) {
        return null != expectedPassword && expectedPassword.equals(password) || null == password && expectedPassword == null;
    }

    public void setAuthRequired(boolean auth) {
        this.authRequired = auth;
    }

    public boolean isAuthRequired() {
        return this.authRequired;
    }

    public ImapHostManager getImapHostManager() {
        return this.imapHostManager;
    }

    private static String normalizerUserName(String login) {
        return login.trim().toLowerCase(Locale.ENGLISH);
    }

    public boolean hasUser(String userId) {
        String normalized = UserManager.normalizerUserName(userId);
        return this.loginToUser.containsKey(normalized) || this.emailToUser.containsKey(normalized);
    }

    public void setMessageDeliveryHandler(MessageDeliveryHandler deliveryHandler) {
        this.messageDeliveryHandler = deliveryHandler;
    }

    public MessageDeliveryHandler getMessageDeliveryHandler() {
        return this.messageDeliveryHandler;
    }

    public void deliver(MovingMessage msg, MailAddress mailAddress) throws MessagingException, UserException {
        this.messageDeliveryHandler.handle(msg, mailAddress).deliver(msg);
    }
}

