/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap;

import com.icegreen.greenmail.imap.ProtocolException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ImapRequestLineReader {
    private final InputStream input;
    private final OutputStream output;
    private boolean nextSeen = false;
    private char nextChar;

    public ImapRequestLineReader(InputStream input, OutputStream output) {
        this.input = input;
        this.output = output;
    }

    public char nextWordChar() throws ProtocolException {
        char next = this.nextChar();
        while (next == ' ') {
            this.consume();
            next = this.nextChar();
        }
        if (next == '\r' || next == '\n') {
            throw new ProtocolException("Missing argument.");
        }
        return next;
    }

    public char nextChar() throws ProtocolException {
        if (!this.nextSeen) {
            try {
                int read = this.input.read();
                char c = (char)read;
                if (read == -1) {
                    throw new ProtocolException("End of stream");
                }
                this.nextChar = c;
                this.nextSeen = true;
            }
            catch (IOException e) {
                throw new ProtocolException("Error reading from stream.", e);
            }
        }
        return this.nextChar;
    }

    public void eol() throws ProtocolException {
        char next = this.nextChar();
        while (next == ' ') {
            this.consume();
            next = this.nextChar();
        }
        if (next == '\r') {
            this.consume();
            next = this.nextChar();
        }
        if (next != '\n') {
            throw new ProtocolException("Expected end-of-line, found more character(s): " + next);
        }
    }

    public char consume() throws ProtocolException {
        char current = this.nextChar();
        this.nextSeen = false;
        this.nextChar = '\u0000';
        return current;
    }

    public void read(byte[] holder) throws ProtocolException {
        try {
            int count;
            for (int readTotal = 0; readTotal < holder.length; readTotal += count) {
                count = this.input.read(holder, readTotal, holder.length - readTotal);
                if (count != -1) continue;
                throw new ProtocolException("Unexpected end of stream.");
            }
            this.nextSeen = false;
            this.nextChar = '\u0000';
        }
        catch (IOException e) {
            throw new ProtocolException("Error reading from stream.", e);
        }
    }

    public void commandContinuationRequest() throws ProtocolException {
        try {
            this.output.write(43);
            this.output.write(32);
            this.output.write(79);
            this.output.write(75);
            this.output.write(13);
            this.output.write(10);
            this.output.flush();
        }
        catch (IOException e) {
            throw new ProtocolException("Unexpected exception in sending command continuation request.", e);
        }
    }

    public void consumeLine() throws ProtocolException {
        char next = this.nextChar();
        while (next != '\n') {
            this.consume();
            next = this.nextChar();
        }
        this.consume();
    }

    public char consumeAll(char c) throws ProtocolException {
        char next = this.nextChar();
        while (next == c) {
            this.consume();
            next = this.nextChar();
        }
        return next;
    }
}

