/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.reflection;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class GenericReflection {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericReflection.class);
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final GenericReflection INSTANCE = new GenericReflection();

    private GenericReflection() {
    }

    public static <SRCTYPE, DSTTYPE> DSTTYPE uncheckedCast(@Nullable SRCTYPE SRCTYPE) {
        return (DSTTYPE)SRCTYPE;
    }

    public static <DATATYPE> @NonNull Class<DATATYPE> getClassFromName(@NonNull ClassLoader classLoader, @NonNull String string) throws ClassNotFoundException {
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        return (Class)GenericReflection.uncheckedCast(classLoader.loadClass(string));
    }

    public static <DATATYPE> @NonNull Class<DATATYPE> getClassFromName(@NonNull String string) throws ClassNotFoundException {
        return (Class)GenericReflection.uncheckedCast(Class.forName(string));
    }

    public static <DATATYPE> @Nullable Class<DATATYPE> getClassFromNameSafe(@NonNull ClassLoader classLoader, @NonNull String string) {
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        try {
            return GenericReflection.getClassFromName(classLoader, string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static <DATATYPE> @Nullable Class<DATATYPE> getClassFromNameSafe(@NonNull String string) {
        try {
            return GenericReflection.getClassFromName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static @NonNull Class<?>[] getClassArray(Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return EMPTY_CLASS_ARRAY;
        }
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        return classArray;
    }

    public static <RETURNTYPE> @Nullable RETURNTYPE invokeMethod(@NonNull Object object, @NonNull String string, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return GenericReflection.invokeMethod(object, string, GenericReflection.getClassArray(objectArray), objectArray);
    }

    public static <RETURNTYPE> @Nullable RETURNTYPE invokeMethod(@NonNull Object object, @NonNull String string, @Nullable Class<?>[] classArray, @Nullable Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = object.getClass().getDeclaredMethod(string, classArray);
        Object object2 = method.invoke(object, objectArray);
        return (RETURNTYPE)GenericReflection.uncheckedCast(object2);
    }

    public static <RETURNTYPE> @Nullable RETURNTYPE invokeStaticMethod(@NonNull String string, @NonNull String string2, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        return GenericReflection.invokeStaticMethod(GenericReflection.getClassFromName(string), string2, objectArray);
    }

    public static <RETURNTYPE> @Nullable RETURNTYPE invokeStaticMethod(@NonNull Class<?> clazz, @NonNull String string, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return GenericReflection.invokeStaticMethod(clazz, string, GenericReflection.getClassArray(objectArray), objectArray);
    }

    public static <RETURNTYPE> @Nullable RETURNTYPE invokeStaticMethod(@NonNull String string, @NonNull String string2, @Nullable Class<?>[] classArray, @Nullable Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        return GenericReflection.invokeStaticMethod(GenericReflection.getClassFromName(string), string2, classArray, objectArray);
    }

    public static <RETURNTYPE> @Nullable RETURNTYPE invokeStaticMethod(@NonNull Class<?> clazz, @NonNull String string, @Nullable Class<?>[] classArray, @Nullable Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = clazz.getDeclaredMethod(string, classArray);
        Object object = method.invoke(null, objectArray);
        return (RETURNTYPE)GenericReflection.uncheckedCast(object);
    }

    public static <DATATYPE> @NonNull Constructor<DATATYPE> findConstructor(@NonNull DATATYPE DATATYPE, Class<?> ... classArray) throws NoSuchMethodException {
        return (Constructor)GenericReflection.uncheckedCast(DATATYPE.getClass().getConstructor(classArray));
    }

    public static <DATATYPE> @NonNull DATATYPE newInstance(@NonNull DATATYPE DATATYPE) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, InstantiationException {
        return GenericReflection.findConstructor(DATATYPE, new Class[0]).newInstance(new Object[0]);
    }

    public static <DATATYPE> @Nullable DATATYPE newInstance(@Nullable Class<? extends DATATYPE> clazz) {
        if (clazz != null) {
            try {
                return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to instantiate " + String.valueOf(clazz), (Throwable)exception);
            }
        }
        return null;
    }

    public static <DATATYPE> @Nullable DATATYPE newInstance(@NonNull ClassLoader classLoader, @Nullable String string, @Nullable Class<? extends DATATYPE> clazz) {
        if (string != null && clazz != null) {
            try {
                return clazz.cast(GenericReflection.getClassFromName(classLoader, string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception exception) {
                LOGGER.error("Failed to instantiate '" + string + "'", (Throwable)exception);
            }
        }
        return null;
    }

    public static <DATATYPE> @Nullable DATATYPE newInstance(@Nullable String string, @Nullable Class<? extends DATATYPE> clazz) {
        return GenericReflection.newInstance(string, clazz, (Exception exception) -> LOGGER.error("Failed to instantiate '" + string + "'", (Throwable)exception));
    }

    public static <DATATYPE> @Nullable DATATYPE newInstance(@Nullable String string, @Nullable Class<? extends DATATYPE> clazz, @Nullable Consumer<Exception> consumer) {
        block3: {
            if (string != null && clazz != null) {
                try {
                    return clazz.cast(GenericReflection.getClassFromName(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception exception) {
                    if (consumer == null) break block3;
                    consumer.accept(exception);
                }
            }
        }
        return null;
    }

    public static <DATATYPE> @Nullable DATATYPE newInstance(@Nullable String string, @Nullable Class<? extends DATATYPE> clazz, @Nullable ClassLoader classLoader) {
        return GenericReflection.newInstance(string, clazz, classLoader, exception -> LOGGER.error("Failed to instantiate '" + string + "' with CL " + String.valueOf(classLoader), (Throwable)exception));
    }

    public static <DATATYPE> @Nullable DATATYPE newInstance(@Nullable String string, @Nullable Class<? extends DATATYPE> clazz, @Nullable ClassLoader classLoader, @Nullable Consumer<Exception> consumer) {
        block3: {
            if (string != null && clazz != null && classLoader != null) {
                try {
                    return clazz.cast(Class.forName(string, true, classLoader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception exception) {
                    if (consumer == null) break block3;
                    consumer.accept(exception);
                }
            }
        }
        return null;
    }
}

