/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.servlet.DefaultGraphQLErrorHandler;
import graphql.servlet.DefaultObjectMapperConfigurer;
import graphql.servlet.GraphQLErrorHandler;
import graphql.servlet.ObjectMapperConfigurer;
import graphql.servlet.internal.GraphQLRequest;
import graphql.servlet.internal.VariablesDeserializer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class GraphQLObjectMapper {
    private final Supplier<ObjectMapperConfigurer> objectMapperConfigurerSupplier;
    private final Supplier<GraphQLErrorHandler> graphQLErrorHandlerSupplier;
    private volatile ObjectMapper mapper;

    protected GraphQLObjectMapper(Supplier<ObjectMapperConfigurer> objectMapperConfigurerSupplier, Supplier<GraphQLErrorHandler> graphQLErrorHandlerSupplier) {
        this.objectMapperConfigurerSupplier = objectMapperConfigurerSupplier;
        this.graphQLErrorHandlerSupplier = graphQLErrorHandlerSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectMapper getJacksonMapper() {
        ObjectMapper result = this.mapper;
        if (result == null) {
            GraphQLObjectMapper graphQLObjectMapper = this;
            synchronized (graphQLObjectMapper) {
                result = this.mapper;
                if (result == null) {
                    this.mapper = result = this.createObjectMapper();
                }
            }
        }
        return result;
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper().disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).registerModule((Module)new Jdk8Module());
        this.objectMapperConfigurerSupplier.get().configure(mapper);
        InjectableValues.Std injectableValues = new InjectableValues.Std();
        injectableValues.addValue(ObjectMapper.class, (Object)mapper);
        mapper.setInjectableValues((InjectableValues)injectableValues);
        return mapper;
    }

    public ObjectReader getGraphQLRequestMapper() {
        return this.getJacksonMapper().reader().forType(GraphQLRequest.class);
    }

    public GraphQLRequest readGraphQLRequest(InputStream inputStream) throws IOException {
        return (GraphQLRequest)this.getGraphQLRequestMapper().readValue(inputStream);
    }

    public GraphQLRequest readGraphQLRequest(String text) throws IOException {
        return (GraphQLRequest)this.getGraphQLRequestMapper().readValue(text);
    }

    public List<GraphQLRequest> readBatchedGraphQLRequest(InputStream inputStream) throws IOException {
        MappingIterator iterator = this.getGraphQLRequestMapper().readValues(inputStream);
        ArrayList<GraphQLRequest> requests = new ArrayList<GraphQLRequest>();
        while (iterator.hasNext()) {
            requests.add((GraphQLRequest)iterator.next());
        }
        return requests;
    }

    public List<GraphQLRequest> readBatchedGraphQLRequest(String query) throws IOException {
        MappingIterator iterator = this.getGraphQLRequestMapper().readValues(query);
        ArrayList<GraphQLRequest> requests = new ArrayList<GraphQLRequest>();
        while (iterator.hasNext()) {
            requests.add((GraphQLRequest)iterator.next());
        }
        return requests;
    }

    public String serializeResultAsJson(ExecutionResult executionResult) {
        try {
            return this.getJacksonMapper().writeValueAsString(this.createResultFromExecutionResult(executionResult));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean areErrorsPresent(ExecutionResult executionResult) {
        return this.graphQLErrorHandlerSupplier.get().errorsPresent(executionResult.getErrors());
    }

    public ExecutionResult sanitizeErrors(ExecutionResult executionResult) {
        Object data = executionResult.getData();
        Map extensions = executionResult.getExtensions();
        List<Object> errors = executionResult.getErrors();
        GraphQLErrorHandler errorHandler = this.graphQLErrorHandlerSupplier.get();
        errors = errorHandler.errorsPresent(errors) ? errorHandler.processErrors(errors) : null;
        return new ExecutionResultImpl(data, errors, extensions);
    }

    public Map<String, Object> createResultFromExecutionResult(ExecutionResult executionResult) {
        return this.convertSanitizedExecutionResult(this.sanitizeErrors(executionResult));
    }

    public Map<String, Object> convertSanitizedExecutionResult(ExecutionResult executionResult) {
        return this.convertSanitizedExecutionResult(executionResult, true);
    }

    public Map<String, Object> convertSanitizedExecutionResult(ExecutionResult executionResult, boolean includeData) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (includeData) {
            result.put("data", executionResult.getData());
        }
        if (this.areErrorsPresent(executionResult)) {
            result.put("errors", executionResult.getErrors());
        }
        if (executionResult.getExtensions() != null) {
            result.put("extensions", executionResult.getExtensions());
        }
        return result;
    }

    public Map<String, Object> deserializeVariables(String variables) {
        try {
            return VariablesDeserializer.deserializeVariablesObject(this.getJacksonMapper().readValue(variables, Object.class), this.getJacksonMapper());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Supplier<ObjectMapperConfigurer> objectMapperConfigurer = DefaultObjectMapperConfigurer::new;
        private Supplier<GraphQLErrorHandler> graphQLErrorHandler = DefaultGraphQLErrorHandler::new;

        public Builder withObjectMapperConfigurer(ObjectMapperConfigurer objectMapperConfigurer) {
            return this.withObjectMapperConfigurer(() -> objectMapperConfigurer);
        }

        public Builder withObjectMapperConfigurer(Supplier<ObjectMapperConfigurer> objectMapperConfigurer) {
            this.objectMapperConfigurer = objectMapperConfigurer;
            return this;
        }

        public Builder withGraphQLErrorHandler(GraphQLErrorHandler graphQLErrorHandler) {
            return this.withGraphQLErrorHandler(() -> graphQLErrorHandler);
        }

        public Builder withGraphQLErrorHandler(Supplier<GraphQLErrorHandler> graphQLErrorHandler) {
            this.graphQLErrorHandler = graphQLErrorHandler;
            return this;
        }

        public GraphQLObjectMapper build() {
            return new GraphQLObjectMapper(this.objectMapperConfigurer, this.graphQLErrorHandler);
        }
    }
}

