/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet;

import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.execution.SubscriptionExecutionStrategy;
import graphql.servlet.ExecutionStrategyProvider;
import java.util.function.Supplier;

public class DefaultExecutionStrategyProvider
implements ExecutionStrategyProvider {
    private final ExecutionStrategy queryExecutionStrategy;
    private final ExecutionStrategy mutationExecutionStrategy;
    private final ExecutionStrategy subscriptionExecutionStrategy;

    public DefaultExecutionStrategyProvider() {
        this(null);
    }

    public DefaultExecutionStrategyProvider(ExecutionStrategy executionStrategy) {
        this(executionStrategy, null, null);
    }

    public DefaultExecutionStrategyProvider(ExecutionStrategy queryExecutionStrategy, ExecutionStrategy mutationExecutionStrategy, ExecutionStrategy subscriptionExecutionStrategy) {
        this.queryExecutionStrategy = this.defaultIfNull(queryExecutionStrategy);
        this.mutationExecutionStrategy = this.defaultIfNull(mutationExecutionStrategy, () -> this.queryExecutionStrategy);
        this.subscriptionExecutionStrategy = this.defaultIfNull(subscriptionExecutionStrategy, SubscriptionExecutionStrategy::new);
    }

    private ExecutionStrategy defaultIfNull(ExecutionStrategy executionStrategy) {
        return this.defaultIfNull(executionStrategy, AsyncExecutionStrategy::new);
    }

    private ExecutionStrategy defaultIfNull(ExecutionStrategy executionStrategy, Supplier<ExecutionStrategy> defaultStrategy) {
        return executionStrategy != null ? executionStrategy : defaultStrategy.get();
    }

    @Override
    public ExecutionStrategy getQueryExecutionStrategy() {
        return this.queryExecutionStrategy;
    }

    @Override
    public ExecutionStrategy getMutationExecutionStrategy() {
        return this.mutationExecutionStrategy;
    }

    @Override
    public ExecutionStrategy getSubscriptionExecutionStrategy() {
        return this.subscriptionExecutionStrategy;
    }
}

