/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.GraphQLError;
import graphql.execution.instrumentation.Instrumentation;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLSchema;
import graphql.servlet.DefaultObjectMapperConfigurer;
import graphql.servlet.ExecutionStrategyProvider;
import graphql.servlet.GraphQLContext;
import graphql.servlet.GraphQLErrorHandler;
import graphql.servlet.GraphQLMBean;
import graphql.servlet.GraphQLSchemaProvider;
import graphql.servlet.GraphQLServletListener;
import graphql.servlet.LazyObjectMapperBuilder;
import graphql.servlet.ObjectMapperConfigurer;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GraphQLServlet
extends HttpServlet
implements Servlet,
GraphQLMBean {
    public static final Logger log = LoggerFactory.getLogger(GraphQLServlet.class);
    public static final String APPLICATION_JSON_UTF8 = "application/json;charset=UTF-8";
    public static final int STATUS_OK = 200;
    public static final int STATUS_BAD_REQUEST = 400;
    private final LazyObjectMapperBuilder lazyObjectMapperBuilder;
    private final List<GraphQLServletListener> listeners;
    private final ServletFileUpload fileUpload;
    private final RequestHandler getHandler;
    private final RequestHandler postHandler;

    protected abstract GraphQLSchemaProvider getSchemaProvider();

    protected abstract GraphQLContext createContext(Optional<HttpServletRequest> var1, Optional<HttpServletResponse> var2);

    protected abstract Object createRootObject(Optional<HttpServletRequest> var1, Optional<HttpServletResponse> var2);

    protected abstract ExecutionStrategyProvider getExecutionStrategyProvider();

    protected abstract Instrumentation getInstrumentation();

    protected abstract Map<String, Object> transformVariables(GraphQLSchema var1, String var2, Map<String, Object> var3);

    protected abstract GraphQLErrorHandler getGraphQLErrorHandler();

    public GraphQLServlet() {
        this(null, null, null);
    }

    public GraphQLServlet(ObjectMapperConfigurer objectMapperConfigurer, List<GraphQLServletListener> listeners, FileItemFactory fileItemFactory) {
        this.lazyObjectMapperBuilder = new LazyObjectMapperBuilder(objectMapperConfigurer != null ? objectMapperConfigurer : new DefaultObjectMapperConfigurer());
        this.listeners = listeners != null ? new ArrayList<GraphQLServletListener>(listeners) : new ArrayList();
        this.fileUpload = new ServletFileUpload((FileItemFactory)(fileItemFactory != null ? fileItemFactory : new DiskFileItemFactory()));
        this.getHandler = (request, response) -> {
            GraphQLContext context = this.createContext(Optional.of(request), Optional.of(response));
            Object rootObject = this.createRootObject(Optional.of(request), Optional.of(response));
            String path = request.getPathInfo();
            if (path == null) {
                path = request.getServletPath();
            }
            if (path.contentEquals("/schema.json")) {
                this.query("\n  query IntrospectionQuery {\n    __schema {\n      queryType { name }\n      mutationType { name }\n      subscriptionType { name }\n      types {\n        ...FullType\n      }\n      directives {\n        name\n        description\n        locations\n        args {\n          ...InputValue\n        }\n      }\n    }\n  }\n\n  fragment FullType on __Type {\n    kind\n    name\n    description\n    fields(includeDeprecated: true) {\n      name\n      description\n      args {\n        ...InputValue\n      }\n      type {\n        ...TypeRef\n      }\n      isDeprecated\n      deprecationReason\n    }\n    inputFields {\n      ...InputValue\n    }\n    interfaces {\n      ...TypeRef\n    }\n    enumValues(includeDeprecated: true) {\n      name\n      description\n      isDeprecated\n      deprecationReason\n    }\n    possibleTypes {\n      ...TypeRef\n    }\n  }\n\n  fragment InputValue on __InputValue {\n    name\n    description\n    type { ...TypeRef }\n    defaultValue\n  }\n\n  fragment TypeRef on __Type {\n    kind\n    name\n    ofType {\n      kind\n      name\n      ofType {\n        kind\n        name\n        ofType {\n          kind\n          name\n        }\n      }\n    }\n  }\n", null, new HashMap<String, Object>(), this.getSchemaProvider().getSchema(request), request, response, context, rootObject);
            } else if (request.getParameter("query") != null) {
                HashMap<String, Object> variables = new HashMap<String, Object>();
                if (request.getParameter("variables") != null) {
                    variables.putAll(this.deserializeVariables(request.getParameter("variables")));
                }
                String operationName = null;
                if (request.getParameter("operationName") != null) {
                    operationName = request.getParameter("operationName");
                }
                this.query(request.getParameter("query"), operationName, variables, this.getSchemaProvider().getReadOnlySchema(request), request, response, context, rootObject);
            } else {
                response.setStatus(400);
                log.info("Bad GET request: path was not \"/schema.json\" or no query variable named \"query\" given");
            }
        };
        this.postHandler = (request, response) -> {
            GraphQLContext context = this.createContext(Optional.of(request), Optional.of(response));
            Object rootObject = this.createRootObject(Optional.of(request), Optional.of(response));
            GraphQLRequest graphQLRequest = null;
            try {
                Object inputStream = null;
                if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                    Optional<FileItem> queryItem;
                    Map fileItems = this.fileUpload.parseParameterMap(request);
                    if (fileItems.containsKey("graphql")) {
                        Optional<FileItem> graphqlItem = this.getFileItem(fileItems, "graphql");
                        if (graphqlItem.isPresent()) {
                            inputStream = graphqlItem.get().getInputStream();
                        }
                    } else if (fileItems.containsKey("query") && (queryItem = this.getFileItem(fileItems, "query")).isPresent()) {
                        String variables;
                        Optional<FileItem> variablesItem;
                        graphQLRequest = new GraphQLRequest();
                        graphQLRequest.setQuery(new String(queryItem.get().get()));
                        Optional<FileItem> operationNameItem = this.getFileItem(fileItems, "operationName");
                        if (operationNameItem.isPresent()) {
                            graphQLRequest.setOperationName(new String(operationNameItem.get().get()).trim());
                        }
                        if ((variablesItem = this.getFileItem(fileItems, "variables")).isPresent() && !(variables = new String(variablesItem.get().get())).isEmpty()) {
                            graphQLRequest.setVariables(this.deserializeVariables(variables));
                        }
                    }
                    if (inputStream == null && graphQLRequest == null) {
                        response.setStatus(400);
                        log.info("Bad POST multipart request: no part named \"graphql\" or \"query\"");
                        return;
                    }
                    context.setFiles(Optional.of(fileItems));
                } else {
                    inputStream = request.getInputStream();
                }
                if (graphQLRequest == null) {
                    graphQLRequest = (GraphQLRequest)this.getGraphQLRequestMapper().readValue((InputStream)inputStream);
                }
            }
            catch (Exception e) {
                log.info("Bad POST request: parsing failed", (Throwable)e);
                response.setStatus(400);
                return;
            }
            Map<String, Object> variables = graphQLRequest.getVariables();
            if (variables == null) {
                variables = new HashMap<String, Object>();
            }
            this.query(graphQLRequest.getQuery(), graphQLRequest.getOperationName(), variables, this.getSchemaProvider().getSchema(request), request, response, context, rootObject);
        };
    }

    protected ObjectMapper getMapper() {
        return this.lazyObjectMapperBuilder.getMapper();
    }

    private ObjectReader getGraphQLRequestMapper() {
        InjectableValues.Std injectableValues = new InjectableValues.Std();
        injectableValues.addValue(ObjectMapper.class, (Object)this.getMapper());
        return this.getMapper().reader((InjectableValues)injectableValues).forType(GraphQLRequest.class);
    }

    public void addListener(GraphQLServletListener servletListener) {
        this.listeners.add(servletListener);
    }

    public void removeListener(GraphQLServletListener servletListener) {
        this.listeners.remove(servletListener);
    }

    @Override
    public String[] getQueries() {
        return (String[])this.getSchemaProvider().getSchema().getQueryType().getFieldDefinitions().stream().map(GraphQLFieldDefinition::getName).toArray(String[]::new);
    }

    @Override
    public String[] getMutations() {
        return (String[])this.getSchemaProvider().getSchema().getMutationType().getFieldDefinitions().stream().map(GraphQLFieldDefinition::getName).toArray(String[]::new);
    }

    @Override
    public String executeQuery(String query) {
        try {
            ExecutionResult result = this.newGraphQL(this.getSchemaProvider().getSchema()).execute(new ExecutionInput(query, null, (Object)this.createContext(Optional.empty(), Optional.empty()), this.createRootObject(Optional.empty(), Optional.empty()), new HashMap()));
            return this.getMapper().writeValueAsString(this.createResultFromDataAndErrors(result.getData(), result.getErrors()));
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRequest(HttpServletRequest request, HttpServletResponse response, RequestHandler handler) {
        List<GraphQLServletListener.RequestCallback> requestCallbacks = this.runListeners(l -> l.onRequest(request, response));
        try {
            handler.handle(request, response);
            this.runCallbacks(requestCallbacks, c -> c.onSuccess(request, response));
        }
        catch (Throwable t) {
            response.setStatus(500);
            log.error("Error executing GraphQL request!", t);
            this.runCallbacks(requestCallbacks, c -> c.onError(request, response, t));
        }
        finally {
            this.runCallbacks(requestCallbacks, c -> c.onFinally(request, response));
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doRequest(req, resp, this.getHandler);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doRequest(req, resp, this.postHandler);
    }

    private Optional<FileItem> getFileItem(Map<String, List<FileItem>> fileItems, String name) {
        List<FileItem> items = fileItems.get(name);
        if (items == null || items.isEmpty()) {
            return Optional.empty();
        }
        return items.stream().findFirst();
    }

    private GraphQL newGraphQL(GraphQLSchema schema) {
        ExecutionStrategyProvider executionStrategyProvider = this.getExecutionStrategyProvider();
        return GraphQL.newGraphQL((GraphQLSchema)schema).queryExecutionStrategy(executionStrategyProvider.getQueryExecutionStrategy()).mutationExecutionStrategy(executionStrategyProvider.getMutationExecutionStrategy()).subscriptionExecutionStrategy(executionStrategyProvider.getSubscriptionExecutionStrategy()).instrumentation(this.getInstrumentation()).build();
    }

    private void query(String query, String operationName, Map<String, Object> variables, GraphQLSchema schema, HttpServletRequest req, HttpServletResponse resp, GraphQLContext context, Object rootObject) throws IOException {
        if (operationName != null && operationName.isEmpty()) {
            this.query(query, null, variables, schema, req, resp, context, rootObject);
        } else if (Subject.getSubject(AccessController.getContext()) == null && context.getSubject().isPresent()) {
            Subject.doAs(context.getSubject().get(), () -> {
                try {
                    this.query(query, operationName, variables, schema, req, resp, context, rootObject);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return null;
            });
        } else {
            List<GraphQLServletListener.OperationCallback> operationCallbacks = this.runListeners(l -> l.onOperation(context, operationName, query, variables));
            ExecutionResult executionResult = this.newGraphQL(schema).execute(new ExecutionInput(query, operationName, (Object)context, rootObject, this.transformVariables(schema, query, variables)));
            List errors = executionResult.getErrors();
            Object data = executionResult.getData();
            String response = this.getMapper().writeValueAsString(this.createResultFromDataAndErrors(data, errors));
            resp.setContentType(APPLICATION_JSON_UTF8);
            resp.setStatus(200);
            resp.getWriter().write(response);
            if (this.getGraphQLErrorHandler().errorsPresent(errors)) {
                this.runCallbacks(operationCallbacks, c -> c.onError(context, operationName, query, variables, data, errors));
            } else {
                this.runCallbacks(operationCallbacks, c -> c.onSuccess(context, operationName, query, variables, data));
            }
            this.runCallbacks(operationCallbacks, c -> c.onFinally(context, operationName, query, variables, data));
        }
    }

    private Map<String, Object> createResultFromDataAndErrors(Object data, List<GraphQLError> errors) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("data", data);
        if (this.getGraphQLErrorHandler().errorsPresent(errors)) {
            result.put("errors", this.getGraphQLErrorHandler().processErrors(errors));
        }
        return result;
    }

    private <R> List<R> runListeners(Function<? super GraphQLServletListener, R> action) {
        if (this.listeners == null) {
            return Collections.emptyList();
        }
        return this.listeners.stream().map(listener -> {
            try {
                return action.apply((GraphQLServletListener)listener);
            }
            catch (Throwable t) {
                log.error("Error running listener: {}", listener, (Object)t);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private <T> void runCallbacks(List<T> callbacks, Consumer<T> action) {
        callbacks.forEach(callback -> {
            try {
                action.accept(callback);
            }
            catch (Throwable t) {
                log.error("Error running callback: {}", callback, (Object)t);
            }
        });
    }

    private Map<String, Object> deserializeVariables(String variables) {
        try {
            return GraphQLServlet.deserializeVariablesObject(this.getMapper().readValue(variables, Object.class), this.getMapper());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, Object> deserializeVariablesObject(Object variables, ObjectMapper mapper) {
        if (variables instanceof Map) {
            Map genericVariables = (Map)variables;
            return genericVariables;
        }
        if (variables instanceof String) {
            try {
                return (Map)mapper.readValue((String)variables, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("variables should be either an object or a string");
    }

    protected static interface RequestHandler
    extends BiConsumer<HttpServletRequest, HttpServletResponse> {
        @Override
        default public void accept(HttpServletRequest request, HttpServletResponse response) {
            try {
                this.handle(request, response);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void handle(HttpServletRequest var1, HttpServletResponse var2) throws Exception;
    }

    protected static class GraphQLRequest {
        private String query;
        @JsonDeserialize(using=VariablesDeserializer.class)
        private Map<String, Object> variables = new HashMap<String, Object>();
        private String operationName;

        protected GraphQLRequest() {
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public Map<String, Object> getVariables() {
            return this.variables;
        }

        public void setVariables(Map<String, Object> variables) {
            this.variables = variables;
        }

        public String getOperationName() {
            return this.operationName;
        }

        public void setOperationName(String operationName) {
            this.operationName = operationName;
        }
    }

    protected static class VariablesDeserializer
    extends JsonDeserializer<Map<String, Object>> {
        protected VariablesDeserializer() {
        }

        public Map<String, Object> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return GraphQLServlet.deserializeVariablesObject(p.readValueAs(Object.class), (ObjectMapper)ctxt.findInjectableValue((Object)ObjectMapper.class.getName(), null, null));
        }
    }
}

