/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.shared.impl.posers;

import com.google.web.bindery.requestfactory.shared.impl.Poser;
import java.util.Date;

public class DatePoser
extends Date
implements Poser<Date> {
    private boolean frozen;

    public DatePoser(Date copy) {
        super(copy.getTime());
        this.setFrozen(true);
    }

    @Override
    public Date getPosedValue() {
        return new Date(this.getTime());
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public void setDate(int date) {
        this.checkFrozen();
        super.setDate(date);
    }

    @Override
    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    @Override
    public void setHours(int hours) {
        this.checkFrozen();
        super.setHours(hours);
    }

    @Override
    public void setMinutes(int minutes) {
        this.checkFrozen();
        super.setMinutes(minutes);
    }

    @Override
    public void setMonth(int month) {
        this.checkFrozen();
        super.setMonth(month);
    }

    @Override
    public void setSeconds(int seconds) {
        this.checkFrozen();
        super.setSeconds(seconds);
    }

    @Override
    public void setTime(long time) {
        this.checkFrozen();
        super.setTime(time);
    }

    @Override
    public void setYear(int year) {
        this.checkFrozen();
        super.setYear(year);
    }

    private void checkFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("The Date has been frozen");
        }
    }
}

