/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.gson.FieldNamingPolicy;
import com.google.maps.GeoApiContext;
import com.google.maps.PendingResult;
import com.google.maps.errors.ApiException;
import com.google.maps.internal.ApiConfig;
import com.google.maps.internal.ApiResponse;
import com.google.maps.model.LatLng;
import java.util.TimeZone;

public class TimeZoneApi {
    private static final ApiConfig API_CONFIG = new ApiConfig("/maps/api/timezone/json").fieldNamingPolicy(FieldNamingPolicy.IDENTITY);

    private TimeZoneApi() {
    }

    public static PendingResult<TimeZone> getTimeZone(GeoApiContext context, LatLng location) {
        return context.get(API_CONFIG, Response.class, "location", location.toString(), "timestamp", "0");
    }

    private static class Response
    implements ApiResponse<TimeZone> {
        public String status;
        public String errorMessage;
        private String timeZoneId;

        private Response() {
        }

        @Override
        public boolean successful() {
            return "OK".equals(this.status);
        }

        @Override
        public TimeZone getResult() {
            if (this.timeZoneId == null) {
                return null;
            }
            return TimeZone.getTimeZone(this.timeZoneId);
        }

        @Override
        public ApiException getError() {
            if (this.successful()) {
                return null;
            }
            return ApiException.from(this.status, this.errorMessage);
        }
    }
}

