/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.maps.GeoApiContext;
import com.google.maps.PendingResult;
import com.google.maps.errors.ApiException;
import com.google.maps.internal.ApiConfig;
import com.google.maps.internal.ApiResponse;
import com.google.maps.internal.PolylineEncoding;
import com.google.maps.internal.StringJoin;
import com.google.maps.model.ElevationResult;
import com.google.maps.model.EncodedPolyline;
import com.google.maps.model.LatLng;

public class ElevationApi {
    private static final ApiConfig API_CONFIG = new ApiConfig("/maps/api/elevation/json");

    private ElevationApi() {
    }

    public static PendingResult<ElevationResult[]> getByPoints(GeoApiContext context, LatLng ... points) {
        return context.get(API_CONFIG, MultiResponse.class, "locations", ElevationApi.shortestParam(points));
    }

    public static PendingResult<ElevationResult[]> getByPath(GeoApiContext context, int samples, LatLng ... path) {
        return context.get(API_CONFIG, MultiResponse.class, "samples", String.valueOf(samples), "path", ElevationApi.shortestParam(path));
    }

    public static PendingResult<ElevationResult[]> getByPath(GeoApiContext context, int samples, EncodedPolyline encodedPolyline) {
        return context.get(API_CONFIG, MultiResponse.class, "samples", String.valueOf(samples), "path", "enc:" + encodedPolyline.getEncodedPath());
    }

    private static String shortestParam(LatLng[] points) {
        String joined = StringJoin.join('|', points);
        String encoded = "enc:" + PolylineEncoding.encode(points);
        return joined.length() < encoded.length() ? joined : encoded;
    }

    public static PendingResult<ElevationResult> getByPoint(GeoApiContext context, LatLng location) {
        return context.get(API_CONFIG, SingularResponse.class, "locations", location.toString());
    }

    public static PendingResult<ElevationResult[]> getByPoints(GeoApiContext context, EncodedPolyline encodedPolyline) {
        return context.get(API_CONFIG, MultiResponse.class, "locations", "enc:" + encodedPolyline.getEncodedPath());
    }

    private static class MultiResponse
    implements ApiResponse<ElevationResult[]> {
        public String status;
        public String errorMessage;
        public ElevationResult[] results;

        private MultiResponse() {
        }

        @Override
        public boolean successful() {
            return "OK".equals(this.status);
        }

        @Override
        public ElevationResult[] getResult() {
            return this.results;
        }

        @Override
        public ApiException getError() {
            if (this.successful()) {
                return null;
            }
            return ApiException.from(this.status, this.errorMessage);
        }
    }

    private static class SingularResponse
    implements ApiResponse<ElevationResult> {
        public String status;
        public String errorMessage;
        public ElevationResult[] results;

        private SingularResponse() {
        }

        @Override
        public boolean successful() {
            return "OK".equals(this.status);
        }

        @Override
        public ElevationResult getResult() {
            return this.results[0];
        }

        @Override
        public ApiException getError() {
            if (this.successful()) {
                return null;
            }
            return ApiException.from(this.status, this.errorMessage);
        }
    }
}

