/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.ValueType;
import com.google.javascript.rhino.jstype.Visitor;

public class NumberType
extends ValueType {
    private static final long serialVersionUID = 1L;

    NumberType(JSTypeRegistry jSTypeRegistry) {
        super(jSTypeRegistry);
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public TernaryValue testForEquality(JSType jSType) {
        TernaryValue ternaryValue = super.testForEquality(jSType);
        if (ternaryValue != null) {
            return ternaryValue;
        }
        if (jSType.isUnknownType() || jSType.isSubtype(this.getNativeType(JSTypeNative.OBJECT_NUMBER_STRING_BOOLEAN))) {
            return TernaryValue.UNKNOWN;
        }
        return TernaryValue.FALSE;
    }

    @Override
    public boolean isNumberValueType() {
        return true;
    }

    @Override
    public boolean matchesNumberContext() {
        return true;
    }

    @Override
    public boolean matchesStringContext() {
        return true;
    }

    @Override
    public boolean matchesObjectContext() {
        return true;
    }

    public String toString() {
        return "number";
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        return BooleanLiteralSet.BOTH;
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseNumberType();
    }

    @Override
    public JSType autoboxesTo() {
        return this.getNativeType(JSTypeNative.NUMBER_OBJECT_TYPE);
    }
}

