/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;

public abstract class PassFactory {
    private final String name;
    private final boolean isOneTimePass;
    private boolean isCreated = false;

    protected PassFactory(String string, boolean bl) {
        this.name = string;
        this.isOneTimePass = bl;
    }

    String getName() {
        return this.name;
    }

    boolean isOneTimePass() {
        return this.isOneTimePass;
    }

    PassFactory makeOneTimePass() {
        if (this.isOneTimePass()) {
            return this;
        }
        final PassFactory passFactory = this;
        return new PassFactory(this.name, true){

            @Override
            protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
                return passFactory.createInternal(abstractCompiler);
            }
        };
    }

    final CompilerPass create(AbstractCompiler abstractCompiler) {
        Preconditions.checkState((!this.isCreated || !this.isOneTimePass ? 1 : 0) != 0, (Object)("One-time passes cannot be run multiple times: " + this.name));
        this.isCreated = true;
        return this.createInternal(abstractCompiler);
    }

    protected abstract CompilerPass createInternal(AbstractCompiler var1);
}

