/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AliasExternals;
import com.google.javascript.jscomp.AliasKeywords;
import com.google.javascript.jscomp.AliasStrings;
import com.google.javascript.jscomp.AmbiguateProperties;
import com.google.javascript.jscomp.AnonymousFunctionNamingPolicy;
import com.google.javascript.jscomp.ChainCalls;
import com.google.javascript.jscomp.CheckAccessControls;
import com.google.javascript.jscomp.CheckAccidentalSemicolon;
import com.google.javascript.jscomp.CheckGlobalNames;
import com.google.javascript.jscomp.CheckGlobalThis;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CheckMissingGetCssName;
import com.google.javascript.jscomp.CheckMissingReturn;
import com.google.javascript.jscomp.CheckProvides;
import com.google.javascript.jscomp.CheckRegExp;
import com.google.javascript.jscomp.CheckRequiresForConstructors;
import com.google.javascript.jscomp.CheckSideEffects;
import com.google.javascript.jscomp.CheckUnreachableCode;
import com.google.javascript.jscomp.ClosureCodeRemoval;
import com.google.javascript.jscomp.CoalesceVariableNames;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CollapseAnonymousFunctions;
import com.google.javascript.jscomp.CollapseProperties;
import com.google.javascript.jscomp.CollapseVariableDeclarations;
import com.google.javascript.jscomp.CombinedCompilerPass;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ConstCheck;
import com.google.javascript.jscomp.ControlStructureCheck;
import com.google.javascript.jscomp.ConvertToDottedProperties;
import com.google.javascript.jscomp.CreateSyntheticBlocks;
import com.google.javascript.jscomp.CrossModuleCodeMotion;
import com.google.javascript.jscomp.CrossModuleMethodMotion;
import com.google.javascript.jscomp.CustomPassExecutionTime;
import com.google.javascript.jscomp.DeadAssignmentsElimination;
import com.google.javascript.jscomp.Denormalize;
import com.google.javascript.jscomp.DevirtualizePrototypeMethods;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.DisambiguateProperties;
import com.google.javascript.jscomp.DotFormatter;
import com.google.javascript.jscomp.ErrorPass;
import com.google.javascript.jscomp.ExportTestFunctions;
import com.google.javascript.jscomp.ExtractPrototypeMemberDeclarations;
import com.google.javascript.jscomp.FlowSensitiveInlineVariables;
import com.google.javascript.jscomp.FunctionNames;
import com.google.javascript.jscomp.FunctionRewriter;
import com.google.javascript.jscomp.GatherRawExports;
import com.google.javascript.jscomp.GenerateExports;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.GroupVariableDeclarations;
import com.google.javascript.jscomp.IgnoreCajaProperties;
import com.google.javascript.jscomp.InlineFunctions;
import com.google.javascript.jscomp.InlineGetters;
import com.google.javascript.jscomp.InlineVariables;
import com.google.javascript.jscomp.InstrumentFunctions;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsMessage;
import com.google.javascript.jscomp.MakeDeclaredNamesUnique;
import com.google.javascript.jscomp.MarkNoSideEffectCalls;
import com.google.javascript.jscomp.MinimizeExitPoints;
import com.google.javascript.jscomp.MoveFunctionDeclarations;
import com.google.javascript.jscomp.NameAnalyzer;
import com.google.javascript.jscomp.NameAnonymousFunctions;
import com.google.javascript.jscomp.NameAnonymousFunctionsMapped;
import com.google.javascript.jscomp.NameReferenceGraphConstruction;
import com.google.javascript.jscomp.NameReferenceGraphReport;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.ObjectPropertyStringPostprocess;
import com.google.javascript.jscomp.ObjectPropertyStringPreprocess;
import com.google.javascript.jscomp.OptimizeArgumentsArray;
import com.google.javascript.jscomp.OptimizeCalls;
import com.google.javascript.jscomp.OptimizeParameters;
import com.google.javascript.jscomp.OptimizeReturns;
import com.google.javascript.jscomp.PassConfig;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.PeepholeFoldConstants;
import com.google.javascript.jscomp.PeepholeOptimizationsPass;
import com.google.javascript.jscomp.PeepholeRemoveDeadCode;
import com.google.javascript.jscomp.PeepholeSubstituteAlternateSyntax;
import com.google.javascript.jscomp.ProcessClosurePrimitives;
import com.google.javascript.jscomp.ProcessDefines;
import com.google.javascript.jscomp.PropertyRenamingPolicy;
import com.google.javascript.jscomp.PureFunctionIdentifier;
import com.google.javascript.jscomp.RemoveUnusedPrototypeProperties;
import com.google.javascript.jscomp.RemoveUnusedVars;
import com.google.javascript.jscomp.RenameLabels;
import com.google.javascript.jscomp.RenameProperties;
import com.google.javascript.jscomp.RenamePrototypes;
import com.google.javascript.jscomp.RenameVars;
import com.google.javascript.jscomp.ReplaceCssNames;
import com.google.javascript.jscomp.ReplaceIdGenerators;
import com.google.javascript.jscomp.ReplaceMessages;
import com.google.javascript.jscomp.ReplaceStrings;
import com.google.javascript.jscomp.RuntimeTypeCheck;
import com.google.javascript.jscomp.ScopedAliases;
import com.google.javascript.jscomp.SpecializeModule;
import com.google.javascript.jscomp.StrictModeCheck;
import com.google.javascript.jscomp.SuspiciousPropertiesCheck;
import com.google.javascript.jscomp.TightenTypes;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.UnreachableCodeElimination;
import com.google.javascript.jscomp.VarCheck;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.jscomp.VariableReferenceCheck;
import com.google.javascript.jscomp.VariableRenamingPolicy;
import com.google.javascript.jscomp.VariableShadowDeclarationCheck;
import com.google.javascript.rhino.Node;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultPassConfig
extends PassConfig {
    private static final String COMPILED_CONSTANT_NAME = "COMPILED";
    private static final String CLOSURE_LOCALE_CONSTANT_NAME = "goog.LOCALE";
    static final DiagnosticType TIGHTEN_TYPES_WITHOUT_TYPE_CHECK = DiagnosticType.error("JSC_TIGHTEN_TYPES_WITHOUT_TYPE_CHECK", "TightenTypes requires type checking. Please use --check_types.");
    static final DiagnosticType CANNOT_USE_PROTOTYPE_AND_VAR = DiagnosticType.error("JSC_CANNOT_USE_PROTOTYPE_AND_VAR", "Rename prototypes and inline variables cannot be used together");
    static final DiagnosticType REPORT_PATH_IO_ERROR = DiagnosticType.error("JSC_REPORT_PATH_IO_ERROR", "Error writing compiler report to {0}");
    private static final DiagnosticType INPUT_MAP_PROP_PARSE = DiagnosticType.error("JSC_INPUT_MAP_PROP_PARSE", "Input property map parse error: {0}");
    private static final DiagnosticType INPUT_MAP_VAR_PARSE = DiagnosticType.error("JSC_INPUT_MAP_VAR_PARSE", "Input variable map parse error: {0}");
    private static final DiagnosticType NAME_REF_GRAPH_FILE_ERROR = DiagnosticType.error("JSC_NAME_REF_GRAPH_FILE_ERROR", "Error \"{1}\" writing name reference graph to \"{0}\".");
    private static final DiagnosticType NAME_REF_REPORT_FILE_ERROR = DiagnosticType.error("JSC_NAME_REF_REPORT_FILE_ERROR", "Error \"{1}\" writing name reference report to \"{0}\".");
    private GlobalNamespace namespaceForChecks = null;
    private TightenTypes tightenTypes = null;
    private Set<String> exportedNames = null;
    private CrossModuleMethodMotion.IdGenerator crossModuleIdGenerator = new CrossModuleMethodMotion.IdGenerator();
    private Map<String, Integer> cssNames = null;
    private VariableMap variableMap = null;
    private VariableMap propertyMap = null;
    private VariableMap anonymousFunctionNameMap = null;
    private FunctionNames functionNames = null;
    private VariableMap stringMap = null;
    private String idGeneratorMap = null;
    final PassFactory suspiciousCode = new PassFactory("suspiciousCode", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            CheckLevel checkLevel;
            ArrayList arrayList = Lists.newArrayList();
            if (DefaultPassConfig.this.options.checkSuspiciousCode) {
                arrayList.add(new CheckAccidentalSemicolon(CheckLevel.WARNING));
                arrayList.add(new CheckSideEffects(CheckLevel.WARNING));
            }
            if ((checkLevel = DefaultPassConfig.this.options.checkGlobalThisLevel).isOn()) {
                arrayList.add(new CheckGlobalThis(abstractCompiler, checkLevel));
            }
            return DefaultPassConfig.combineChecks(abstractCompiler, arrayList);
        }
    };
    private final PassFactory checkControlStructures = new PassFactory("checkControlStructures", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new ControlStructureCheck(abstractCompiler);
        }
    };
    private final PassFactory checkRequires = new PassFactory("checkRequires", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new CheckRequiresForConstructors(abstractCompiler, DefaultPassConfig.this.options.checkRequires);
        }
    };
    private final PassFactory checkProvides = new PassFactory("checkProvides", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new CheckProvides(abstractCompiler, DefaultPassConfig.this.options.checkProvides);
        }
    };
    private static final DiagnosticType GENERATE_EXPORTS_ERROR = DiagnosticType.error("JSC_GENERATE_EXPORTS_ERROR", "Exports can only be generated if export symbol/property functions are set.");
    private final PassFactory generateExports = new PassFactory("generateExports", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            CodingConvention codingConvention = abstractCompiler.getCodingConvention();
            if (codingConvention.getExportSymbolFunction() != null && codingConvention.getExportPropertyFunction() != null) {
                return new GenerateExports(abstractCompiler, codingConvention.getExportSymbolFunction(), codingConvention.getExportPropertyFunction());
            }
            return new ErrorPass(abstractCompiler, GENERATE_EXPORTS_ERROR);
        }
    };
    private final PassFactory exportTestFunctions = new PassFactory("exportTestFunctions", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            CodingConvention codingConvention = abstractCompiler.getCodingConvention();
            if (codingConvention.getExportSymbolFunction() != null) {
                return new ExportTestFunctions(abstractCompiler, codingConvention.getExportSymbolFunction());
            }
            return new ErrorPass(abstractCompiler, GENERATE_EXPORTS_ERROR);
        }
    };
    final PassFactory gatherRawExports = new PassFactory("gatherRawExports", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            final GatherRawExports gatherRawExports = new GatherRawExports(abstractCompiler);
            return new CompilerPass(){

                @Override
                public void process(Node node, Node node2) {
                    gatherRawExports.process(node, node2);
                    if (DefaultPassConfig.this.exportedNames == null) {
                        DefaultPassConfig.this.exportedNames = Sets.newHashSet();
                    }
                    DefaultPassConfig.this.exportedNames.addAll(gatherRawExports.getExportedVariableNames());
                }
            };
        }
    };
    final PassFactory closurePrimitives = new PassFactory("processProvidesAndRequires", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            final ProcessClosurePrimitives processClosurePrimitives = new ProcessClosurePrimitives(abstractCompiler, DefaultPassConfig.this.options.brokenClosureRequiresLevel, DefaultPassConfig.this.options.rewriteNewDateGoogNow);
            return new CompilerPass(){

                @Override
                public void process(Node node, Node node2) {
                    processClosurePrimitives.process(node, node2);
                    DefaultPassConfig.this.exportedNames = processClosurePrimitives.getExportedVariableNames();
                }
            };
        }
    };
    private final PassFactory replaceMessages = new PassFactory("replaceMessages", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new ReplaceMessages(abstractCompiler, DefaultPassConfig.this.options.messageBundle, true, JsMessage.Style.getFromParams(true, false), false);
        }
    };
    final PassFactory closureGoogScopeAliases = new PassFactory("processGoogScopeAliases", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new ScopedAliases(abstractCompiler);
        }
    };
    private final PassFactory closureCheckGetCssName = new PassFactory("checkMissingGetCssName", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            String string = DefaultPassConfig.this.options.checkMissingGetCssNameBlacklist;
            Preconditions.checkState((string != null && !string.isEmpty() ? 1 : 0) != 0, (Object)"Not checking use of goog.getCssName because of empty blacklist.");
            return new CheckMissingGetCssName(abstractCompiler, DefaultPassConfig.this.options.checkMissingGetCssNameLevel, string);
        }
    };
    private final PassFactory closureReplaceGetCssName = new PassFactory("renameCssNames", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler abstractCompiler) {
            return new CompilerPass(){

                @Override
                public void process(Node node, Node node2) {
                    HashMap hashMap = null;
                    if (DefaultPassConfig.this.options.gatherCssNames) {
                        hashMap = Maps.newHashMap();
                    }
                    new ReplaceCssNames(abstractCompiler, hashMap).process(node, node2);
                    DefaultPassConfig.this.cssNames = hashMap;
                }
            };
        }
    };
    private final PassFactory createSyntheticBlocks = new PassFactory("createSyntheticBlocks", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new CreateSyntheticBlocks(abstractCompiler, DefaultPassConfig.this.options.syntheticBlockStartMarker, DefaultPassConfig.this.options.syntheticBlockEndMarker);
        }
    };
    private final PassFactory peepholeOptimizations = new PassFactory("peepholeOptimizations", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new PeepholeOptimizationsPass(abstractCompiler, new PeepholeSubstituteAlternateSyntax(), new PeepholeRemoveDeadCode(), new PeepholeFoldConstants());
        }
    };
    private final PassFactory checkVars = new PassFactory("checkVars", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new VarCheck(abstractCompiler);
        }
    };
    private final PassFactory checkRegExp = new PassFactory("checkRegExp", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler abstractCompiler) {
            final CheckRegExp checkRegExp = new CheckRegExp(abstractCompiler);
            return new CompilerPass(){

                @Override
                public void process(Node node, Node node2) {
                    checkRegExp.process(node, node2);
                    abstractCompiler.setHasRegExpGlobalReferences(checkRegExp.isGlobalRegExpPropertiesUsed());
                }
            };
        }
    };
    private final PassFactory checkShadowVars = new PassFactory("variableShadowDeclarationCheck", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new VariableShadowDeclarationCheck(abstractCompiler, DefaultPassConfig.this.options.checkShadowVars);
        }
    };
    private final PassFactory checkVariableReferences = new PassFactory("checkVariableReferences", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new VariableReferenceCheck(abstractCompiler, DefaultPassConfig.this.options.aggressiveVarCheck);
        }
    };
    private final PassFactory objectPropertyStringPreprocess = new PassFactory("ObjectPropertyStringPreprocess", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new ObjectPropertyStringPreprocess(abstractCompiler);
        }
    };
    final PassFactory resolveTypes = new PassFactory("resolveTypes", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new GlobalTypeResolver(abstractCompiler);
        }
    };
    final PassFactory inferTypes = new PassFactory("inferTypes", false){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler abstractCompiler) {
            return new CompilerPass(){

                @Override
                public void process(Node node, Node node2) {
                    Preconditions.checkNotNull((Object)DefaultPassConfig.this.topScope);
                    Preconditions.checkNotNull((Object)DefaultPassConfig.this.typedScopeCreator);
                    DefaultPassConfig.this.makeTypeInference(abstractCompiler).process(node, node2);
                }
            };
        }
    };
    private final PassFactory checkTypes = new PassFactory("checkTypes", false){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler abstractCompiler) {
            return new CompilerPass(){

                @Override
                public void process(Node node, Node node2) {
                    Preconditions.checkNotNull((Object)DefaultPassConfig.this.topScope);
                    Preconditions.checkNotNull((Object)DefaultPassConfig.this.typedScopeCreator);
                    TypeCheck typeCheck = DefaultPassConfig.this.makeTypeCheck(abstractCompiler);
                    typeCheck.process(node, node2);
                    abstractCompiler.getErrorManager().setTypedPercent(typeCheck.getTypedPercent());
                }
            };
        }
    };
    private final PassFactory checkControlFlow = new PassFactory("checkControlFlow", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            ArrayList arrayList = Lists.newArrayList();
            if (DefaultPassConfig.this.options.checkUnreachableCode.isOn()) {
                arrayList.add(new CheckUnreachableCode(abstractCompiler, DefaultPassConfig.this.options.checkUnreachableCode));
            }
            if (DefaultPassConfig.this.options.checkMissingReturn.isOn() && DefaultPassConfig.this.options.checkTypes) {
                arrayList.add(new CheckMissingReturn(abstractCompiler, DefaultPassConfig.this.options.checkMissingReturn));
            }
            return DefaultPassConfig.combineChecks(abstractCompiler, arrayList);
        }
    };
    private final PassFactory checkAccessControls = new PassFactory("checkAccessControls", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new CheckAccessControls(abstractCompiler);
        }
    };
    private final PassFactory checkGlobalNames = new PassFactory("Check names", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler abstractCompiler) {
            return new CompilerPass(){

                @Override
                public void process(Node node, Node node2) {
                    DefaultPassConfig.this.namespaceForChecks = new GlobalNamespace(abstractCompiler, node2);
                    new CheckGlobalNames(abstractCompiler, DefaultPassConfig.this.options.checkGlobalNamesLevel).injectNamespace(DefaultPassConfig.this.namespaceForChecks).process(node, node2);
                }
            };
        }
    };
    private final PassFactory checkSuspiciousProperties = new PassFactory("checkSuspiciousProperties", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new SuspiciousPropertiesCheck(abstractCompiler, DefaultPassConfig.this.options.checkUndefinedProperties, DefaultPassConfig.this.options.checkUnusedPropertiesEarly ? CheckLevel.WARNING : CheckLevel.OFF);
        }
    };
    private final PassFactory checkStrictMode = new PassFactory("checkStrictMode", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new StrictModeCheck(abstractCompiler, !DefaultPassConfig.this.options.checkSymbols, !DefaultPassConfig.this.options.checkCaja);
        }
    };
    final PassFactory processDefines = new PassFactory("processDefines", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler abstractCompiler) {
            return new CompilerPass(){

                @Override
                public void process(Node node, Node node2) {
                    Map<String, Node> map = DefaultPassConfig.getAdditionalReplacements(DefaultPassConfig.this.options);
                    map.putAll(DefaultPassConfig.this.options.getDefineReplacements());
                    new ProcessDefines(abstractCompiler, map).injectNamespace(DefaultPassConfig.this.namespaceForChecks).process(node, node2);
                    DefaultPassConfig.this.namespaceForChecks = null;
                }
            };
        }
    };
    private final PassFactory checkConsts = new PassFactory("checkConsts", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new ConstCheck(abstractCompiler);
        }
    };
    private final PassFactory computeFunctionNames = new PassFactory("computeFunctionNames", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return DefaultPassConfig.this.functionNames = new FunctionNames(abstractCompiler);
        }
    };
    private final PassFactory ignoreCajaProperties = new PassFactory("ignoreCajaProperties", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new IgnoreCajaProperties(abstractCompiler);
        }
    };
    private final PassFactory runtimeTypeCheck = new PassFactory("runtimeTypeCheck", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new RuntimeTypeCheck(abstractCompiler, DefaultPassConfig.this.options.runtimeTypeCheckLogFunction);
        }
    };
    private final PassFactory replaceIdGenerators = new PassFactory("replaceIdGenerators", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler abstractCompiler) {
            return new CompilerPass(){

                @Override
                public void process(Node node, Node node2) {
                    ReplaceIdGenerators replaceIdGenerators = new ReplaceIdGenerators(abstractCompiler, DefaultPassConfig.this.options.idGenerators);
                    replaceIdGenerators.process(node, node2);
                    DefaultPassConfig.this.idGeneratorMap = replaceIdGenerators.getIdGeneratorMap();
                }
            };
        }
    };
    private final PassFactory replaceStrings = new PassFactory("replaceStrings", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler abstractCompiler) {
            Object var2_2 = null;
            return new CompilerPass(){

                @Override
                public void process(Node node, Node node2) {
                    ReplaceStrings replaceStrings = new ReplaceStrings(abstractCompiler, DefaultPassConfig.this.options.replaceStringsPlaceholderToken, DefaultPassConfig.this.options.replaceStringsFunctionDescriptions);
                    replaceStrings.process(node, node2);
                    DefaultPassConfig.this.stringMap = replaceStrings.getStringMap();
                }
            };
        }
    };
    private final PassFactory optimizeArgumentsArray = new PassFactory("optimizeArgumentsArray", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new OptimizeArgumentsArray(abstractCompiler);
        }
    };
    private final PassFactory closureCodeRemoval = new PassFactory("closureCodeRemoval", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new ClosureCodeRemoval(abstractCompiler, DefaultPassConfig.this.options.removeAbstractMethods, DefaultPassConfig.this.options.removeClosureAsserts);
        }
    };
    private final PassFactory collapseProperties = new PassFactory("collapseProperties", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new CollapseProperties(abstractCompiler, DefaultPassConfig.this.options.collapsePropertiesOnExternTypes, !DefaultPassConfig.this.isInliningForbidden());
        }
    };
    private final PassFactory tightenTypesBuilder = new PassFactory("tightenTypes", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            if (!DefaultPassConfig.this.options.checkTypes) {
                return new ErrorPass(abstractCompiler, TIGHTEN_TYPES_WITHOUT_TYPE_CHECK);
            }
            DefaultPassConfig.this.tightenTypes = new TightenTypes(abstractCompiler);
            return DefaultPassConfig.this.tightenTypes;
        }
    };
    private final PassFactory disambiguateProperties = new PassFactory("disambiguateProperties", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            if (DefaultPassConfig.this.tightenTypes == null) {
                return DisambiguateProperties.forJSTypeSystem(abstractCompiler);
            }
            return DisambiguateProperties.forConcreteTypeSystem(abstractCompiler, DefaultPassConfig.this.tightenTypes);
        }
    };
    private final PassFactory chainCalls = new PassFactory("chainCalls", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new ChainCalls(abstractCompiler);
        }
    };
    private final PassFactory devirtualizePrototypeMethods = new PassFactory("devirtualizePrototypeMethods", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new DevirtualizePrototypeMethods(abstractCompiler);
        }
    };
    private final PassFactory optimizeCalls = new PassFactory("optimizeCalls", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            OptimizeCalls optimizeCalls = new OptimizeCalls(abstractCompiler);
            if (DefaultPassConfig.this.options.optimizeReturns) {
                optimizeCalls.addPass(new OptimizeReturns(abstractCompiler));
            }
            if (DefaultPassConfig.this.options.optimizeParameters) {
                optimizeCalls.addPass(new OptimizeParameters(abstractCompiler));
            }
            if (DefaultPassConfig.this.options.optimizeCalls) {
                optimizeCalls.addPass(new RemoveUnusedVars(abstractCompiler, false, true, true));
            }
            return optimizeCalls;
        }
    };
    private final PassFactory markPureFunctions = new PassFactory("markPureFunctions", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new PureFunctionIdentifier.Driver(abstractCompiler, DefaultPassConfig.this.options.debugFunctionSideEffectsPath, false);
        }
    };
    private final PassFactory markNoSideEffectCalls = new PassFactory("markNoSideEffectCalls", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new MarkNoSideEffectCalls(abstractCompiler);
        }
    };
    private final PassFactory inlineVariables = new PassFactory("inlineVariables", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            InlineVariables.Mode mode;
            if (DefaultPassConfig.this.isInliningForbidden()) {
                return new ErrorPass(abstractCompiler, CANNOT_USE_PROTOTYPE_AND_VAR);
            }
            if (DefaultPassConfig.this.options.inlineVariables) {
                mode = InlineVariables.Mode.ALL;
            } else if (DefaultPassConfig.this.options.inlineLocalVariables) {
                mode = InlineVariables.Mode.LOCALS_ONLY;
            } else {
                throw new IllegalStateException("No variable inlining option set.");
            }
            return new InlineVariables(abstractCompiler, mode, true);
        }
    };
    private final PassFactory inlineConstants = new PassFactory("inlineConstants", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new InlineVariables(abstractCompiler, InlineVariables.Mode.CONSTANTS_ONLY, true);
        }
    };
    private final PassFactory minimizeExitPoints = new PassFactory("minimizeExitPoints", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new MinimizeExitPoints(abstractCompiler);
        }
    };
    private final PassFactory removeUnreachableCode = new PassFactory("removeUnreachableCode", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new UnreachableCodeElimination(abstractCompiler, true);
        }
    };
    private final PassFactory removeUnusedPrototypeProperties = new PassFactory("removeUnusedPrototypeProperties", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new RemoveUnusedPrototypeProperties(abstractCompiler, DefaultPassConfig.this.options.removeUnusedPrototypePropertiesInExterns, !DefaultPassConfig.this.options.removeUnusedVars);
        }
    };
    private final PassFactory smartNamePass = new PassFactory("smartNamePass", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler abstractCompiler) {
            return new CompilerPass(){

                @Override
                public void process(Node node, Node node2) {
                    NameAnalyzer nameAnalyzer = new NameAnalyzer(abstractCompiler, false);
                    nameAnalyzer.process(node, node2);
                    String string = DefaultPassConfig.this.options.reportPath;
                    if (string != null) {
                        try {
                            Files.write((CharSequence)nameAnalyzer.getHtmlReport(), (File)new File(string), (Charset)Charsets.UTF_8);
                        }
                        catch (IOException iOException) {
                            abstractCompiler.report(JSError.make(REPORT_PATH_IO_ERROR, string));
                        }
                    }
                    if (DefaultPassConfig.this.options.smartNameRemoval) {
                        nameAnalyzer.removeUnreferenced();
                    }
                }
            };
        }
    };
    private PassFactory inlineGetters = new PassFactory("inlineGetters", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new InlineGetters(abstractCompiler);
        }
    };
    private PassFactory deadAssignmentsElimination = new PassFactory("deadAssignmentsElimination", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new DeadAssignmentsElimination(abstractCompiler);
        }
    };
    private PassFactory inlineFunctions = new PassFactory("inlineFunctions", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            boolean bl = !DefaultPassConfig.this.isInliningForbidden();
            return new InlineFunctions(abstractCompiler, abstractCompiler.getUniqueNameIdSupplier(), DefaultPassConfig.this.options.inlineFunctions, DefaultPassConfig.this.options.inlineLocalFunctions, bl);
        }
    };
    private PassFactory removeUnusedVars = new PassFactory("removeUnusedVars", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            boolean bl = DefaultPassConfig.this.options.removeUnusedLocalVars && !DefaultPassConfig.this.options.removeUnusedVars;
            boolean bl2 = DefaultPassConfig.this.options.anonymousFunctionNaming != AnonymousFunctionNamingPolicy.OFF;
            return new RemoveUnusedVars(abstractCompiler, !bl, bl2, false);
        }
    };
    private PassFactory crossModuleCodeMotion = new PassFactory("crossModuleCodeMotion", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new CrossModuleCodeMotion(abstractCompiler, abstractCompiler.getModuleGraph());
        }
    };
    private PassFactory crossModuleMethodMotion = new PassFactory("crossModuleMethodMotion", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new CrossModuleMethodMotion(abstractCompiler, DefaultPassConfig.this.crossModuleIdGenerator, DefaultPassConfig.this.options.removeUnusedPrototypePropertiesInExterns);
        }
    };
    private PassFactory specializeInitialModule = new PassFactory("specializeInitialModule", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new SpecializeModule(abstractCompiler, DefaultPassConfig.this.devirtualizePrototypeMethods, DefaultPassConfig.this.inlineFunctions, DefaultPassConfig.this.removeUnusedPrototypeProperties);
        }
    };
    private final PassFactory flowSensitiveInlineVariables = new PassFactory("flowSensitiveInlineVariables", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new FlowSensitiveInlineVariables(abstractCompiler);
        }
    };
    private final PassFactory coalesceVariableNames = new PassFactory("coalesceVariableNames", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new CoalesceVariableNames(abstractCompiler, DefaultPassConfig.this.options.generatePseudoNames);
        }
    };
    private final PassFactory collapseVariableDeclarations = new PassFactory("collapseVariableDeclarations", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new CollapseVariableDeclarations(abstractCompiler);
        }
    };
    private final PassFactory groupVariableDeclarations = new PassFactory("groupVariableDeclarations", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new GroupVariableDeclarations(abstractCompiler);
        }
    };
    private final PassFactory extractPrototypeMemberDeclarations = new PassFactory("extractPrototypeMemberDeclarations", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new ExtractPrototypeMemberDeclarations(abstractCompiler);
        }
    };
    private final PassFactory rewriteFunctionExpressions = new PassFactory("rewriteFunctionExpressions", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new FunctionRewriter(abstractCompiler);
        }
    };
    private final PassFactory collapseAnonymousFunctions = new PassFactory("collapseAnonymousFunctions", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new CollapseAnonymousFunctions(abstractCompiler);
        }
    };
    private final PassFactory moveFunctionDeclarations = new PassFactory("moveFunctionDeclarations", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new MoveFunctionDeclarations(abstractCompiler);
        }
    };
    private final PassFactory nameUnmappedAnonymousFunctions = new PassFactory("nameAnonymousFunctions", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new NameAnonymousFunctions(abstractCompiler);
        }
    };
    private final PassFactory nameMappedAnonymousFunctions = new PassFactory("nameAnonymousFunctions", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler abstractCompiler) {
            return new CompilerPass(){

                @Override
                public void process(Node node, Node node2) {
                    NameAnonymousFunctionsMapped nameAnonymousFunctionsMapped = new NameAnonymousFunctionsMapped(abstractCompiler);
                    nameAnonymousFunctionsMapped.process(node, node2);
                    DefaultPassConfig.this.anonymousFunctionNameMap = nameAnonymousFunctionsMapped.getFunctionMap();
                }
            };
        }
    };
    private final PassFactory aliasExternals = new PassFactory("aliasExternals", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new AliasExternals(abstractCompiler, abstractCompiler.getModuleGraph(), DefaultPassConfig.this.options.unaliasableGlobals, DefaultPassConfig.this.options.aliasableGlobals);
        }
    };
    private final PassFactory aliasStrings = new PassFactory("aliasStrings", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new AliasStrings(abstractCompiler, abstractCompiler.getModuleGraph(), DefaultPassConfig.this.options.aliasAllStrings ? null : DefaultPassConfig.this.options.aliasableStrings, DefaultPassConfig.this.options.aliasStringsBlacklist, DefaultPassConfig.this.options.outputJsStringUsage);
        }
    };
    private final PassFactory aliasKeywords = new PassFactory("aliasKeywords", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new AliasKeywords(abstractCompiler);
        }
    };
    private final PassFactory objectPropertyStringPostprocess = new PassFactory("ObjectPropertyStringPostprocess", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new ObjectPropertyStringPostprocess(abstractCompiler);
        }
    };
    private final PassFactory ambiguateProperties = new PassFactory("ambiguateProperties", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new AmbiguateProperties(abstractCompiler, DefaultPassConfig.this.options.anonymousFunctionNaming.getReservedCharacters());
        }
    };
    private final PassFactory markUnnormalized = new PassFactory("markUnnormalized", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler abstractCompiler) {
            return new CompilerPass(){

                @Override
                public void process(Node node, Node node2) {
                    abstractCompiler.setUnnormalized();
                }
            };
        }
    };
    private final PassFactory denormalize = new PassFactory("denormalize", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new Denormalize(abstractCompiler);
        }
    };
    private final PassFactory invertContextualRenaming = new PassFactory("invertNames", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return MakeDeclaredNamesUnique.getContextualRenameInverter(abstractCompiler);
        }
    };
    private final PassFactory renameProperties = new PassFactory("renameProperties", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler abstractCompiler) {
            VariableMap variableMap = null;
            if (DefaultPassConfig.this.options.inputPropertyMapSerialized != null) {
                try {
                    variableMap = VariableMap.fromBytes(DefaultPassConfig.this.options.inputPropertyMapSerialized);
                }
                catch (ParseException parseException) {
                    return new ErrorPass(abstractCompiler, JSError.make(INPUT_MAP_PROP_PARSE, parseException.getMessage()));
                }
            }
            final VariableMap variableMap2 = variableMap;
            return new CompilerPass(){

                @Override
                public void process(Node node, Node node2) {
                    DefaultPassConfig.this.propertyMap = DefaultPassConfig.this.runPropertyRenaming(abstractCompiler, variableMap2, node, node2);
                }
            };
        }
    };
    private final PassFactory renameVars = new PassFactory("renameVars", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler abstractCompiler) {
            VariableMap variableMap = null;
            if (DefaultPassConfig.this.options.inputVariableMapSerialized != null) {
                try {
                    variableMap = VariableMap.fromBytes(DefaultPassConfig.this.options.inputVariableMapSerialized);
                }
                catch (ParseException parseException) {
                    return new ErrorPass(abstractCompiler, JSError.make(INPUT_MAP_VAR_PARSE, parseException.getMessage()));
                }
            }
            final VariableMap variableMap2 = variableMap;
            return new CompilerPass(){

                @Override
                public void process(Node node, Node node2) {
                    DefaultPassConfig.this.variableMap = DefaultPassConfig.this.runVariableRenaming(abstractCompiler, variableMap2, node, node2);
                }
            };
        }
    };
    private final PassFactory renameLabels = new PassFactory("renameLabels", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new RenameLabels(abstractCompiler);
        }
    };
    private final PassFactory convertToDottedProperties = new PassFactory("convertToDottedProperties", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new ConvertToDottedProperties(abstractCompiler);
        }
    };
    private final PassFactory sanityCheckVars = new PassFactory("sanityCheckVars", true){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new VarCheck(abstractCompiler, true);
        }
    };
    private final PassFactory instrumentFunctions = new PassFactory("instrumentFunctions", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler abstractCompiler) {
            return new CompilerPass(){

                @Override
                public void process(Node node, Node node2) {
                    try {
                        FileReader fileReader = new FileReader(DefaultPassConfig.this.options.instrumentationTemplate);
                        new InstrumentFunctions(abstractCompiler, DefaultPassConfig.this.functionNames, DefaultPassConfig.this.options.instrumentationTemplate, DefaultPassConfig.this.options.appNameStr, fileReader).process(node, node2);
                    }
                    catch (IOException iOException) {
                        abstractCompiler.report(JSError.make(AbstractCompiler.READ_ERROR, DefaultPassConfig.this.options.instrumentationTemplate));
                    }
                }
            };
        }
    };
    private final PassFactory printNameReferenceGraph = new PassFactory("printNameReferenceGraph", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler abstractCompiler) {
            return new CompilerPass(){

                @Override
                public void process(Node node, Node node2) {
                    NameReferenceGraphConstruction nameReferenceGraphConstruction = new NameReferenceGraphConstruction(abstractCompiler);
                    nameReferenceGraphConstruction.process(node, node2);
                    String string = DefaultPassConfig.this.options.nameReferenceGraphPath;
                    try {
                        Files.write((CharSequence)DotFormatter.toDot(nameReferenceGraphConstruction.getNameReferenceGraph()), (File)new File(string), (Charset)Charsets.UTF_8);
                    }
                    catch (IOException iOException) {
                        abstractCompiler.report(JSError.make(NAME_REF_GRAPH_FILE_ERROR, iOException.getMessage(), string));
                    }
                }
            };
        }
    };
    private final PassFactory printNameReferenceReport = new PassFactory("printNameReferenceReport", true){

        @Override
        protected CompilerPass createInternal(final AbstractCompiler abstractCompiler) {
            return new CompilerPass(){

                @Override
                public void process(Node node, Node node2) {
                    NameReferenceGraphConstruction nameReferenceGraphConstruction = new NameReferenceGraphConstruction(abstractCompiler);
                    String string = DefaultPassConfig.this.options.nameReferenceReportPath;
                    try {
                        NameReferenceGraphReport nameReferenceGraphReport = new NameReferenceGraphReport(nameReferenceGraphConstruction.getNameReferenceGraph());
                        Files.write((CharSequence)nameReferenceGraphReport.getHtmlReport(), (File)new File(string), (Charset)Charsets.UTF_8);
                    }
                    catch (IOException iOException) {
                        abstractCompiler.report(JSError.make(NAME_REF_REPORT_FILE_ERROR, iOException.getMessage(), string));
                    }
                }
            };
        }
    };

    public DefaultPassConfig(CompilerOptions compilerOptions) {
        super(compilerOptions);
    }

    @Override
    PassConfig.State getIntermediateState() {
        return new PassConfig.State(this.cssNames == null ? null : Maps.newHashMap(this.cssNames), this.exportedNames == null ? null : Collections.unmodifiableSet(this.exportedNames), this.crossModuleIdGenerator, this.variableMap, this.propertyMap, this.anonymousFunctionNameMap, this.stringMap, this.functionNames, this.idGeneratorMap);
    }

    @Override
    void setIntermediateState(PassConfig.State state) {
        this.cssNames = state.cssNames == null ? null : Maps.newHashMap(state.cssNames);
        this.exportedNames = state.exportedNames == null ? null : Sets.newHashSet(state.exportedNames);
        this.crossModuleIdGenerator = state.crossModuleIdGenerator;
        this.variableMap = state.variableMap;
        this.propertyMap = state.propertyMap;
        this.anonymousFunctionNameMap = state.anonymousFunctionNameMap;
        this.stringMap = state.stringMap;
        this.functionNames = state.functionNames;
        this.idGeneratorMap = state.idGeneratorMap;
    }

    @Override
    protected List<PassFactory> getChecks() {
        ArrayList arrayList = Lists.newArrayList();
        if (this.options.closurePass) {
            arrayList.add(this.closureGoogScopeAliases);
        }
        if (this.options.nameAnonymousFunctionsOnly) {
            if (this.options.anonymousFunctionNaming == AnonymousFunctionNamingPolicy.MAPPED) {
                arrayList.add(this.nameMappedAnonymousFunctions);
            } else if (this.options.anonymousFunctionNaming == AnonymousFunctionNamingPolicy.UNMAPPED) {
                arrayList.add(this.nameUnmappedAnonymousFunctions);
            }
            return arrayList;
        }
        if (this.options.checkSuspiciousCode || this.options.checkGlobalThisLevel.isOn()) {
            arrayList.add(this.suspiciousCode);
        }
        if (this.options.checkControlStructures) {
            arrayList.add(this.checkControlStructures);
        }
        if (this.options.checkRequires.isOn()) {
            arrayList.add(this.checkRequires);
        }
        if (this.options.checkProvides.isOn()) {
            arrayList.add(this.checkProvides);
        }
        if (this.options.generateExports) {
            arrayList.add(this.generateExports);
        }
        if (this.options.exportTestFunctions) {
            arrayList.add(this.exportTestFunctions);
        }
        if (this.options.closurePass) {
            arrayList.add(this.closurePrimitives.makeOneTimePass());
        }
        if (this.options.closurePass && this.options.checkMissingGetCssNameLevel.isOn()) {
            arrayList.add(this.closureCheckGetCssName);
        }
        if (this.options.syntheticBlockStartMarker != null) {
            arrayList.add(this.createSyntheticBlocks);
        }
        arrayList.add(this.checkVars);
        if (this.options.computeFunctionSideEffects) {
            arrayList.add(this.checkRegExp);
        }
        if (this.options.checkShadowVars.isOn()) {
            arrayList.add(this.checkShadowVars);
        }
        if (this.options.aggressiveVarCheck.isOn()) {
            arrayList.add(this.checkVariableReferences);
        }
        if (this.options.processObjectPropertyString) {
            arrayList.add(this.objectPropertyStringPreprocess);
        }
        if (this.options.enables(DiagnosticGroups.CHECK_TYPES)) {
            this.options.checkTypes = true;
        } else if (this.options.disables(DiagnosticGroups.CHECK_TYPES)) {
            this.options.checkTypes = false;
        }
        if (this.options.checkTypes) {
            arrayList.add(this.resolveTypes.makeOneTimePass());
            arrayList.add(this.inferTypes.makeOneTimePass());
            arrayList.add(this.checkTypes.makeOneTimePass());
        }
        if (this.options.checkUnreachableCode.isOn() || this.options.checkTypes && this.options.checkMissingReturn.isOn()) {
            arrayList.add(this.checkControlFlow);
        }
        if (this.options.enables(DiagnosticGroups.ACCESS_CONTROLS) && this.options.checkTypes) {
            arrayList.add(this.checkAccessControls);
        }
        if (this.options.checkGlobalNamesLevel.isOn()) {
            arrayList.add(this.checkGlobalNames);
        }
        if (this.options.checkUndefinedProperties.isOn() || this.options.checkUnusedPropertiesEarly) {
            arrayList.add(this.checkSuspiciousProperties);
        }
        if (this.options.checkCaja || this.options.checkEs5Strict) {
            arrayList.add(this.checkStrictMode);
        }
        if (this.options.closurePass) {
            arrayList.add(this.closureReplaceGetCssName);
        }
        arrayList.add(this.options.messageBundle != null ? this.replaceMessages : DefaultPassConfig.createEmptyPass("replaceMessages"));
        arrayList.add(this.processDefines);
        if (this.options.instrumentationTemplate != null || this.options.recordFunctionInformation) {
            arrayList.add(this.computeFunctionNames);
        }
        if (this.options.nameReferenceGraphPath != null && !this.options.nameReferenceGraphPath.isEmpty()) {
            arrayList.add(this.printNameReferenceGraph);
        }
        if (this.options.nameReferenceReportPath != null && !this.options.nameReferenceReportPath.isEmpty()) {
            arrayList.add(this.printNameReferenceReport);
        }
        this.assertAllOneTimePasses(arrayList);
        return arrayList;
    }

    @Override
    protected List<PassFactory> getOptimizations() {
        ArrayList arrayList = Lists.newArrayList();
        if (this.options.runtimeTypeCheck) {
            arrayList.add(this.runtimeTypeCheck);
        }
        arrayList.add(DefaultPassConfig.createEmptyPass("beforeStandardOptimizations"));
        if (!this.options.idGenerators.isEmpty()) {
            arrayList.add(this.replaceIdGenerators);
        }
        if (this.options.optimizeArgumentsArray) {
            arrayList.add(this.optimizeArgumentsArray);
        }
        if (this.options.closurePass && (this.options.removeAbstractMethods || this.options.removeClosureAsserts)) {
            arrayList.add(this.closureCodeRemoval);
        }
        if (this.options.collapseProperties) {
            arrayList.add(this.collapseProperties);
        }
        if (!this.options.replaceStringsFunctionDescriptions.isEmpty()) {
            arrayList.add(this.replaceStrings);
        }
        if (this.options.tightenTypes) {
            arrayList.add(this.tightenTypesBuilder);
        }
        if (this.options.disambiguateProperties) {
            arrayList.add(this.disambiguateProperties);
        }
        if (this.options.computeFunctionSideEffects) {
            arrayList.add(this.markPureFunctions);
        } else if (this.options.markNoSideEffectCalls) {
            arrayList.add(this.markNoSideEffectCalls);
        }
        if (this.options.chainCalls) {
            arrayList.add(this.chainCalls);
        }
        if (this.options.inlineConstantVars) {
            arrayList.add(this.checkConsts);
        }
        if (this.options.ignoreCajaProperties) {
            arrayList.add(this.ignoreCajaProperties);
        }
        this.assertAllOneTimePasses(arrayList);
        if (this.options.smartNameRemoval || this.options.reportPath != null) {
            arrayList.addAll(this.getCodeRemovingPasses());
            arrayList.add(this.smartNamePass);
        }
        if (this.options.crossModuleCodeMotion) {
            arrayList.add(this.crossModuleCodeMotion);
        }
        if (this.options.devirtualizePrototypeMethods) {
            arrayList.add(this.devirtualizePrototypeMethods);
        }
        if (this.options.optimizeCalls || this.options.optimizeParameters || this.options.optimizeReturns) {
            arrayList.add(this.optimizeCalls);
        }
        if (this.options.customPasses != null) {
            arrayList.add(this.getCustomPasses(CustomPassExecutionTime.BEFORE_OPTIMIZATION_LOOP));
        }
        arrayList.add(DefaultPassConfig.createEmptyPass("beforeMainOptimizations"));
        if (this.options.specializeInitialModule) {
            arrayList.addAll(this.getMainOptimizationLoop());
            if (this.options.crossModuleCodeMotion) {
                arrayList.add(this.crossModuleCodeMotion);
            }
            if (this.options.crossModuleMethodMotion) {
                arrayList.add(this.crossModuleMethodMotion);
            }
            arrayList.add(this.specializeInitialModule.makeOneTimePass());
        }
        arrayList.addAll(this.getMainOptimizationLoop());
        arrayList.add(DefaultPassConfig.createEmptyPass("beforeModuleMotion"));
        if (this.options.crossModuleCodeMotion) {
            arrayList.add(this.crossModuleCodeMotion);
        }
        if (this.options.crossModuleMethodMotion) {
            arrayList.add(this.crossModuleMethodMotion);
        }
        arrayList.add(DefaultPassConfig.createEmptyPass("afterModuleMotion"));
        if (this.options.customPasses != null) {
            arrayList.add(this.getCustomPasses(CustomPassExecutionTime.AFTER_OPTIMIZATION_LOOP));
        }
        if (this.options.flowSensitiveInlineVariables) {
            arrayList.add(this.flowSensitiveInlineVariables);
            if (this.options.removeUnusedVars) {
                arrayList.add(this.removeUnusedVars);
            }
        }
        if (this.options.collapseAnonymousFunctions) {
            arrayList.add(this.collapseAnonymousFunctions);
        }
        if (this.options.moveFunctionDeclarations) {
            arrayList.add(this.moveFunctionDeclarations);
        }
        if (this.options.anonymousFunctionNaming == AnonymousFunctionNamingPolicy.MAPPED) {
            arrayList.add(this.nameMappedAnonymousFunctions);
        }
        if (this.options.extractPrototypeMemberDeclarations && this.options.propertyRenaming != PropertyRenamingPolicy.HEURISTIC && this.options.propertyRenaming != PropertyRenamingPolicy.AGGRESSIVE_HEURISTIC) {
            arrayList.add(this.extractPrototypeMemberDeclarations);
        }
        if (this.options.ambiguateProperties && this.options.propertyRenaming == PropertyRenamingPolicy.ALL_UNQUOTED) {
            arrayList.add(this.ambiguateProperties);
        }
        if (this.options.propertyRenaming != PropertyRenamingPolicy.OFF) {
            arrayList.add(this.renameProperties);
        }
        if (this.options.reserveRawExports) {
            arrayList.add(this.gatherRawExports);
        }
        if (this.options.convertToDottedProperties) {
            arrayList.add(this.convertToDottedProperties);
        }
        if (this.options.rewriteFunctionExpressions) {
            arrayList.add(this.rewriteFunctionExpressions);
        }
        if (!this.options.aliasableStrings.isEmpty() || this.options.aliasAllStrings) {
            arrayList.add(this.aliasStrings);
        }
        if (this.options.aliasExternals) {
            arrayList.add(this.aliasExternals);
        }
        if (this.options.aliasKeywords) {
            arrayList.add(this.aliasKeywords);
        }
        arrayList.add(this.markUnnormalized);
        if (this.options.coalesceVariableNames) {
            arrayList.add(this.coalesceVariableNames);
        }
        if (this.options.collapseVariableDeclarations) {
            arrayList.add(this.collapseVariableDeclarations);
        }
        arrayList.add(this.denormalize);
        if (this.options.instrumentationTemplate != null) {
            arrayList.add(this.instrumentFunctions);
        }
        if (this.options.variableRenaming != VariableRenamingPolicy.ALL) {
            arrayList.add(this.invertContextualRenaming);
        }
        if (this.options.variableRenaming != VariableRenamingPolicy.OFF) {
            arrayList.add(this.renameVars);
        }
        if (this.options.groupVariableDeclarations) {
            arrayList.add(this.groupVariableDeclarations);
        }
        if (this.options.processObjectPropertyString) {
            arrayList.add(this.objectPropertyStringPostprocess);
        }
        if (this.options.labelRenaming) {
            arrayList.add(this.renameLabels);
        }
        if (this.options.anonymousFunctionNaming == AnonymousFunctionNamingPolicy.UNMAPPED) {
            arrayList.add(this.nameUnmappedAnonymousFunctions);
        }
        if (this.options.checkSymbols) {
            arrayList.add(this.sanityCheckVars);
        }
        return arrayList;
    }

    private List<PassFactory> getMainOptimizationLoop() {
        ArrayList arrayList = Lists.newArrayList();
        if (this.options.inlineGetters) {
            arrayList.add(this.inlineGetters);
        }
        arrayList.addAll(this.getCodeRemovingPasses());
        if (this.options.inlineFunctions || this.options.inlineLocalFunctions) {
            arrayList.add(this.inlineFunctions);
        }
        if (this.options.removeUnusedVars || this.options.removeUnusedLocalVars) {
            if (this.options.deadAssignmentElimination) {
                arrayList.add(this.deadAssignmentsElimination);
            }
            arrayList.add(this.removeUnusedVars);
        }
        this.assertAllLoopablePasses(arrayList);
        return arrayList;
    }

    private List<PassFactory> getCodeRemovingPasses() {
        ArrayList arrayList = Lists.newArrayList();
        if (this.options.inlineVariables || this.options.inlineLocalVariables) {
            arrayList.add(this.inlineVariables);
        } else if (this.options.inlineConstantVars) {
            arrayList.add(this.inlineConstants);
        }
        if (this.options.foldConstants) {
            arrayList.add(this.minimizeExitPoints);
            arrayList.add(this.peepholeOptimizations);
        }
        if (this.options.removeDeadCode) {
            arrayList.add(this.removeUnreachableCode);
        }
        if (this.options.removeUnusedPrototypeProperties) {
            arrayList.add(this.removeUnusedPrototypeProperties);
        }
        this.assertAllLoopablePasses(arrayList);
        return arrayList;
    }

    private void assertAllOneTimePasses(List<PassFactory> list) {
        for (PassFactory passFactory : list) {
            Preconditions.checkState((boolean)passFactory.isOneTimePass());
        }
    }

    private void assertAllLoopablePasses(List<PassFactory> list) {
        for (PassFactory passFactory : list) {
            Preconditions.checkState((!passFactory.isOneTimePass() ? 1 : 0) != 0);
        }
    }

    private static CompilerPass combineChecks(AbstractCompiler abstractCompiler, List<NodeTraversal.Callback> list) {
        Preconditions.checkArgument((list.size() > 0 ? 1 : 0) != 0);
        NodeTraversal.Callback[] callbackArray = list.toArray(new NodeTraversal.Callback[list.size()]);
        return new CombinedCompilerPass(abstractCompiler, callbackArray);
    }

    private VariableMap runPropertyRenaming(AbstractCompiler abstractCompiler, VariableMap variableMap, Node node, Node node2) {
        char[] cArray = this.options.anonymousFunctionNaming.getReservedCharacters();
        switch (this.options.propertyRenaming) {
            case HEURISTIC: {
                RenamePrototypes renamePrototypes = new RenamePrototypes(abstractCompiler, false, cArray, variableMap);
                renamePrototypes.process(node, node2);
                return renamePrototypes.getPropertyMap();
            }
            case AGGRESSIVE_HEURISTIC: {
                RenamePrototypes renamePrototypes = new RenamePrototypes(abstractCompiler, true, cArray, variableMap);
                renamePrototypes.process(node, node2);
                return renamePrototypes.getPropertyMap();
            }
            case ALL_UNQUOTED: {
                RenameProperties renameProperties = new RenameProperties(abstractCompiler, this.options.generatePseudoNames, variableMap, cArray);
                renameProperties.process(node, node2);
                return renameProperties.getPropertyMap();
            }
        }
        throw new IllegalStateException("Unrecognized property renaming policy");
    }

    private VariableMap runVariableRenaming(AbstractCompiler abstractCompiler, VariableMap variableMap, Node node, Node node2) {
        char[] cArray = this.options.anonymousFunctionNaming.getReservedCharacters();
        boolean bl = this.options.anonymousFunctionNaming != AnonymousFunctionNamingPolicy.OFF;
        RenameVars renameVars = new RenameVars(abstractCompiler, this.options.renamePrefix, this.options.variableRenaming == VariableRenamingPolicy.LOCAL, bl, this.options.generatePseudoNames, variableMap, cArray, this.exportedNames);
        renameVars.process(node, node2);
        return renameVars.getVariableMap();
    }

    private static PassFactory createEmptyPass(String string) {
        return new PassFactory(string, true){

            @Override
            protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
                return DefaultPassConfig.runInSerial(new CompilerPass[0]);
            }
        };
    }

    private PassFactory getCustomPasses(final CustomPassExecutionTime customPassExecutionTime) {
        return new PassFactory("runCustomPasses", true){

            @Override
            protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
                return DefaultPassConfig.runInSerial(DefaultPassConfig.this.options.customPasses.get((Object)customPassExecutionTime));
            }
        };
    }

    private boolean isInliningForbidden() {
        return this.options.propertyRenaming == PropertyRenamingPolicy.HEURISTIC || this.options.propertyRenaming == PropertyRenamingPolicy.AGGRESSIVE_HEURISTIC;
    }

    private static CompilerPass runInSerial(CompilerPass ... compilerPassArray) {
        return DefaultPassConfig.runInSerial(Lists.newArrayList((Object[])compilerPassArray));
    }

    private static CompilerPass runInSerial(final Collection<CompilerPass> collection) {
        return new CompilerPass(){

            @Override
            public void process(Node node, Node node2) {
                for (CompilerPass compilerPass : collection) {
                    compilerPass.process(node, node2);
                }
            }
        };
    }

    @VisibleForTesting
    static Map<String, Node> getAdditionalReplacements(CompilerOptions compilerOptions) {
        HashMap hashMap = Maps.newHashMap();
        if (compilerOptions.markAsCompiled || compilerOptions.closurePass) {
            hashMap.put(COMPILED_CONSTANT_NAME, new Node(44));
        }
        if (compilerOptions.closurePass && compilerOptions.locale != null) {
            hashMap.put(CLOSURE_LOCALE_CONSTANT_NAME, Node.newString(compilerOptions.locale));
        }
        return hashMap;
    }

    private class GlobalTypeResolver
    implements CompilerPass {
        private final AbstractCompiler compiler;

        GlobalTypeResolver(AbstractCompiler abstractCompiler) {
            this.compiler = abstractCompiler;
        }

        @Override
        public void process(Node node, Node node2) {
            if (DefaultPassConfig.this.topScope == null) {
                DefaultPassConfig.this.regenerateGlobalTypedScope(this.compiler, node2.getParent());
            } else {
                this.compiler.getTypeRegistry().resolveTypesInScope(DefaultPassConfig.this.topScope);
            }
        }
    }
}

