/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.safehtml.shared.annotations.IsSafeHtml;
import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.Collection;

public abstract class SuggestOracle {
    private Response emptyResponse = new Response(new ArrayList());

    public boolean isDisplayStringHTML() {
        return false;
    }

    public void requestDefaultSuggestions(Request request, Callback callback) {
        assert (request.query == null);
        callback.onSuggestionsReady(request, this.emptyResponse);
    }

    public abstract void requestSuggestions(Request var1, Callback var2);

    public static interface Suggestion {
        @IsSafeHtml
        public String getDisplayString();

        public String getReplacementString();
    }

    public static class Response
    implements IsSerializable {
        private Collection<? extends Suggestion> suggestions;
        private boolean moreSuggestions = false;
        private int numMoreSuggestions = 0;

        public Response() {
        }

        public Response(Collection<? extends Suggestion> suggestions) {
            this.setSuggestions(suggestions);
        }

        public int getMoreSuggestionsCount() {
            return this.numMoreSuggestions;
        }

        public Collection<? extends Suggestion> getSuggestions() {
            return this.suggestions;
        }

        public boolean hasMoreSuggestions() {
            return this.moreSuggestions;
        }

        public void setMoreSuggestions(boolean moreSuggestions) {
            this.moreSuggestions = moreSuggestions;
        }

        public void setMoreSuggestionsCount(int count) {
            this.numMoreSuggestions = count;
            this.moreSuggestions = count > 0;
        }

        public void setSuggestions(Collection<? extends Suggestion> suggestions) {
            this.suggestions = suggestions;
        }
    }

    public static class Request
    implements IsSerializable {
        private int limit = 20;
        private String query;

        public Request() {
        }

        public Request(String query) {
            this.setQuery(query);
        }

        public Request(String query, int limit) {
            this.setQuery(query);
            this.setLimit(limit);
        }

        public int getLimit() {
            return this.limit;
        }

        public String getQuery() {
            return this.query;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }

        public void setQuery(String query) {
            this.query = query;
        }
    }

    public static interface Callback {
        public void onSuggestionsReady(Request var1, Response var2);
    }
}

