/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=21.0
//  number=$Revision: 6546 $
//  type=root
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $


/**
 * Localized names for the "kab" locale.
 */
public class LocalizedNamesImpl_kab extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "IO",
        "AN",
        "AQ",
        "AR",
        "AM",
        "AW",
        "VA",
        "AX",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BM",
        "BT",
        "BY",
        "BZ",
        "BJ",
        "BL",
        "BQ",
        "BR",
        "BN",
        "BG",
        "BO",
        "BI",
        "BF",
        "BA",
        "BW",
        "BV",
        "TD",
        "KH",
        "CC",
        "CZ",
        "CL",
        "CY",
        "CP",
        "CW",
        "CX",
        "DK",
        "DG",
        "DM",
        "EA",
        "EH",
        "EU",
        "PS",
        "FJ",
        "PH",
        "FI",
        "FO",
        "FR",
        "GA",
        "GM",
        "GG",
        "DJ",
        "GD",
        "GL",
        "GS",
        "GY",
        "GP",
        "GU",
        "GT",
        "HT",
        "HK",
        "HM",
        "HN",
        "HU",
        "IC",
        "EC",
        "IM",
        "ID",
        "IR",
        "ER",
        "IS",
        "EE",
        "IL",
        "JM",
        "JP",
        "JE",
        "GI",
        "GE",
        "NC",
        "CM",
        "CA",
        "KZ",
        "HR",
        "KE",
        "KI",
        "KG",
        "CU",
        "CO",
        "KM",
        "CG",
        "KP",
        "KR",
        "CR",
        "CI",
        "KW",
        "CN",
        "GR",
        "JO",
        "AL",
        "DE",
        "LV",
        "LA",
        "LI",
        "DZ",
        "IN",
        "LR",
        "LY",
        "IE",
        "LT",
        "LS",
        "MA",
        "LB",
        "LU",
        "YE",
        "IQ",
        "MG",
        "MW",
        "MV",
        "ML",
        "MY",
        "MT",
        "MQ",
        "MK",
        "EG",
        "YT",
        "ME",
        "MX",
        "MF",
        "FM",
        "MO",
        "MD",
        "MC",
        "MN",
        "MS",
        "MU",
        "MR",
        "MZ",
        "MM",
        "NA",
        "NE",
        "NG",
        "NI",
        "NP",
        "NU",
        "NR",
        "NO",
        "PK",
        "PW",
        "PA",
        "PY",
        "PE",
        "PN",
        "PL",
        "PF",
        "PT",
        "PR",
        "QA",
        "QO",
        "RU",
        "RS",
        "RO",
        "RW",
        "SV",
        "WS",
        "AS",
        "KN",
        "LC",
        "SM",
        "PM",
        "SH",
        "VC",
        "ST",
        "SC",
        "SG",
        "SN",
        "SL",
        "CS",
        "SJ",
        "SK",
        "SI",
        "ES",
        "LK",
        "SS",
        "SD",
        "SO",
        "SR",
        "SY",
        "SA",
        "SZ",
        "SE",
        "CH",
        "SX",
        "TA",
        "ZA",
        "GB",
        "TJ",
        "TZ",
        "TH",
        "TW",
        "IT",
        "TF",
        "CF",
        "DO",
        "CD",
        "AE",
        "FK",
        "KY",
        "CK",
        "MH",
        "MP",
        "SB",
        "CV",
        "NF",
        "VG",
        "RE",
        "NL",
        "TT",
        "TG",
        "TK",
        "TL",
        "TN",
        "TO",
        "TR",
        "TC",
        "TM",
        "TV",
        "UA",
        "UM",
        "AD",
        "AI",
        "AO",
        "AG",
        "UY",
        "AU",
        "AT",
        "ET",
        "UZ",
        "UG",
        "VU",
        "VE",
        "VN",
        "VI",
        "WF",
        "US",
        "ZM",
        "NZ",
        "ZW",
        "OM",
        "GH",
        "GF",
        "GN",
        "GW",
        "PG",
        "GQ",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "Undura");
    namesMap.put("AE", "Tigeldunin Yedduklen Taɛrabin");
    namesMap.put("AF", "Afɣanistan");
    namesMap.put("AG", "Untiga d Barbuda");
    namesMap.put("AI", "Ungiya");
    namesMap.put("AL", "Lalbani");
    namesMap.put("AM", "Arminya");
    namesMap.put("AN", "Antilles n Tmura-Yessakesren");
    namesMap.put("AO", "Ungula");
    namesMap.put("AR", "Arjuntin");
    namesMap.put("AS", "Samwa Tamarikanit");
    namesMap.put("AT", "Ustriya");
    namesMap.put("AU", "Ustrali");
    namesMap.put("AZ", "Azrabijan");
    namesMap.put("BA", "Busna d Hersek");
    namesMap.put("BB", "Barbadus");
    namesMap.put("BD", "Bangladac");
    namesMap.put("BE", "Belǧik");
    namesMap.put("BF", "Burkina Fasu");
    namesMap.put("BG", "Bulgari");
    namesMap.put("BH", "Baḥrin");
    namesMap.put("BI", "Burandi");
    namesMap.put("BJ", "Binin");
    namesMap.put("BN", "Bruney");
    namesMap.put("BO", "Bulivi");
    namesMap.put("BR", "Brizil");
    namesMap.put("BW", "Bustwana");
    namesMap.put("BY", "Bilarus");
    namesMap.put("BZ", "Biliz");
    namesMap.put("CA", "Kanada");
    namesMap.put("CD", "Tigduda Tagdudant n Kungu");
    namesMap.put("CF", "Tigduda n Tefriqt Talemmast");
    namesMap.put("CG", "Kungu");
    namesMap.put("CH", "Swis");
    namesMap.put("CI", "Kuṭ Divwar");
    namesMap.put("CK", "Tigzirin n Kuk");
    namesMap.put("CL", "Cili");
    namesMap.put("CM", "Kamirun");
    namesMap.put("CN", "Lacin");
    namesMap.put("CO", "Kulumbi");
    namesMap.put("CR", "Kusta Rika");
    namesMap.put("CS", "Sirbya d Muntinigru");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Tigzirin n yixef azegzaw");
    namesMap.put("CY", "Cipr");
    namesMap.put("CZ", "Čček");
    namesMap.put("DE", "Lalman");
    namesMap.put("DJ", "Ǧibuti");
    namesMap.put("DM", "Duminik");
    namesMap.put("DO", "Tigduda Taduminikit");
    namesMap.put("DZ", "Lezzayer");
    namesMap.put("EC", "Ikwaṭur");
    namesMap.put("EE", "Istunya");
    namesMap.put("EG", "Maṣr");
    namesMap.put("ER", "Iritiria");
    namesMap.put("ES", "Spanya");
    namesMap.put("ET", "Utyupi");
    namesMap.put("FI", "Finlund");
    namesMap.put("FK", "Tigzirin n Falkland");
    namesMap.put("FM", "Mikrunizya");
    namesMap.put("FR", "Fransa");
    namesMap.put("GA", "Gabun");
    namesMap.put("GB", "Tagelda Yedduklen");
    namesMap.put("GD", "Grunad");
    namesMap.put("GE", "Jiyurji");
    namesMap.put("GF", "Ɣana tafransist");
    namesMap.put("GH", "Ɣana");
    namesMap.put("GI", "Jibraltar");
    namesMap.put("GL", "Grunland");
    namesMap.put("GM", "Gambya");
    namesMap.put("GN", "Ɣinya");
    namesMap.put("GP", "Gwadalupi");
    namesMap.put("GQ", "Ɣinya Tasebgast");
    namesMap.put("GR", "Lagris");
    namesMap.put("GT", "Gwatimala");
    namesMap.put("GU", "Gwam");
    namesMap.put("GW", "Ɣinya-Bisaw");
    namesMap.put("GY", "Guwana");
    namesMap.put("HN", "Hunduras");
    namesMap.put("HR", "Kerwasya");
    namesMap.put("HT", "Hayti");
    namesMap.put("HU", "Hungri");
    namesMap.put("ID", "Indunizi");
    namesMap.put("IE", "Lirlund");
    namesMap.put("IL", "Izrayil");
    namesMap.put("IN", "Lhend");
    namesMap.put("IO", "Akal Aglizi deg Ugaraw Ahendi");
    namesMap.put("IQ", "Lɛiraq");
    namesMap.put("IS", "Island");
    namesMap.put("IT", "Ṭelyan");
    namesMap.put("JM", "Jamyika");
    namesMap.put("JO", "Lajurdani");
    namesMap.put("JP", "Jappu");
    namesMap.put("KE", "Kinya");
    namesMap.put("KG", "Kirigistan");
    namesMap.put("KH", "Cambudya");
    namesMap.put("KM", "Kumur");
    namesMap.put("KN", "San Kits d Nivis");
    namesMap.put("KP", "Kurya, Ufella");
    namesMap.put("KR", "Kurya, Wadda");
    namesMap.put("KW", "Kuwayt");
    namesMap.put("KY", "Tigzirin n Kamyan");
    namesMap.put("KZ", "Kazaxistan");
    namesMap.put("LA", "Laws");
    namesMap.put("LB", "Lubnan");
    namesMap.put("LC", "San Lučya");
    namesMap.put("LI", "Layctenstan");
    namesMap.put("LR", "Libirya");
    namesMap.put("LS", "Lizuṭu");
    namesMap.put("LT", "Liṭwanya");
    namesMap.put("LU", "Luksamburg");
    namesMap.put("MA", "Lmerruk");
    namesMap.put("MC", "Munaku");
    namesMap.put("MD", "Muldabi");
    namesMap.put("MG", "Madaɣecqer");
    namesMap.put("MH", "Tigzirin n Marcal");
    namesMap.put("MK", "Masidwan");
    namesMap.put("MM", "Myanmar");
    namesMap.put("MN", "Mungulya");
    namesMap.put("MP", "Tigzirin n Maryan Ufella");
    namesMap.put("MQ", "Martinik");
    namesMap.put("MR", "Muriṭanya");
    namesMap.put("MS", "Munsirat");
    namesMap.put("MT", "Malṭ");
    namesMap.put("MU", "Muris");
    namesMap.put("MV", "Maldib");
    namesMap.put("MX", "Meksik");
    namesMap.put("MY", "Malizya");
    namesMap.put("MZ", "Muzembiq");
    namesMap.put("NA", "Namibya");
    namesMap.put("NC", "Kalidunya Tamaynut");
    namesMap.put("NE", "Nijer");
    namesMap.put("NF", "Tigzirin Tinawfukin");
    namesMap.put("NG", "Nijirya");
    namesMap.put("NI", "Nikaragwa");
    namesMap.put("NL", "Timura-Yessakesren");
    namesMap.put("NO", "Nurvij");
    namesMap.put("NP", "Nipal");
    namesMap.put("NR", "Nuru");
    namesMap.put("NU", "Niwi");
    namesMap.put("NZ", "Ziland Tamaynut");
    namesMap.put("OM", "Ɛuman");
    namesMap.put("PA", "Panam");
    namesMap.put("PE", "Piru");
    namesMap.put("PF", "Pulunizi tafransist");
    namesMap.put("PG", "Ɣinya Tamaynut Tapaput");
    namesMap.put("PH", "Filipin");
    namesMap.put("PL", "Pulund");
    namesMap.put("PM", "San Pyar d Miklun");
    namesMap.put("PN", "Pitkarin");
    namesMap.put("PR", "Purtu Riku");
    namesMap.put("PS", "Falisṭin d Ɣezza");
    namesMap.put("PT", "Purtugal");
    namesMap.put("PW", "Palu");
    namesMap.put("PY", "Paragway");
    namesMap.put("QA", "Qaṭar");
    namesMap.put("RE", "Timlilit");
    namesMap.put("RO", "Rumani");
    namesMap.put("RU", "Rrus");
    namesMap.put("RW", "Ruwanda");
    namesMap.put("SA", "Suɛudiya Taɛrabt");
    namesMap.put("SB", "Tigzirin n Sulumun");
    namesMap.put("SC", "Seycel");
    namesMap.put("SE", "Swid");
    namesMap.put("SG", "Singafur");
    namesMap.put("SH", "Sant Ilina");
    namesMap.put("SI", "Sluvinya");
    namesMap.put("SK", "Sluvakya");
    namesMap.put("SL", "Sira Lyun");
    namesMap.put("SM", "San Marinu");
    namesMap.put("SN", "Sinigal");
    namesMap.put("SO", "Ṣumal");
    namesMap.put("SR", "Surinam");
    namesMap.put("ST", "Saw Tumi d Pransip");
    namesMap.put("SV", "Salvadur");
    namesMap.put("SY", "Surya");
    namesMap.put("SZ", "Swazilund");
    namesMap.put("TC", "Ṭurk d Tegzirin n Kaykus");
    namesMap.put("TD", "Čad");
    namesMap.put("TG", "Ṭugu");
    namesMap.put("TH", "Ṭayland");
    namesMap.put("TK", "Ṭuklu");
    namesMap.put("TL", "Tumur Asamar");
    namesMap.put("TM", "Ṭurkmanistan");
    namesMap.put("TN", "Tunes");
    namesMap.put("TO", "Ṭunga");
    namesMap.put("TR", "Ṭurk");
    namesMap.put("TT", "Ṭrindad d Ṭubagu");
    namesMap.put("TV", "Ṭuvalu");
    namesMap.put("TW", "Ṭaywan");
    namesMap.put("TZ", "Ṭanzanya");
    namesMap.put("UA", "Ukran");
    namesMap.put("UG", "Uɣanda");
    namesMap.put("US", "WDM");
    namesMap.put("UY", "Urugway");
    namesMap.put("UZ", "Uzbaxistan");
    namesMap.put("VA", "Awanek n Vatikan");
    namesMap.put("VC", "San Vansu d Grunadin");
    namesMap.put("VE", "Venzwila");
    namesMap.put("VG", "Tigzirin Tiverjiniyin Tigliziyin");
    namesMap.put("VI", "W.D. Tigzirin n Virginya");
    namesMap.put("VN", "Vyeṭnam");
    namesMap.put("VU", "Vanwatu");
    namesMap.put("WF", "Wallis d Futuna");
    namesMap.put("WS", "Samwa");
    namesMap.put("YE", "Lyamen");
    namesMap.put("YT", "Mayuṭ");
    namesMap.put("ZA", "Tafriqt Wadda");
    namesMap.put("ZM", "Zambya");
    namesMap.put("ZW", "Zimbabwi");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "Undura",
        "AE": "Tigeldunin Yedduklen Taɛrabin",
        "AF": "Afɣanistan",
        "AG": "Untiga d Barbuda",
        "AI": "Ungiya",
        "AL": "Lalbani",
        "AM": "Arminya",
        "AN": "Antilles n Tmura-Yessakesren",
        "AO": "Ungula",
        "AR": "Arjuntin",
        "AS": "Samwa Tamarikanit",
        "AT": "Ustriya",
        "AU": "Ustrali",
        "AZ": "Azrabijan",
        "BA": "Busna d Hersek",
        "BB": "Barbadus",
        "BD": "Bangladac",
        "BE": "Belǧik",
        "BF": "Burkina Fasu",
        "BG": "Bulgari",
        "BH": "Baḥrin",
        "BI": "Burandi",
        "BJ": "Binin",
        "BN": "Bruney",
        "BO": "Bulivi",
        "BR": "Brizil",
        "BW": "Bustwana",
        "BY": "Bilarus",
        "BZ": "Biliz",
        "CA": "Kanada",
        "CD": "Tigduda Tagdudant n Kungu",
        "CF": "Tigduda n Tefriqt Talemmast",
        "CG": "Kungu",
        "CH": "Swis",
        "CI": "Kuṭ Divwar",
        "CK": "Tigzirin n Kuk",
        "CL": "Cili",
        "CM": "Kamirun",
        "CN": "Lacin",
        "CO": "Kulumbi",
        "CR": "Kusta Rika",
        "CS": "Sirbya d Muntinigru",
        "CU": "Kuba",
        "CV": "Tigzirin n yixef azegzaw",
        "CY": "Cipr",
        "CZ": "Čček",
        "DE": "Lalman",
        "DJ": "Ǧibuti",
        "DM": "Duminik",
        "DO": "Tigduda Taduminikit",
        "DZ": "Lezzayer",
        "EC": "Ikwaṭur",
        "EE": "Istunya",
        "EG": "Maṣr",
        "ER": "Iritiria",
        "ES": "Spanya",
        "ET": "Utyupi",
        "FI": "Finlund",
        "FK": "Tigzirin n Falkland",
        "FM": "Mikrunizya",
        "FR": "Fransa",
        "GA": "Gabun",
        "GB": "Tagelda Yedduklen",
        "GD": "Grunad",
        "GE": "Jiyurji",
        "GF": "Ɣana tafransist",
        "GH": "Ɣana",
        "GI": "Jibraltar",
        "GL": "Grunland",
        "GM": "Gambya",
        "GN": "Ɣinya",
        "GP": "Gwadalupi",
        "GQ": "Ɣinya Tasebgast",
        "GR": "Lagris",
        "GT": "Gwatimala",
        "GU": "Gwam",
        "GW": "Ɣinya-Bisaw",
        "GY": "Guwana",
        "HN": "Hunduras",
        "HR": "Kerwasya",
        "HT": "Hayti",
        "HU": "Hungri",
        "ID": "Indunizi",
        "IE": "Lirlund",
        "IL": "Izrayil",
        "IN": "Lhend",
        "IO": "Akal Aglizi deg Ugaraw Ahendi",
        "IQ": "Lɛiraq",
        "IS": "Island",
        "IT": "Ṭelyan",
        "JM": "Jamyika",
        "JO": "Lajurdani",
        "JP": "Jappu",
        "KE": "Kinya",
        "KG": "Kirigistan",
        "KH": "Cambudya",
        "KM": "Kumur",
        "KN": "San Kits d Nivis",
        "KP": "Kurya, Ufella",
        "KR": "Kurya, Wadda",
        "KW": "Kuwayt",
        "KY": "Tigzirin n Kamyan",
        "KZ": "Kazaxistan",
        "LA": "Laws",
        "LB": "Lubnan",
        "LC": "San Lučya",
        "LI": "Layctenstan",
        "LR": "Libirya",
        "LS": "Lizuṭu",
        "LT": "Liṭwanya",
        "LU": "Luksamburg",
        "MA": "Lmerruk",
        "MC": "Munaku",
        "MD": "Muldabi",
        "MG": "Madaɣecqer",
        "MH": "Tigzirin n Marcal",
        "MK": "Masidwan",
        "MM": "Myanmar",
        "MN": "Mungulya",
        "MP": "Tigzirin n Maryan Ufella",
        "MQ": "Martinik",
        "MR": "Muriṭanya",
        "MS": "Munsirat",
        "MT": "Malṭ",
        "MU": "Muris",
        "MV": "Maldib",
        "MX": "Meksik",
        "MY": "Malizya",
        "MZ": "Muzembiq",
        "NA": "Namibya",
        "NC": "Kalidunya Tamaynut",
        "NE": "Nijer",
        "NF": "Tigzirin Tinawfukin",
        "NG": "Nijirya",
        "NI": "Nikaragwa",
        "NL": "Timura-Yessakesren",
        "NO": "Nurvij",
        "NP": "Nipal",
        "NR": "Nuru",
        "NU": "Niwi",
        "NZ": "Ziland Tamaynut",
        "OM": "Ɛuman",
        "PA": "Panam",
        "PE": "Piru",
        "PF": "Pulunizi tafransist",
        "PG": "Ɣinya Tamaynut Tapaput",
        "PH": "Filipin",
        "PL": "Pulund",
        "PM": "San Pyar d Miklun",
        "PN": "Pitkarin",
        "PR": "Purtu Riku",
        "PS": "Falisṭin d Ɣezza",
        "PT": "Purtugal",
        "PW": "Palu",
        "PY": "Paragway",
        "QA": "Qaṭar",
        "RE": "Timlilit",
        "RO": "Rumani",
        "RU": "Rrus",
        "RW": "Ruwanda",
        "SA": "Suɛudiya Taɛrabt",
        "SB": "Tigzirin n Sulumun",
        "SC": "Seycel",
        "SE": "Swid",
        "SG": "Singafur",
        "SH": "Sant Ilina",
        "SI": "Sluvinya",
        "SK": "Sluvakya",
        "SL": "Sira Lyun",
        "SM": "San Marinu",
        "SN": "Sinigal",
        "SO": "Ṣumal",
        "SR": "Surinam",
        "ST": "Saw Tumi d Pransip",
        "SV": "Salvadur",
        "SY": "Surya",
        "SZ": "Swazilund",
        "TC": "Ṭurk d Tegzirin n Kaykus",
        "TD": "Čad",
        "TG": "Ṭugu",
        "TH": "Ṭayland",
        "TK": "Ṭuklu",
        "TL": "Tumur Asamar",
        "TM": "Ṭurkmanistan",
        "TN": "Tunes",
        "TO": "Ṭunga",
        "TR": "Ṭurk",
        "TT": "Ṭrindad d Ṭubagu",
        "TV": "Ṭuvalu",
        "TW": "Ṭaywan",
        "TZ": "Ṭanzanya",
        "UA": "Ukran",
        "UG": "Uɣanda",
        "US": "WDM",
        "UY": "Urugway",
        "UZ": "Uzbaxistan",
        "VA": "Awanek n Vatikan",
        "VC": "San Vansu d Grunadin",
        "VE": "Venzwila",
        "VG": "Tigzirin Tiverjiniyin Tigliziyin",
        "VI": "W.D. Tigzirin n Virginya",
        "VN": "Vyeṭnam",
        "VU": "Vanwatu",
        "WF": "Wallis d Futuna",
        "WS": "Samwa",
        "YE": "Lyamen",
        "YT": "Mayuṭ",
        "ZA": "Tafriqt Wadda",
        "ZM": "Zambya",
        "ZW": "Zimbabwi"
    };
  }-*/;
}
