/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc;

import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.impl.StandardSerializationPolicy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SerializationPolicyLoader {
    public static final String SERIALIZATION_POLICY_FILE_ENCODING = "UTF-8";
    private static final String FORMAT_ERROR_MESSAGE = "Expected: className, [true | false]";

    public static String getSerializationPolicyFileName(String serializationPolicyStrongName) {
        return serializationPolicyStrongName + ".gwt.rpc";
    }

    @Deprecated
    public static SerializationPolicy loadFromStream(InputStream inputStream) throws IOException, ParseException, ClassNotFoundException {
        ArrayList<ClassNotFoundException> classNotFoundExceptions = new ArrayList<ClassNotFoundException>();
        SerializationPolicy serializationPolicy = SerializationPolicyLoader.loadFromStream(inputStream, classNotFoundExceptions);
        if (!classNotFoundExceptions.isEmpty()) {
            throw (ClassNotFoundException)classNotFoundExceptions.get(0);
        }
        return serializationPolicy;
    }

    public static SerializationPolicy loadFromStream(InputStream inputStream, List<ClassNotFoundException> classNotFoundExceptions) throws IOException, ParseException {
        if (inputStream == null) {
            throw new NullPointerException("inputStream");
        }
        HashMap whitelist = new HashMap();
        InputStreamReader isr = new InputStreamReader(inputStream, SERIALIZATION_POLICY_FILE_ENCODING);
        BufferedReader br = new BufferedReader(isr);
        String line = br.readLine();
        int lineNum = 1;
        while (line != null) {
            block7: {
                if ((line = line.trim()).length() > 0) {
                    String[] components = line.split(",");
                    if (components.length != 2) {
                        throw new ParseException(FORMAT_ERROR_MESSAGE, lineNum);
                    }
                    String binaryTypeName = components[0].trim();
                    String instantiable = components[1].trim();
                    if (binaryTypeName.length() == 0 || instantiable.length() == 0) {
                        throw new ParseException(FORMAT_ERROR_MESSAGE, lineNum);
                    }
                    ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        Class<?> clazz = Class.forName(binaryTypeName, false, contextClassLoader);
                        whitelist.put(clazz, Boolean.valueOf(instantiable));
                    }
                    catch (ClassNotFoundException ex) {
                        if (classNotFoundExceptions == null) break block7;
                        classNotFoundExceptions.add(ex);
                    }
                }
            }
            line = br.readLine();
            ++lineNum;
        }
        return new StandardSerializationPolicy(whitelist);
    }

    private SerializationPolicyLoader() {
    }
}

