/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;

public class GraphUtils {
    public static <D, N extends TarjanNode<D, N>> List<? extends List<? extends N>> tarjan(Iterable<? extends N> nodes) {
        ListBuffer<List<N>> cycles = new ListBuffer<List<N>>();
        ListBuffer stack = new ListBuffer();
        int index = 0;
        for (TarjanNode node : nodes) {
            if (node.index != -1) continue;
            index += GraphUtils.tarjan(node, index, stack, cycles);
        }
        return cycles.toList();
    }

    private static <D, N extends TarjanNode<D, N>> int tarjan(N v, int index, ListBuffer<N> stack, ListBuffer<List<N>> cycles) {
        v.index = index;
        v.lowlink = index++;
        stack.prepend(v);
        v.active = true;
        for (TarjanNode n : v.getAllDependencies()) {
            if (n.index == -1) {
                GraphUtils.tarjan(n, index, stack, cycles);
                v.lowlink = Math.min(v.lowlink, n.lowlink);
                continue;
            }
            if (!stack.contains(n)) continue;
            v.lowlink = Math.min(v.lowlink, n.index);
        }
        if (v.lowlink == v.index) {
            TarjanNode n;
            ListBuffer<TarjanNode> cycle = new ListBuffer<TarjanNode>();
            do {
                n = (TarjanNode)stack.remove();
                n.active = false;
                cycle.add(n);
            } while (n != v);
            cycles.add(cycle.toList());
        }
        return index;
    }

    public static <D, N extends DottableNode<D, N>> String toDot(Collection<? extends N> nodes, String name, String header) {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("digraph %s {\n", name));
        buf.append(String.format("label = %s;\n", DotVisitor.wrap(header)));
        DotVisitor dotVisitor = new DotVisitor();
        dotVisitor.visit(nodes, buf);
        buf.append("}\n");
        return buf.toString();
    }

    public static class DotVisitor<D, N extends DottableNode<D, N>>
    extends NodeVisitor<D, N, StringBuilder> {
        @Override
        public void visitDependency(DependencyKind dk, N from, N to, StringBuilder buf) {
            buf.append(String.format("%s -> %s", from.hashCode(), to.hashCode()));
            buf.append(this.formatProperties(from.dependencyAttributes(to, dk)));
            buf.append('\n');
        }

        @Override
        public void visitNode(N node, StringBuilder buf) {
            buf.append(String.format("%s ", node.hashCode()));
            buf.append(this.formatProperties(node.nodeAttributes()));
            buf.append('\n');
        }

        protected String formatProperties(Properties p) {
            return p.toString().replaceAll(",", " ").replaceAll("\\{", "[").replaceAll("\\}", "]");
        }

        protected static String wrap(String s) {
            String string = String.valueOf(String.valueOf(s));
            String res = new StringBuilder(2 + string.length()).append("\"").append(string).append("\"").toString();
            return res.replaceAll("\n", "");
        }
    }

    public static abstract class TarjanNode<D, N extends TarjanNode<D, N>>
    extends AbstractNode<D, N>
    implements Comparable<N> {
        int index = -1;
        int lowlink;
        boolean active;

        public TarjanNode(D data) {
            super(data);
        }

        public abstract Iterable<? extends N> getAllDependencies();

        @Override
        public int compareTo(N o) {
            return this.index < ((TarjanNode)o).index ? -1 : (this.index == ((TarjanNode)o).index ? 0 : 1);
        }
    }

    public static abstract class AbstractNode<D, N extends AbstractNode<D, N>>
    implements Node<D, N> {
        public final D data;

        public AbstractNode(D data) {
            this.data = data;
        }

        public abstract DependencyKind[] getSupportedDependencyKinds();

        public abstract Collection<? extends N> getDependenciesByKind(DependencyKind var1);

        public String toString() {
            return this.data.toString();
        }

        @Override
        public <A> void accept(NodeVisitor<D, N, A> visitor, A arg) {
            visitor.visitNode(this, arg);
            for (DependencyKind dk : this.getSupportedDependencyKinds()) {
                for (AbstractNode dep : new ArrayList<N>(this.getDependenciesByKind(dk))) {
                    visitor.visitDependency(dk, this, dep, arg);
                }
            }
        }
    }

    public static interface DottableNode<D, N extends DottableNode<D, N>>
    extends Node<D, N> {
        public Properties nodeAttributes();

        public Properties dependencyAttributes(N var1, DependencyKind var2);
    }

    static abstract class NodeVisitor<D, N extends Node<D, N>, A> {
        NodeVisitor() {
        }

        public abstract void visitNode(N var1, A var2);

        public abstract void visitDependency(DependencyKind var1, N var2, N var3, A var4);

        public void visit(Collection<? extends N> nodes, A arg) {
            for (Node n : new ArrayList<N>(nodes)) {
                n.accept(this, arg);
            }
        }
    }

    public static interface Node<D, N extends Node<D, N>> {
        public <A> void accept(NodeVisitor<D, N, A> var1, A var2);
    }

    public static interface DependencyKind {
    }
}

