/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.file;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.openjdk.tools.javac.util.Context;

public class FSInfo {
    private FileSystemProvider jarFSProvider;

    public static FSInfo instance(Context context) {
        FSInfo fSInfo = context.get(FSInfo.class);
        if (fSInfo == null) {
            fSInfo = new FSInfo();
        }
        return fSInfo;
    }

    protected FSInfo() {
    }

    protected FSInfo(Context context) {
        context.put(FSInfo.class, this);
    }

    public Path getCanonicalFile(Path path) {
        try {
            return path.toRealPath(new LinkOption[0]);
        }
        catch (IOException iOException) {
            return path.toAbsolutePath().normalize();
        }
    }

    public boolean exists(Path path) {
        return Files.exists(path, new LinkOption[0]);
    }

    public boolean isDirectory(Path path) {
        return Files.isDirectory(path, new LinkOption[0]);
    }

    public boolean isFile(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]);
    }

    public List<Path> getJarClassPath(Path path) throws IOException {
        Path path2 = path.getParent();
        try (JarFile jarFile = new JarFile(path.toFile());){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                List<Path> list = Collections.emptyList();
                return list;
            }
            Attributes attributes = manifest.getMainAttributes();
            if (attributes == null) {
                List<Path> list = Collections.emptyList();
                return list;
            }
            String string = attributes.getValue(Attributes.Name.CLASS_PATH);
            if (string == null) {
                List<Path> list = Collections.emptyList();
                return list;
            }
            ArrayList<Path> arrayList = new ArrayList<Path>();
            Object object = new StringTokenizer(string);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                Path path3 = FileSystems.getDefault().getPath(string2, new String[0]);
                if (!path3.isAbsolute() && path2 != null) {
                    path3 = path2.resolve(path3).toAbsolutePath();
                }
                arrayList.add(path3);
            }
            object = arrayList;
            return object;
        }
    }

    public synchronized FileSystemProvider getJarFSProvider() {
        if (this.jarFSProvider != null) {
            return this.jarFSProvider;
        }
        for (FileSystemProvider fileSystemProvider : FileSystemProvider.installedProviders()) {
            if (!fileSystemProvider.getScheme().equals("jar")) continue;
            this.jarFSProvider = fileSystemProvider;
            return this.jarFSProvider;
        }
        return null;
    }
}

