/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.sql;

import com.google.cloud.spring.autoconfigure.sql.CloudSqlJdbcInfoProvider;
import com.google.cloud.spring.autoconfigure.sql.DatabaseType;
import com.google.cloud.spring.autoconfigure.sql.GcpCloudSqlProperties;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultCloudSqlJdbcInfoProvider
implements CloudSqlJdbcInfoProvider {
    private final GcpCloudSqlProperties properties;
    private final DatabaseType databaseType;

    public DefaultCloudSqlJdbcInfoProvider(GcpCloudSqlProperties properties, DatabaseType databaseType) {
        this.properties = properties;
        this.databaseType = databaseType;
        Assert.hasText((String)this.properties.getDatabaseName(), (String)"A database name must be provided.");
        if (!StringUtils.hasLength((String)properties.getDnsName()) && !StringUtils.hasLength((String)properties.getInstanceConnectionName())) {
            throw new IllegalArgumentException("A DNS name or instance connection name must be provided. Instance connection should be in the format <PROJECT_ID>:<REGION>:<INSTANCE_ID>.");
        }
    }

    @Override
    public String getJdbcDriverClass() {
        return this.databaseType.getJdbcDriverName();
    }

    @Override
    public String getJdbcUrl() {
        LinkedHashMap<String, String> urlParams = new LinkedHashMap<String, String>();
        if (StringUtils.hasText((String)this.properties.getInstanceConnectionName())) {
            urlParams.put("cloudSqlInstance", this.properties.getInstanceConnectionName());
        }
        if (StringUtils.hasText((String)this.properties.getIpTypes())) {
            urlParams.put("ipTypes", this.properties.getIpTypes());
        }
        if (this.properties.isEnableIamAuth()) {
            urlParams.put("enableIamAuth", "true");
            urlParams.put("sslmode", "disable");
        }
        if (StringUtils.hasText((String)this.properties.getTargetPrincipal())) {
            urlParams.put("cloudSqlTargetPrincipal", this.properties.getTargetPrincipal());
        }
        if (StringUtils.hasText((String)this.properties.getDelegates())) {
            urlParams.put("cloudSqlDelegates", this.properties.getDelegates());
        }
        if (StringUtils.hasText((String)this.properties.getAdminRootUrl())) {
            urlParams.put("cloudSqlAdminRootUrl", this.properties.getAdminRootUrl());
        }
        if (StringUtils.hasText((String)this.properties.getAdminServicePath())) {
            urlParams.put("cloudSqlAdminServicePath", this.properties.getAdminServicePath());
        }
        if (StringUtils.hasText((String)this.properties.getAdminQuotaProject())) {
            urlParams.put("cloudSqlAdminQuotaProject", this.properties.getAdminQuotaProject());
        }
        if (StringUtils.hasText((String)this.properties.getUniverseDomain())) {
            urlParams.put("cloudSqlUniverseDomain", this.properties.getUniverseDomain());
        }
        if (StringUtils.hasText((String)this.properties.getRefreshStrategy())) {
            urlParams.put("cloudSqlRefreshStrategy", this.properties.getRefreshStrategy());
        }
        String urlParamsString = urlParams.entrySet().stream().map(entry -> {
            try {
                if ("cloudSqlInstance".equals(entry.getKey())) {
                    return URLEncoder.encode((String)entry.getKey(), "UTF-8") + "=" + (String)entry.getValue();
                }
                return URLEncoder.encode((String)entry.getKey(), "UTF-8") + "=" + URLEncoder.encode((String)entry.getValue());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UTF-8 charset missing.", e);
            }
        }).collect(Collectors.joining("&"));
        String dnsName = StringUtils.hasLength((String)this.properties.getDnsName()) ? this.properties.getDnsName() : "google";
        Object jdbcUrl = String.format(this.databaseType.getJdbcUrlTemplate(), dnsName, this.properties.getDatabaseName(), this.properties.getInstanceConnectionName());
        if (StringUtils.hasText((String)urlParamsString)) {
            jdbcUrl = (String)jdbcUrl + "&" + urlParamsString;
        }
        return jdbcUrl;
    }
}

