/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.firestore;

import com.google.cloud.spring.autoconfigure.firestore.GcpFirestoreAutoConfiguration;
import com.google.cloud.spring.autoconfigure.firestore.GcpFirestoreProperties;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.data.firestore.mapping.FirestoreClassMapper;
import com.google.cloud.spring.data.firestore.transaction.ReactiveFirestoreTransactionManager;
import com.google.firestore.v1.FirestoreGrpc;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.transaction.TransactionAutoConfiguration;
import org.springframework.context.annotation.Bean;
import reactor.core.publisher.Flux;

@AutoConfiguration
@ConditionalOnClass(value={ReactiveFirestoreTransactionManager.class, FirestoreGrpc.FirestoreStub.class, Flux.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.firestore.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={TransactionAutoConfiguration.class})
@AutoConfigureAfter(value={GcpFirestoreAutoConfiguration.class})
public class FirestoreTransactionManagerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ReactiveFirestoreTransactionManager firestoreTransactionManager(FirestoreGrpc.FirestoreStub firestoreStub, FirestoreClassMapper classMapper, GcpFirestoreProperties gcpFirestoreProperties, GcpProjectIdProvider projectIdProvider) {
        String firestoreRootPath = gcpFirestoreProperties.getFirestoreRootPath(projectIdProvider);
        return new ReactiveFirestoreTransactionManager(firestoreStub, firestoreRootPath, classMapper);
    }
}

