/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.util;

import com.google.appengine.tools.info.SdkImplInfo;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class Logging {
    public static final String LOGGING_CONFIG_FILE = "java.util.logging.config.file";
    private static final Logger log = Logger.getLogger(Logging.class.getName());

    public static void initializeLogging() {
        String logConfig = System.getProperty(LOGGING_CONFIG_FILE);
        if (logConfig == null) {
            File config = SdkImplInfo.getLoggingProperties();
            System.setProperty(LOGGING_CONFIG_FILE, config.getAbsolutePath());
            try {
                LogManager.getLogManager().readConfiguration();
            }
            catch (Exception e) {
                log.log(Level.INFO, "Failed to read the default logging configuration", e);
            }
        }
    }

    private Logging() {
    }
}

