/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.dev.Scorer;
import com.google.appengine.repackaged.com.google.appengine.api.search.SearchServicePb;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopFieldDocs;

public class SimpleScorer
extends Scorer {
    private final Sort sort;

    public SimpleScorer(Sort sort) {
        this.sort = sort;
    }

    static Sort naturalOrder() {
        return new Sort(new SortField("_ORDERID", 4, true));
    }

    @Override
    public Scorer.SearchResults search(IndexSearcher indexSearcher, Query q, int offset, int limit) throws IOException {
        int docsToFind = offset + limit;
        TopFieldDocs topDocs = indexSearcher.search(q, null, docsToFind, this.sort);
        int max = Math.min(topDocs.scoreDocs.length, docsToFind);
        if (max < offset) {
            return new Scorer.SearchResults(new Result[0], 0);
        }
        Scorer.Result[] resultsArray = new Result[max - offset];
        for (int i = offset; i < max; ++i) {
            resultsArray[i - offset] = new Result(indexSearcher.doc(topDocs.scoreDocs[i].doc));
        }
        return new Scorer.SearchResults(resultsArray, topDocs.totalHits);
    }

    public class Result
    extends Scorer.Result {
        public Result(Document doc) {
            super(doc);
        }

        @Override
        public void addScores(SearchServicePb.SearchResult.Builder resultBuilder) {
        }
    }
}

