/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.files.dev;

import com.google.apphosting.api.ApiProxy;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParsedFileName {
    private String fileSystem;
    private String namePart;
    private static final String regex = "^/([^/]+)/([^\\?]+)$";
    private static final Pattern pattern = Pattern.compile("^/([^/]+)/([^\\?]+)$");

    public ParsedFileName(String decoratedName) {
        Matcher m = pattern.matcher(decoratedName);
        if (!m.matches()) {
            throw new ApiProxy.ApplicationException(5, decoratedName);
        }
        this.fileSystem = m.group(1);
        this.namePart = m.group(2);
    }

    public String getFileSystem() {
        return this.fileSystem;
    }

    public String getNamePart() {
        return this.namePart;
    }

    public String getFullPath() {
        return "/" + this.fileSystem + "/" + this.namePart;
    }
}

