/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.http.client.protocol;

import com.google.appengine.repackaged.org.apache.commons.logging.Log;
import com.google.appengine.repackaged.org.apache.commons.logging.LogFactory;
import com.google.appengine.repackaged.org.apache.http.HttpException;
import com.google.appengine.repackaged.org.apache.http.HttpRequest;
import com.google.appengine.repackaged.org.apache.http.HttpRequestInterceptor;
import com.google.appengine.repackaged.org.apache.http.annotation.Immutable;
import com.google.appengine.repackaged.org.apache.http.auth.AuthScheme;
import com.google.appengine.repackaged.org.apache.http.auth.AuthState;
import com.google.appengine.repackaged.org.apache.http.auth.AuthenticationException;
import com.google.appengine.repackaged.org.apache.http.auth.Credentials;
import com.google.appengine.repackaged.org.apache.http.protocol.HttpContext;
import java.io.IOException;

@Immutable
public class RequestProxyAuthentication
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        block9: {
            if (request == null) {
                throw new IllegalArgumentException("HTTP request may not be null");
            }
            if (context == null) {
                throw new IllegalArgumentException("HTTP context may not be null");
            }
            if (request.containsHeader("Proxy-Authorization")) {
                return;
            }
            AuthState authState = (AuthState)context.getAttribute("http.auth.proxy-scope");
            if (authState == null) {
                return;
            }
            AuthScheme authScheme = authState.getAuthScheme();
            if (authScheme == null) {
                return;
            }
            Credentials creds = authState.getCredentials();
            if (creds == null) {
                this.log.debug("User credentials not available");
                return;
            }
            if (authState.getAuthScope() != null || !authScheme.isConnectionBased()) {
                try {
                    request.addHeader(authScheme.authenticate(creds, request));
                }
                catch (AuthenticationException ex) {
                    if (!this.log.isErrorEnabled()) break block9;
                    this.log.error("Proxy authentication error: " + ex.getMessage());
                }
            }
        }
    }
}

