/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.util;

import java.io.InterruptedIOException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExceptionUtil {
    private static final Log LOG = LogFactory.getLog(ExceptionUtil.class);
    private static final Method INIT_CAUSE_METHOD = ExceptionUtil.getInitCauseMethod();
    private static final Class SOCKET_TIMEOUT_CLASS = ExceptionUtil.SocketTimeoutExceptionClass();

    private static Method getInitCauseMethod() {
        try {
            Class[] classArray = new Class[]{Throwable.class};
            return Throwable.class.getMethod("initCause", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Class SocketTimeoutExceptionClass() {
        try {
            return Class.forName("java.net.SocketTimeoutException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static void initCause(Throwable throwable, Throwable throwable2) {
        if (INIT_CAUSE_METHOD != null) {
            try {
                INIT_CAUSE_METHOD.invoke((Object)throwable, throwable2);
            }
            catch (Exception exception) {
                LOG.warn("Exception invoking Throwable.initCause", exception);
            }
        }
    }

    public static boolean isSocketTimeoutException(InterruptedIOException interruptedIOException) {
        if (SOCKET_TIMEOUT_CLASS != null) {
            return SOCKET_TIMEOUT_CLASS.isInstance(interruptedIOException);
        }
        return true;
    }
}

