/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/batch/v1/task.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.batch.v1;

/**
 *
 *
 * <pre>
 * An Environment describes a collection of environment variables to set when
 * executing Tasks.
 * </pre>
 *
 * Protobuf type {@code google.cloud.batch.v1.Environment}
 */
public final class Environment extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.batch.v1.Environment)
    EnvironmentOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Environment.newBuilder() to construct.
  private Environment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Environment() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Environment();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.batch.v1.TaskProto
        .internal_static_google_cloud_batch_v1_Environment_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 1:
        return internalGetVariables();
      case 2:
        return internalGetSecretVariables();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.batch.v1.TaskProto
        .internal_static_google_cloud_batch_v1_Environment_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.batch.v1.Environment.class,
            com.google.cloud.batch.v1.Environment.Builder.class);
  }

  public interface KMSEnvMapOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.batch.v1.Environment.KMSEnvMap)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the KMS key that will be used to decrypt the cipher text.
     * </pre>
     *
     * <code>string key_name = 1;</code>
     *
     * @return The keyName.
     */
    java.lang.String getKeyName();

    /**
     *
     *
     * <pre>
     * The name of the KMS key that will be used to decrypt the cipher text.
     * </pre>
     *
     * <code>string key_name = 1;</code>
     *
     * @return The bytes for keyName.
     */
    com.google.protobuf.ByteString getKeyNameBytes();

    /**
     *
     *
     * <pre>
     * The value of the cipherText response from the `encrypt` method.
     * </pre>
     *
     * <code>string cipher_text = 2;</code>
     *
     * @return The cipherText.
     */
    java.lang.String getCipherText();

    /**
     *
     *
     * <pre>
     * The value of the cipherText response from the `encrypt` method.
     * </pre>
     *
     * <code>string cipher_text = 2;</code>
     *
     * @return The bytes for cipherText.
     */
    com.google.protobuf.ByteString getCipherTextBytes();
  }

  /** Protobuf type {@code google.cloud.batch.v1.Environment.KMSEnvMap} */
  public static final class KMSEnvMap extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.batch.v1.Environment.KMSEnvMap)
      KMSEnvMapOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use KMSEnvMap.newBuilder() to construct.
    private KMSEnvMap(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private KMSEnvMap() {
      keyName_ = "";
      cipherText_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new KMSEnvMap();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1.TaskProto
          .internal_static_google_cloud_batch_v1_Environment_KMSEnvMap_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1.TaskProto
          .internal_static_google_cloud_batch_v1_Environment_KMSEnvMap_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1.Environment.KMSEnvMap.class,
              com.google.cloud.batch.v1.Environment.KMSEnvMap.Builder.class);
    }

    public static final int KEY_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object keyName_ = "";

    /**
     *
     *
     * <pre>
     * The name of the KMS key that will be used to decrypt the cipher text.
     * </pre>
     *
     * <code>string key_name = 1;</code>
     *
     * @return The keyName.
     */
    @java.lang.Override
    public java.lang.String getKeyName() {
      java.lang.Object ref = keyName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        keyName_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the KMS key that will be used to decrypt the cipher text.
     * </pre>
     *
     * <code>string key_name = 1;</code>
     *
     * @return The bytes for keyName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getKeyNameBytes() {
      java.lang.Object ref = keyName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        keyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CIPHER_TEXT_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object cipherText_ = "";

    /**
     *
     *
     * <pre>
     * The value of the cipherText response from the `encrypt` method.
     * </pre>
     *
     * <code>string cipher_text = 2;</code>
     *
     * @return The cipherText.
     */
    @java.lang.Override
    public java.lang.String getCipherText() {
      java.lang.Object ref = cipherText_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cipherText_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The value of the cipherText response from the `encrypt` method.
     * </pre>
     *
     * <code>string cipher_text = 2;</code>
     *
     * @return The bytes for cipherText.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCipherTextBytes() {
      java.lang.Object ref = cipherText_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cipherText_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(keyName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, keyName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cipherText_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, cipherText_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(keyName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, keyName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cipherText_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, cipherText_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.batch.v1.Environment.KMSEnvMap)) {
        return super.equals(obj);
      }
      com.google.cloud.batch.v1.Environment.KMSEnvMap other =
          (com.google.cloud.batch.v1.Environment.KMSEnvMap) obj;

      if (!getKeyName().equals(other.getKeyName())) return false;
      if (!getCipherText().equals(other.getCipherText())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + KEY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getKeyName().hashCode();
      hash = (37 * hash) + CIPHER_TEXT_FIELD_NUMBER;
      hash = (53 * hash) + getCipherText().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.batch.v1.Environment.KMSEnvMap parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1.Environment.KMSEnvMap parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1.Environment.KMSEnvMap parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1.Environment.KMSEnvMap parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1.Environment.KMSEnvMap parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1.Environment.KMSEnvMap parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1.Environment.KMSEnvMap parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1.Environment.KMSEnvMap parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1.Environment.KMSEnvMap parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1.Environment.KMSEnvMap parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1.Environment.KMSEnvMap parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1.Environment.KMSEnvMap parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.batch.v1.Environment.KMSEnvMap prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /** Protobuf type {@code google.cloud.batch.v1.Environment.KMSEnvMap} */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1.Environment.KMSEnvMap)
        com.google.cloud.batch.v1.Environment.KMSEnvMapOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.batch.v1.TaskProto
            .internal_static_google_cloud_batch_v1_Environment_KMSEnvMap_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.batch.v1.TaskProto
            .internal_static_google_cloud_batch_v1_Environment_KMSEnvMap_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.batch.v1.Environment.KMSEnvMap.class,
                com.google.cloud.batch.v1.Environment.KMSEnvMap.Builder.class);
      }

      // Construct using com.google.cloud.batch.v1.Environment.KMSEnvMap.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        keyName_ = "";
        cipherText_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.batch.v1.TaskProto
            .internal_static_google_cloud_batch_v1_Environment_KMSEnvMap_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1.Environment.KMSEnvMap getDefaultInstanceForType() {
        return com.google.cloud.batch.v1.Environment.KMSEnvMap.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.batch.v1.Environment.KMSEnvMap build() {
        com.google.cloud.batch.v1.Environment.KMSEnvMap result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1.Environment.KMSEnvMap buildPartial() {
        com.google.cloud.batch.v1.Environment.KMSEnvMap result =
            new com.google.cloud.batch.v1.Environment.KMSEnvMap(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.batch.v1.Environment.KMSEnvMap result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.keyName_ = keyName_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.cipherText_ = cipherText_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.batch.v1.Environment.KMSEnvMap) {
          return mergeFrom((com.google.cloud.batch.v1.Environment.KMSEnvMap) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.batch.v1.Environment.KMSEnvMap other) {
        if (other == com.google.cloud.batch.v1.Environment.KMSEnvMap.getDefaultInstance())
          return this;
        if (!other.getKeyName().isEmpty()) {
          keyName_ = other.keyName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getCipherText().isEmpty()) {
          cipherText_ = other.cipherText_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  keyName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  cipherText_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object keyName_ = "";

      /**
       *
       *
       * <pre>
       * The name of the KMS key that will be used to decrypt the cipher text.
       * </pre>
       *
       * <code>string key_name = 1;</code>
       *
       * @return The keyName.
       */
      public java.lang.String getKeyName() {
        java.lang.Object ref = keyName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          keyName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The name of the KMS key that will be used to decrypt the cipher text.
       * </pre>
       *
       * <code>string key_name = 1;</code>
       *
       * @return The bytes for keyName.
       */
      public com.google.protobuf.ByteString getKeyNameBytes() {
        java.lang.Object ref = keyName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          keyName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The name of the KMS key that will be used to decrypt the cipher text.
       * </pre>
       *
       * <code>string key_name = 1;</code>
       *
       * @param value The keyName to set.
       * @return This builder for chaining.
       */
      public Builder setKeyName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        keyName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The name of the KMS key that will be used to decrypt the cipher text.
       * </pre>
       *
       * <code>string key_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKeyName() {
        keyName_ = getDefaultInstance().getKeyName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The name of the KMS key that will be used to decrypt the cipher text.
       * </pre>
       *
       * <code>string key_name = 1;</code>
       *
       * @param value The bytes for keyName to set.
       * @return This builder for chaining.
       */
      public Builder setKeyNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        keyName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object cipherText_ = "";

      /**
       *
       *
       * <pre>
       * The value of the cipherText response from the `encrypt` method.
       * </pre>
       *
       * <code>string cipher_text = 2;</code>
       *
       * @return The cipherText.
       */
      public java.lang.String getCipherText() {
        java.lang.Object ref = cipherText_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          cipherText_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The value of the cipherText response from the `encrypt` method.
       * </pre>
       *
       * <code>string cipher_text = 2;</code>
       *
       * @return The bytes for cipherText.
       */
      public com.google.protobuf.ByteString getCipherTextBytes() {
        java.lang.Object ref = cipherText_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          cipherText_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The value of the cipherText response from the `encrypt` method.
       * </pre>
       *
       * <code>string cipher_text = 2;</code>
       *
       * @param value The cipherText to set.
       * @return This builder for chaining.
       */
      public Builder setCipherText(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        cipherText_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The value of the cipherText response from the `encrypt` method.
       * </pre>
       *
       * <code>string cipher_text = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCipherText() {
        cipherText_ = getDefaultInstance().getCipherText();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The value of the cipherText response from the `encrypt` method.
       * </pre>
       *
       * <code>string cipher_text = 2;</code>
       *
       * @param value The bytes for cipherText to set.
       * @return This builder for chaining.
       */
      public Builder setCipherTextBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        cipherText_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1.Environment.KMSEnvMap)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.batch.v1.Environment.KMSEnvMap)
    private static final com.google.cloud.batch.v1.Environment.KMSEnvMap DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.batch.v1.Environment.KMSEnvMap();
    }

    public static com.google.cloud.batch.v1.Environment.KMSEnvMap getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<KMSEnvMap> PARSER =
        new com.google.protobuf.AbstractParser<KMSEnvMap>() {
          @java.lang.Override
          public KMSEnvMap parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<KMSEnvMap> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<KMSEnvMap> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1.Environment.KMSEnvMap getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int VARIABLES_FIELD_NUMBER = 1;

  private static final class VariablesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.batch.v1.TaskProto
                .internal_static_google_cloud_batch_v1_Environment_VariablesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> variables_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetVariables() {
    if (variables_ == null) {
      return com.google.protobuf.MapField.emptyMapField(VariablesDefaultEntryHolder.defaultEntry);
    }
    return variables_;
  }

  public int getVariablesCount() {
    return internalGetVariables().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * A map of environment variable names to values.
   * </pre>
   *
   * <code>map&lt;string, string&gt; variables = 1;</code>
   */
  @java.lang.Override
  public boolean containsVariables(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetVariables().getMap().containsKey(key);
  }

  /** Use {@link #getVariablesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getVariables() {
    return getVariablesMap();
  }

  /**
   *
   *
   * <pre>
   * A map of environment variable names to values.
   * </pre>
   *
   * <code>map&lt;string, string&gt; variables = 1;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getVariablesMap() {
    return internalGetVariables().getMap();
  }

  /**
   *
   *
   * <pre>
   * A map of environment variable names to values.
   * </pre>
   *
   * <code>map&lt;string, string&gt; variables = 1;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getVariablesOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetVariables().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * A map of environment variable names to values.
   * </pre>
   *
   * <code>map&lt;string, string&gt; variables = 1;</code>
   */
  @java.lang.Override
  public java.lang.String getVariablesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetVariables().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int SECRET_VARIABLES_FIELD_NUMBER = 2;

  private static final class SecretVariablesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.batch.v1.TaskProto
                .internal_static_google_cloud_batch_v1_Environment_SecretVariablesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> secretVariables_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetSecretVariables() {
    if (secretVariables_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          SecretVariablesDefaultEntryHolder.defaultEntry);
    }
    return secretVariables_;
  }

  public int getSecretVariablesCount() {
    return internalGetSecretVariables().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * A map of environment variable names to Secret Manager secret names.
   * The VM will access the named secrets to set the value of each environment
   * variable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; secret_variables = 2;</code>
   */
  @java.lang.Override
  public boolean containsSecretVariables(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetSecretVariables().getMap().containsKey(key);
  }

  /** Use {@link #getSecretVariablesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getSecretVariables() {
    return getSecretVariablesMap();
  }

  /**
   *
   *
   * <pre>
   * A map of environment variable names to Secret Manager secret names.
   * The VM will access the named secrets to set the value of each environment
   * variable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; secret_variables = 2;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getSecretVariablesMap() {
    return internalGetSecretVariables().getMap();
  }

  /**
   *
   *
   * <pre>
   * A map of environment variable names to Secret Manager secret names.
   * The VM will access the named secrets to set the value of each environment
   * variable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; secret_variables = 2;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getSecretVariablesOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetSecretVariables().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * A map of environment variable names to Secret Manager secret names.
   * The VM will access the named secrets to set the value of each environment
   * variable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; secret_variables = 2;</code>
   */
  @java.lang.Override
  public java.lang.String getSecretVariablesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetSecretVariables().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ENCRYPTED_VARIABLES_FIELD_NUMBER = 3;
  private com.google.cloud.batch.v1.Environment.KMSEnvMap encryptedVariables_;

  /**
   *
   *
   * <pre>
   * An encrypted JSON dictionary where the key/value pairs correspond to
   * environment variable names and their values.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.Environment.KMSEnvMap encrypted_variables = 3;</code>
   *
   * @return Whether the encryptedVariables field is set.
   */
  @java.lang.Override
  public boolean hasEncryptedVariables() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * An encrypted JSON dictionary where the key/value pairs correspond to
   * environment variable names and their values.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.Environment.KMSEnvMap encrypted_variables = 3;</code>
   *
   * @return The encryptedVariables.
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.Environment.KMSEnvMap getEncryptedVariables() {
    return encryptedVariables_ == null
        ? com.google.cloud.batch.v1.Environment.KMSEnvMap.getDefaultInstance()
        : encryptedVariables_;
  }

  /**
   *
   *
   * <pre>
   * An encrypted JSON dictionary where the key/value pairs correspond to
   * environment variable names and their values.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.Environment.KMSEnvMap encrypted_variables = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1.Environment.KMSEnvMapOrBuilder getEncryptedVariablesOrBuilder() {
    return encryptedVariables_ == null
        ? com.google.cloud.batch.v1.Environment.KMSEnvMap.getDefaultInstance()
        : encryptedVariables_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetVariables(), VariablesDefaultEntryHolder.defaultEntry, 1);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetSecretVariables(), SecretVariablesDefaultEntryHolder.defaultEntry, 2);
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getEncryptedVariables());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetVariables().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> variables__ =
          VariablesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, variables__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetSecretVariables().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> secretVariables__ =
          SecretVariablesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, secretVariables__);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getEncryptedVariables());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.batch.v1.Environment)) {
      return super.equals(obj);
    }
    com.google.cloud.batch.v1.Environment other = (com.google.cloud.batch.v1.Environment) obj;

    if (!internalGetVariables().equals(other.internalGetVariables())) return false;
    if (!internalGetSecretVariables().equals(other.internalGetSecretVariables())) return false;
    if (hasEncryptedVariables() != other.hasEncryptedVariables()) return false;
    if (hasEncryptedVariables()) {
      if (!getEncryptedVariables().equals(other.getEncryptedVariables())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (!internalGetVariables().getMap().isEmpty()) {
      hash = (37 * hash) + VARIABLES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetVariables().hashCode();
    }
    if (!internalGetSecretVariables().getMap().isEmpty()) {
      hash = (37 * hash) + SECRET_VARIABLES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetSecretVariables().hashCode();
    }
    if (hasEncryptedVariables()) {
      hash = (37 * hash) + ENCRYPTED_VARIABLES_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptedVariables().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.batch.v1.Environment parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1.Environment parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.Environment parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1.Environment parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.Environment parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1.Environment parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.Environment parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1.Environment parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.Environment parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1.Environment parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.batch.v1.Environment parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1.Environment parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.batch.v1.Environment prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * An Environment describes a collection of environment variables to set when
   * executing Tasks.
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1.Environment}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1.Environment)
      com.google.cloud.batch.v1.EnvironmentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1.TaskProto
          .internal_static_google_cloud_batch_v1_Environment_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 1:
          return internalGetVariables();
        case 2:
          return internalGetSecretVariables();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 1:
          return internalGetMutableVariables();
        case 2:
          return internalGetMutableSecretVariables();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1.TaskProto
          .internal_static_google_cloud_batch_v1_Environment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1.Environment.class,
              com.google.cloud.batch.v1.Environment.Builder.class);
    }

    // Construct using com.google.cloud.batch.v1.Environment.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEncryptedVariablesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      internalGetMutableVariables().clear();
      internalGetMutableSecretVariables().clear();
      encryptedVariables_ = null;
      if (encryptedVariablesBuilder_ != null) {
        encryptedVariablesBuilder_.dispose();
        encryptedVariablesBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.batch.v1.TaskProto
          .internal_static_google_cloud_batch_v1_Environment_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1.Environment getDefaultInstanceForType() {
      return com.google.cloud.batch.v1.Environment.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.batch.v1.Environment build() {
      com.google.cloud.batch.v1.Environment result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1.Environment buildPartial() {
      com.google.cloud.batch.v1.Environment result =
          new com.google.cloud.batch.v1.Environment(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.batch.v1.Environment result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.variables_ = internalGetVariables();
        result.variables_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.secretVariables_ = internalGetSecretVariables();
        result.secretVariables_.makeImmutable();
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.encryptedVariables_ =
            encryptedVariablesBuilder_ == null
                ? encryptedVariables_
                : encryptedVariablesBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.batch.v1.Environment) {
        return mergeFrom((com.google.cloud.batch.v1.Environment) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.batch.v1.Environment other) {
      if (other == com.google.cloud.batch.v1.Environment.getDefaultInstance()) return this;
      internalGetMutableVariables().mergeFrom(other.internalGetVariables());
      bitField0_ |= 0x00000001;
      internalGetMutableSecretVariables().mergeFrom(other.internalGetSecretVariables());
      bitField0_ |= 0x00000002;
      if (other.hasEncryptedVariables()) {
        mergeEncryptedVariables(other.getEncryptedVariables());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> variables__ =
                    input.readMessage(
                        VariablesDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableVariables()
                    .getMutableMap()
                    .put(variables__.getKey(), variables__.getValue());
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> secretVariables__ =
                    input.readMessage(
                        SecretVariablesDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableSecretVariables()
                    .getMutableMap()
                    .put(secretVariables__.getKey(), secretVariables__.getValue());
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getEncryptedVariablesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> variables_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetVariables() {
      if (variables_ == null) {
        return com.google.protobuf.MapField.emptyMapField(VariablesDefaultEntryHolder.defaultEntry);
      }
      return variables_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableVariables() {
      if (variables_ == null) {
        variables_ =
            com.google.protobuf.MapField.newMapField(VariablesDefaultEntryHolder.defaultEntry);
      }
      if (!variables_.isMutable()) {
        variables_ = variables_.copy();
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return variables_;
    }

    public int getVariablesCount() {
      return internalGetVariables().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * A map of environment variable names to values.
     * </pre>
     *
     * <code>map&lt;string, string&gt; variables = 1;</code>
     */
    @java.lang.Override
    public boolean containsVariables(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetVariables().getMap().containsKey(key);
    }

    /** Use {@link #getVariablesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getVariables() {
      return getVariablesMap();
    }

    /**
     *
     *
     * <pre>
     * A map of environment variable names to values.
     * </pre>
     *
     * <code>map&lt;string, string&gt; variables = 1;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getVariablesMap() {
      return internalGetVariables().getMap();
    }

    /**
     *
     *
     * <pre>
     * A map of environment variable names to values.
     * </pre>
     *
     * <code>map&lt;string, string&gt; variables = 1;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getVariablesOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetVariables().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * A map of environment variable names to values.
     * </pre>
     *
     * <code>map&lt;string, string&gt; variables = 1;</code>
     */
    @java.lang.Override
    public java.lang.String getVariablesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetVariables().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearVariables() {
      bitField0_ = (bitField0_ & ~0x00000001);
      internalGetMutableVariables().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A map of environment variable names to values.
     * </pre>
     *
     * <code>map&lt;string, string&gt; variables = 1;</code>
     */
    public Builder removeVariables(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableVariables().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableVariables() {
      bitField0_ |= 0x00000001;
      return internalGetMutableVariables().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * A map of environment variable names to values.
     * </pre>
     *
     * <code>map&lt;string, string&gt; variables = 1;</code>
     */
    public Builder putVariables(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableVariables().getMutableMap().put(key, value);
      bitField0_ |= 0x00000001;
      return this;
    }

    /**
     *
     *
     * <pre>
     * A map of environment variable names to values.
     * </pre>
     *
     * <code>map&lt;string, string&gt; variables = 1;</code>
     */
    public Builder putAllVariables(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableVariables().getMutableMap().putAll(values);
      bitField0_ |= 0x00000001;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> secretVariables_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetSecretVariables() {
      if (secretVariables_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            SecretVariablesDefaultEntryHolder.defaultEntry);
      }
      return secretVariables_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableSecretVariables() {
      if (secretVariables_ == null) {
        secretVariables_ =
            com.google.protobuf.MapField.newMapField(
                SecretVariablesDefaultEntryHolder.defaultEntry);
      }
      if (!secretVariables_.isMutable()) {
        secretVariables_ = secretVariables_.copy();
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return secretVariables_;
    }

    public int getSecretVariablesCount() {
      return internalGetSecretVariables().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * A map of environment variable names to Secret Manager secret names.
     * The VM will access the named secrets to set the value of each environment
     * variable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; secret_variables = 2;</code>
     */
    @java.lang.Override
    public boolean containsSecretVariables(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetSecretVariables().getMap().containsKey(key);
    }

    /** Use {@link #getSecretVariablesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getSecretVariables() {
      return getSecretVariablesMap();
    }

    /**
     *
     *
     * <pre>
     * A map of environment variable names to Secret Manager secret names.
     * The VM will access the named secrets to set the value of each environment
     * variable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; secret_variables = 2;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getSecretVariablesMap() {
      return internalGetSecretVariables().getMap();
    }

    /**
     *
     *
     * <pre>
     * A map of environment variable names to Secret Manager secret names.
     * The VM will access the named secrets to set the value of each environment
     * variable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; secret_variables = 2;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getSecretVariablesOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetSecretVariables().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * A map of environment variable names to Secret Manager secret names.
     * The VM will access the named secrets to set the value of each environment
     * variable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; secret_variables = 2;</code>
     */
    @java.lang.Override
    public java.lang.String getSecretVariablesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetSecretVariables().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearSecretVariables() {
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableSecretVariables().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A map of environment variable names to Secret Manager secret names.
     * The VM will access the named secrets to set the value of each environment
     * variable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; secret_variables = 2;</code>
     */
    public Builder removeSecretVariables(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableSecretVariables().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableSecretVariables() {
      bitField0_ |= 0x00000002;
      return internalGetMutableSecretVariables().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * A map of environment variable names to Secret Manager secret names.
     * The VM will access the named secrets to set the value of each environment
     * variable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; secret_variables = 2;</code>
     */
    public Builder putSecretVariables(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableSecretVariables().getMutableMap().put(key, value);
      bitField0_ |= 0x00000002;
      return this;
    }

    /**
     *
     *
     * <pre>
     * A map of environment variable names to Secret Manager secret names.
     * The VM will access the named secrets to set the value of each environment
     * variable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; secret_variables = 2;</code>
     */
    public Builder putAllSecretVariables(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableSecretVariables().getMutableMap().putAll(values);
      bitField0_ |= 0x00000002;
      return this;
    }

    private com.google.cloud.batch.v1.Environment.KMSEnvMap encryptedVariables_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1.Environment.KMSEnvMap,
            com.google.cloud.batch.v1.Environment.KMSEnvMap.Builder,
            com.google.cloud.batch.v1.Environment.KMSEnvMapOrBuilder>
        encryptedVariablesBuilder_;

    /**
     *
     *
     * <pre>
     * An encrypted JSON dictionary where the key/value pairs correspond to
     * environment variable names and their values.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.Environment.KMSEnvMap encrypted_variables = 3;</code>
     *
     * @return Whether the encryptedVariables field is set.
     */
    public boolean hasEncryptedVariables() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * An encrypted JSON dictionary where the key/value pairs correspond to
     * environment variable names and their values.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.Environment.KMSEnvMap encrypted_variables = 3;</code>
     *
     * @return The encryptedVariables.
     */
    public com.google.cloud.batch.v1.Environment.KMSEnvMap getEncryptedVariables() {
      if (encryptedVariablesBuilder_ == null) {
        return encryptedVariables_ == null
            ? com.google.cloud.batch.v1.Environment.KMSEnvMap.getDefaultInstance()
            : encryptedVariables_;
      } else {
        return encryptedVariablesBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * An encrypted JSON dictionary where the key/value pairs correspond to
     * environment variable names and their values.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.Environment.KMSEnvMap encrypted_variables = 3;</code>
     */
    public Builder setEncryptedVariables(com.google.cloud.batch.v1.Environment.KMSEnvMap value) {
      if (encryptedVariablesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptedVariables_ = value;
      } else {
        encryptedVariablesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An encrypted JSON dictionary where the key/value pairs correspond to
     * environment variable names and their values.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.Environment.KMSEnvMap encrypted_variables = 3;</code>
     */
    public Builder setEncryptedVariables(
        com.google.cloud.batch.v1.Environment.KMSEnvMap.Builder builderForValue) {
      if (encryptedVariablesBuilder_ == null) {
        encryptedVariables_ = builderForValue.build();
      } else {
        encryptedVariablesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An encrypted JSON dictionary where the key/value pairs correspond to
     * environment variable names and their values.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.Environment.KMSEnvMap encrypted_variables = 3;</code>
     */
    public Builder mergeEncryptedVariables(com.google.cloud.batch.v1.Environment.KMSEnvMap value) {
      if (encryptedVariablesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && encryptedVariables_ != null
            && encryptedVariables_
                != com.google.cloud.batch.v1.Environment.KMSEnvMap.getDefaultInstance()) {
          getEncryptedVariablesBuilder().mergeFrom(value);
        } else {
          encryptedVariables_ = value;
        }
      } else {
        encryptedVariablesBuilder_.mergeFrom(value);
      }
      if (encryptedVariables_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An encrypted JSON dictionary where the key/value pairs correspond to
     * environment variable names and their values.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.Environment.KMSEnvMap encrypted_variables = 3;</code>
     */
    public Builder clearEncryptedVariables() {
      bitField0_ = (bitField0_ & ~0x00000004);
      encryptedVariables_ = null;
      if (encryptedVariablesBuilder_ != null) {
        encryptedVariablesBuilder_.dispose();
        encryptedVariablesBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An encrypted JSON dictionary where the key/value pairs correspond to
     * environment variable names and their values.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.Environment.KMSEnvMap encrypted_variables = 3;</code>
     */
    public com.google.cloud.batch.v1.Environment.KMSEnvMap.Builder getEncryptedVariablesBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getEncryptedVariablesFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * An encrypted JSON dictionary where the key/value pairs correspond to
     * environment variable names and their values.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.Environment.KMSEnvMap encrypted_variables = 3;</code>
     */
    public com.google.cloud.batch.v1.Environment.KMSEnvMapOrBuilder
        getEncryptedVariablesOrBuilder() {
      if (encryptedVariablesBuilder_ != null) {
        return encryptedVariablesBuilder_.getMessageOrBuilder();
      } else {
        return encryptedVariables_ == null
            ? com.google.cloud.batch.v1.Environment.KMSEnvMap.getDefaultInstance()
            : encryptedVariables_;
      }
    }

    /**
     *
     *
     * <pre>
     * An encrypted JSON dictionary where the key/value pairs correspond to
     * environment variable names and their values.
     * </pre>
     *
     * <code>.google.cloud.batch.v1.Environment.KMSEnvMap encrypted_variables = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1.Environment.KMSEnvMap,
            com.google.cloud.batch.v1.Environment.KMSEnvMap.Builder,
            com.google.cloud.batch.v1.Environment.KMSEnvMapOrBuilder>
        getEncryptedVariablesFieldBuilder() {
      if (encryptedVariablesBuilder_ == null) {
        encryptedVariablesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.batch.v1.Environment.KMSEnvMap,
                com.google.cloud.batch.v1.Environment.KMSEnvMap.Builder,
                com.google.cloud.batch.v1.Environment.KMSEnvMapOrBuilder>(
                getEncryptedVariables(), getParentForChildren(), isClean());
        encryptedVariables_ = null;
      }
      return encryptedVariablesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1.Environment)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.batch.v1.Environment)
  private static final com.google.cloud.batch.v1.Environment DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.batch.v1.Environment();
  }

  public static com.google.cloud.batch.v1.Environment getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Environment> PARSER =
      new com.google.protobuf.AbstractParser<Environment>() {
        @java.lang.Override
        public Environment parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Environment> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Environment> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.batch.v1.Environment getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
