package com.cybelia.sandra.migration;

import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.migration.TopiaMigrationCallbackByClass;
import org.nuiton.util.Version;

/**
 * Migration between version 1.0 and 1.3.
 *
 * @author sletellier
 */
public class MigrationV10V13 extends TopiaMigrationCallbackByClass.MigrationCallBackForVersion {

    public MigrationV10V13(Version version, TopiaMigrationCallbackByClass callBack) {
        super(version, callBack);
    }

    @Override
    protected void prepareMigrationScript(TopiaContextImplementor tx, List<String> queries, boolean showSql, boolean showProgression) throws TopiaException {

        // Creating sequence for synchNumber
        queries.add("CREATE SEQUENCE sandra.synchNumber;");
        queries.add("UPDATE sandra.synchro SET value = (SELECT setval('sandra.synchNumber', (SELECT value FROM sandra.synchro)));");
        queries.add("DROP TABLE sandra.synchro;");

    }
}
