package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.Usine;
import com.cybelia.sandra.entities.UsineDAO;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.csv.bean.IbuUsine;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import org.nuiton.topia.TopiaException;

public class InjectorUsine implements Injector {

    protected Usine usine;

    public Usine getObject() {
        return usine;
    }

    public void clear() {
        usine = null;
    }

    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        UsineDAO usineDAO = SandraDAOHelper.getUsineDAO(manager.getTransaction());

        // Recherche
        usine = usineDAO.findByNaturalId(ibu.getUsineCode());

        // Création
        if (usine == null) {
            usine = usineDAO.createByNaturalId(ibu.getUsineCode());
        }
    }

    public void inject(ManagerInjector manager, IbuUsine ibuUsine) throws TopiaException {
        UsineDAO usineDAO = SandraDAOHelper.getUsineDAO(manager.getTransaction());

        // Recherche
        usine = usineDAO.findByNaturalId(ibuUsine.getCode());

        // Création
        if (usine == null) {
            usine = usineDAO.createByNaturalId(ibuUsine.getCode());
        }

        // Mise à jour
        usine.setAdresse(ibuUsine.getAdresse());
        usine.setCodePostal(ibuUsine.getCodePostal());
        usine.setVille(ibuUsine.getVille());
    }
}
