package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.Commande;
import com.cybelia.sandra.entities.LigneProduit;
import com.cybelia.sandra.entities.LigneProduitDAO;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;

public class InjectorLigneProduit implements Injector {

    private final Log log = LogFactory.getLog(InjectorLigneProduit.class);

    protected LigneProduit ligneProduit;

    public LigneProduit getObject() {
        return ligneProduit;
    }

    public void clear() {
        ligneProduit = null;
    }

    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {

        LigneProduitDAO ligneProduitDAO = SandraDAOHelper.getLigneProduitDAO(manager.getTransaction());

        // Recherche
        Commande commande = manager.getCommande();
        ligneProduit = ligneProduitDAO.findByNaturalId(ibu.getProduitOrdre(),
                                                       commande);

        // Création
        if (ligneProduit == null) {
            ligneProduit = ligneProduitDAO.createByNaturalId(ibu.getProduitOrdre(), commande);

        }

        ligneProduit.setCode(ibu.getProduitCode());
        ligneProduit.setLibelle(ibu.getProduitLibelle());
        ligneProduit.setPresentation(ibu.getProduitPresentation());
        ligneProduit.setConditionnement(ibu.getProduitConditionnement());
        ligneProduit.setCapaciteUnitaire(ibu.getProduitCapaciteUnitaire());
        ligneProduit.setQuantiteACharger(ibu.getProduitQuantiteAChargee());
        ligneProduit.setMedicament(ibu.getProduitOrdonnance() != 0);
        ligneProduit.setCommentaire(ibu.getProduitCommentaire());
        ligneProduit.setSilo(manager.getSilo());
        ligneProduit.setUsine(manager.getUsine());
        ligneProduit.setQuantiteCommandee(ibu.getProduitQuantiteCommandee());
        ligneProduit.setAcces(ibu.getProduitAcces());
        ligneProduit.setEquipement(ibu.getProduitEquipement());
    }
}
