package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.EleveurDAO;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.SocieteDAO;
import com.cybelia.sandra.entities.sig.PointGPS;
import com.cybelia.sandra.entities.sig.PointGPSDAO;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.csv.bean.IbuEleveurGPS;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;

public class InjectorEleveurGPS implements Injector {

    protected static final org.apache.commons.logging.Log log = LogFactory.getLog(InjectorEleveurGPS.class);

    protected Point gps;

    @Override
    public Point getObject() {
        return gps;
    }

    @Override
    public void clear() {
        gps = null;
    }

    @Override
    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        // do nothing
    }

    public void inject(ManagerInjector manager, IbuEleveurGPS ibu) throws TopiaException {
        SocieteDAO societeDAO = SandraDAOHelper.getSocieteDAO(manager.getTransaction());
        Societe societe = societeDAO.findByNaturalId(ibu.getCodeSociete());

        if (log.isDebugEnabled()) {
            log.debug("Found societe : " + societe);
        }
        if (societe != null) {
            EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO(manager.getTransaction());
            Eleveur eleveur = eleveurDAO.findByNaturalId(societe, ibu.getCodeEleveur());

            if (log.isDebugEnabled()) {
                log.debug("Found eleveur : " + eleveur);
            }

            if (eleveur != null) {

                PointGPS tomtomGPS = eleveur.getTomtomGPS();
                if (tomtomGPS != null) {
                    gps = tomtomGPS.getPoint();
                }


                if (log.isDebugEnabled()) {
                    log.debug("Found gps : " + gps);
                }

                // Create gps only for eleveur with no gps
                if (gps == null) {

                    if (log.isInfoEnabled()) {
                        log.info("Creating gps for eleveur '" +
                                ibu.getCodeSociete() +
                                "-" + ibu.getCodeEleveur() +
                                "' with coord : x:" +
                                ibu.getX() + " y:" + ibu.getY());
                    }

                    GeometryFactory geometryFactory = new GeometryFactory();
                    Coordinate coordinate = new Coordinate(safeParseDouble(ibu.getX()), safeParseDouble(ibu.getY()));
                    gps = geometryFactory.createPoint(coordinate);
                    PointGPSDAO pointGPSDAO = SandraDAOHelper.getPointGPSDAO(manager.getTransaction());
                    PointGPS pointGPS = pointGPSDAO.create("point", gps);
                    eleveur.setTomtomGPS(pointGPS);
                    eleveurDAO.update(eleveur);
                }
            }
        }
    }

    protected Double safeParseDouble(String toParse) {
        if (toParse == null) {
            return null;
        }
        toParse = toParse.replace(',', '.');
        return Double.parseDouble(toParse);
    }
}
