package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.SandraHelper;
import com.cybelia.sandra.entities.ActionSecurite;
import com.cybelia.sandra.entities.ActionSecuriteDAO;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.EleveurDAO;
import com.cybelia.sandra.entities.EleveursDoublons;
import com.cybelia.sandra.entities.EleveursDoublonsDAO;
import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.EtapeDAO;
import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.entities.InfoAccessDAO;
import com.cybelia.sandra.entities.InfoAccessEtat;
import com.cybelia.sandra.entities.Note;
import com.cybelia.sandra.entities.NoteDAO;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.SocieteDAO;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.csv.bean.IbuEleveurDuplicated;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import com.cybelia.sandra.ibu.manager.SynchNumberManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class InjectorEleveurDuplicated implements Injector {

    protected static final org.apache.commons.logging.Log log = LogFactory.getLog(InjectorEleveurDuplicated.class);

    @Override
    public Object getObject() {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        // do nothing
    }

    public void inject(ManagerInjector manager, IbuEleveurDuplicated ibu) throws TopiaException {

        SocieteDAO societeDAO = SandraDAOHelper.getSocieteDAO(manager.getTransaction());
        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO(manager.getTransaction());

        Societe societeNew = societeDAO.findByNaturalId(ibu.getCodeSocieteNew());
        Societe societeOld = societeDAO.findByNaturalId(ibu.getCodeSocieteOld());

        if (societeNew != null && societeOld != null) {

            Eleveur eleveurNew = eleveurDAO.findByNaturalId(societeNew, ibu.getCodeEleveurNew());

            Eleveur eleveurOld = eleveurDAO.findByNaturalId(societeOld, ibu.getCodeEleveurOld());

            if (eleveurNew == null || eleveurOld == null) {

                if (eleveurNew == null) {
                    log.warn("Eleveur " + ibu.getCodeSocieteNew() + "-" + ibu.getCodeEleveurNew() + " not found, skipping treatment");
                }
                if (eleveurOld == null) {
                    log.warn("Eleveur " + ibu.getCodeSocieteNew() + "-" + ibu.getCodeEleveurNew() + " not found, skipping treatment");
                }
                return;
            }
            registerBreederAsDuplicated(manager, eleveurNew.getTopiaId(), eleveurOld.getTopiaId(), false);
        } else {
            String codeSocieteError = ibu.getCodeSocieteNew();
            if (societeOld == null) {
                codeSocieteError = ibu.getCodeSocieteOld();
            }
            log.warn("Societe '" + codeSocieteError + "' not found");
        }
    }

    public static Eleveur registerBreederAsDuplicated(ManagerInjector managerInjector, String eleveurId, String eleveurDuplicatedId, boolean merge) throws TopiaException {

        if (eleveurId == null) {
            return null;
        }
        TopiaContext transaction = managerInjector.getTransaction();

        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO(transaction);
        Eleveur eleveur = eleveurDAO.findByTopiaId(eleveurId);
        Eleveur eleveurDuplicated = eleveurDAO.findByTopiaId(eleveurDuplicatedId);

        log.info("registerBreederAsDuplicated old : " + eleveurDuplicated.getNom() + " new : " + eleveur.getNom());

        EleveursDoublonsDAO eleveursDoublonsDAO = SandraDAOHelper.getEleveursDoublonsDAO(transaction);

        // Creating eleveur doublons for IBU
        EleveursDoublons eleveursDoublons = eleveursDoublonsDAO.create(EleveursDoublons.PROPERTY_CODE_SOCIETE_OLD, eleveurDuplicated.getSociete().getCode(),
                                                                       EleveursDoublons.PROPERTY_CODE_ELEVEUR_OLD, eleveurDuplicated.getCode(),
                                                                       EleveursDoublons.PROPERTY_CODE_SOCIETE_NEW, eleveur.getSociete().getCode(),
                                                                       EleveursDoublons.PROPERTY_CODE_ELEVEUR_NEW, eleveur.getCode());
        eleveursDoublonsDAO.update(eleveursDoublons);

        // Start merge infoacces
        NoteDAO noteDAO = SandraDAOHelper.getNoteDAO(transaction);
        ActionSecuriteDAO actionSecuriteDAO = SandraDAOHelper.getActionSecuriteDAO(transaction);
        if (merge) {
            
            // merge info access
            Collection<InfoAccess> infoAccessMerged = SandraHelper.mergeEleveurInfoAccess(eleveur, eleveurDuplicated);
            eleveurDuplicated.clearAccesSilos();
            eleveur.setAccesSilos(infoAccessMerged);

            // Start merge notes
            Collection<Note> notesFromBean = eleveurDuplicated.getNotes();
            if (notesFromBean != null) {
                Collection<Note> notes = new ArrayList<Note>(notesFromBean);
                eleveurDuplicated.clearNotes();
                eleveur.addAllNotes(notes);
                for (Note noteDuplicated : notes) {
                    noteDuplicated.setEleveur(eleveur);
                }
            }

            // Start merge action securites
            Collection<ActionSecurite> actionSecuritesFromBean = eleveurDuplicated.getActionSecurite();
            if (actionSecuritesFromBean != null) {
                Collection<ActionSecurite> actionSecurites = new ArrayList<ActionSecurite>(actionSecuritesFromBean);
                eleveurDuplicated.clearActionSecurite();
                eleveur.addAllActionSecurite(actionSecurites);
                for (ActionSecurite actionSecuriteDuplicated : actionSecurites) {
                    actionSecuriteDuplicated.setEleveur(eleveur);
                }
            }
        } else {
            Collection<InfoAccess> accesSilos = eleveurDuplicated.getActiveAccesSilo();
            for (InfoAccess silo : accesSilos) {

                // Delete all acces silo
                deleteAccesSilo(transaction, silo.getTopiaId());

                // Delete all notes
                Collection<Note> notes = eleveur.getNotes();
                if (notes != null) {
                    for (Note note : notes) {
                        noteDAO.delete(note);
                    }
                }

                // Delete all action security
                Collection<ActionSecurite> actionSecurites = eleveur.getActionSecurite();
                if (actionSecurites != null) {
                    for (ActionSecurite actionSecurite : actionSecurites) {
                        actionSecuriteDAO.delete(actionSecurite);
                    }
                }
            }
        }

        // Move converned step to new eleveur
        EtapeDAO etapeDAO = SandraDAOHelper.getEtapeDAO(transaction);
        List<Etape> etapesConcerned = etapeDAO.findAllByEleveur(eleveurDuplicated);
        for (Etape etape : etapesConcerned) {

            // search if etape exist for this breeder
            Etape existing = etapeDAO.findByNaturalId(etape.getOrdre(), etape.getTour(), eleveur);
            Tour tour = etape.getTour();
            if (existing == null) {
                etape.setEleveur(eleveur);
            } else {

                SandraHelper.deleteEtape(transaction, etape);
            }

            // Notify update for PDAs
            SynchNumberManager.notifyTourChange(managerInjector,
                    tour,
                    tour.getCamion().getTopiaId(),
                    "Eleveur correspondant a ete marque comme duplique");
        }

        // Delete duplicated
        eleveurDAO.delete(eleveurDuplicated);

        return eleveur;
    }

    public static void deleteAccesSilo(TopiaContext transaction, String infoAccessTopiaId) throws TopiaException {
        if (log.isInfoEnabled()) {
            log.info("deleteAccesSilo " + infoAccessTopiaId);
        }

        InfoAccessDAO dao = SandraDAOHelper.getInfoAccessDAO(transaction);

        InfoAccess infoAccess2 = dao.findByTopiaId(infoAccessTopiaId);

        infoAccess2.setEtat(InfoAccessEtat.INFOACCESS_SUPPR);

        dao.update(infoAccess2);
    }
}