package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.csv.bean.IbuAutorisation;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaSecurityDAOHelper;
import org.nuiton.topia.taas.TaasUtil;
import org.nuiton.topia.taas.entities.TaasAuthorization;
import org.nuiton.topia.taas.entities.TaasAuthorizationDAO;
import org.nuiton.topia.taas.entities.TaasPrincipal;
import org.nuiton.topia.taas.entities.TaasPrincipalDAO;

public class InjectorAutorisation implements Injector {

    private final Log log = LogFactory.getLog(InjectorAutorisation.class);
    protected TaasPrincipal data;

    public TaasPrincipal getObject() {
        return data;
    }

    public void clear() {
        data = null;
    }

    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        //nothing to do ?
    }

    public void inject(ManagerInjector manager, IbuAutorisation autorisation) throws TopiaException {

        TaasPrincipalDAO principalDAO = TopiaSecurityDAOHelper.getTaasPrincipalDAO(manager.getTransaction());
        TaasAuthorizationDAO authorizationDAO = TopiaSecurityDAOHelper.getTaasAuthorizationDAO(manager.getTransaction());

        // Recherche
        data = principalDAO.findByName(autorisation.getPrincipal());

        if (data == null) {
            // create
            data = principalDAO.create();
            data.setName(autorisation.getPrincipal());
            data.setAuthorizations(new ArrayList<TaasAuthorization>());
        }

        // Autorisation
        String expression = autorisation.getExpression();
        if (StringUtils.isNotEmpty(expression)) {

            int actions = 0;
            if (autorisation.getCreate() == 1) {
                actions += TaasUtil.CREATE;
            }
            if (autorisation.getLoad() == 1) {
                actions += TaasUtil.LOAD;
            }
            if (autorisation.getUpdate() == 1) {
                actions += TaasUtil.UPDATE;
            }
            if (autorisation.getDelete() == 1) {
                actions += TaasUtil.DELETE;
            }

            // Recherche
            TaasAuthorization value = authorizationDAO.findByProperties(
                    TaasAuthorization.EXPRESSION, expression,
                    TaasAuthorization.ACTIONS, actions);

            if (value == null) {
                // create
                value = authorizationDAO.create();
                value.setExpression(expression);
                value.setActions(actions);
            }

            if (!data.getAuthorizations().contains(value)) {
                data.addAuthorizations(value);
            }
        }
    }
}
