package com.cybelia.sandra.ibu;

/**
 * Les codes de retours sont de la forme:
 * 0 - OK
 * 1 - Erreur de parsing uniquement
 * 2 - Erreur d'injector uniquement
 * 3 - Erreur de parsing et d'injector ...
 *
 * @author thimel
 */
public class ReturnCodeHelper {

    public static final int PARSER_ERROR_CODE = 1;
    public static final int INJECTOR_ERROR_CODE = 2;
    public static final int GENERAL_ERROR_CODE = 4;
    // Attention, le prochains codes sont 8, 16....

    public static int getReturnCode(boolean hasParserError,
                                    boolean hasInjectorError) {
        int returnCode = 0;
        if (hasParserError) {
            returnCode |= PARSER_ERROR_CODE;
        }
        if (hasInjectorError) {
            returnCode |= INJECTOR_ERROR_CODE;
        }
        return returnCode;
    }

    public static boolean hasParserError(int returnCode) {
        return (returnCode & PARSER_ERROR_CODE) == PARSER_ERROR_CODE;
    }

    public static boolean hasInjectorError(int returnCode) {
        return (returnCode & INJECTOR_ERROR_CODE) == INJECTOR_ERROR_CODE;
    }

    public static boolean hasGeneralError(int returnCode) {
        return (returnCode & GENERAL_ERROR_CODE) == GENERAL_ERROR_CODE;
    }

}
