/*
 * Decompiled with CFR 0.152.
 */
package com.github.springtestdbunit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestExecutionListenerChain
implements TestExecutionListener {
    private List<TestExecutionListener> chain = this.createChain();
    private List<TestExecutionListener> reverseChain = new ArrayList<TestExecutionListener>(this.chain);

    public TestExecutionListenerChain() {
        Collections.reverse(this.reverseChain);
    }

    protected abstract Class<?>[] getChain();

    protected List<TestExecutionListener> createChain() {
        Class<?>[] chainClasses = this.getChain();
        try {
            ArrayList<TestExecutionListener> chain = new ArrayList<TestExecutionListener>(chainClasses.length);
            for (int i = 0; i < chainClasses.length; ++i) {
                chain.add((TestExecutionListener)chainClasses[i].newInstance());
            }
            return chain;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to create chain for classes " + Arrays.asList(chainClasses), ex);
        }
    }

    public void beforeTestClass(final TestContext testContext) throws Exception {
        this.forwards(new Call(){

            public void call(TestExecutionListener listener) throws Exception {
                listener.beforeTestClass(testContext);
            }
        });
    }

    public void prepareTestInstance(final TestContext testContext) throws Exception {
        this.forwards(new Call(){

            public void call(TestExecutionListener listener) throws Exception {
                listener.prepareTestInstance(testContext);
            }
        });
    }

    public void beforeTestMethod(final TestContext testContext) throws Exception {
        this.forwards(new Call(){

            public void call(TestExecutionListener listener) throws Exception {
                listener.beforeTestMethod(testContext);
            }
        });
    }

    public void afterTestMethod(final TestContext testContext) throws Exception {
        this.backwards(new Call(){

            public void call(TestExecutionListener listener) throws Exception {
                listener.afterTestMethod(testContext);
            }
        });
    }

    public void afterTestClass(final TestContext testContext) throws Exception {
        this.backwards(new Call(){

            public void call(TestExecutionListener listener) throws Exception {
                listener.afterTestClass(testContext);
            }
        });
    }

    private void forwards(Call call) throws Exception {
        this.runChain(this.chain.iterator(), call);
    }

    private void backwards(Call call) throws Exception {
        this.runChain(this.reverseChain.iterator(), call);
    }

    private void runChain(Iterator<TestExecutionListener> iterator, Call call) throws Exception {
        Throwable lastException = null;
        while (iterator.hasNext()) {
            try {
                call.call(iterator.next());
            }
            catch (Throwable ex) {
                lastException = ex;
            }
        }
        if (lastException != null) {
            if (lastException instanceof Exception) {
                throw (Exception)lastException;
            }
            throw new Exception(lastException);
        }
    }

    private static interface Call {
        public void call(TestExecutionListener var1) throws Exception;
    }
}

