/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.scopes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class StorageWithPlaceholders<T>
implements Cloneable {
    private int registeredPlaceholders = 0;
    private int usedPlaceholders = 0;
    private Map<String, Integer> placeholdersWhenModified = new HashMap<String, Integer>();

    public void createPlaceholder() {
        ++this.registeredPlaceholders;
    }

    public void closePlaceholder() {
        ++this.usedPlaceholders;
    }

    private int getPosition(String name) {
        Integer position = this.placeholdersWhenModified.get(name);
        return position == null ? -1 : position;
    }

    protected int getUsedPlaceholders() {
        return this.usedPlaceholders;
    }

    public void store(String name, T value) {
        this.placeholdersWhenModified.put(name, this.registeredPlaceholders);
        this.doStore(name, value);
    }

    public void store(String name, List<T> value) {
        this.placeholdersWhenModified.put(name, this.registeredPlaceholders);
        this.doStore(name, value);
    }

    protected abstract void doStore(String var1, T var2);

    protected abstract void doStore(String var1, List<T> var2);

    protected boolean storedBelowUnusedPlaceholder(String name) {
        return this.getPosition(name) <= this.getUsedPlaceholders();
    }

    public String placeholdersReport() {
        return "registered: " + this.registeredPlaceholders + " used: " + this.usedPlaceholders;
    }

    public StorageWithPlaceholders<T> clone() {
        try {
            StorageWithPlaceholders clone = (StorageWithPlaceholders)super.clone();
            clone.placeholdersWhenModified = new HashMap<String, Integer>(this.placeholdersWhenModified);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible state.");
        }
    }
}

