/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.utils;

import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.parser.LessLexer;
import com.github.sommeri.less4j.utils.PrintUtils;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Token;

public class DebugPrint {
    private static boolean printIndexes = true;
    private static boolean printComments = false;

    public static void printTokenStream(String expression) {
        LessLexer createLexer = DebugPrint.createLexer(expression);
        Token token = createLexer.nextToken();
        int count = 0;
        while (token.getType() != -1) {
            System.out.println(DebugPrint.toString(count++, token));
            token = createLexer.nextToken();
        }
    }

    private static LessLexer createLexer(String expression) {
        ANTLRStringStream input = new ANTLRStringStream(expression);
        LessLexer lexer = new LessLexer((CharStream)input);
        return lexer;
    }

    public static String toString(int count, Token token) {
        return "(" + count + ") " + PrintUtils.toName(token.getType()) + " " + DebugPrint.toOneLine(token.getText());
    }

    private static String toOneLine(String text) {
        return text.replace("\r\n", "").replace("\n", "");
    }

    public static void print(HiddenTokenAwareTree ast) {
        DebugPrint.print(ast, 0);
    }

    private static void print(HiddenTokenAwareTree tree, int level) {
        DebugPrint.indent(level);
        DebugPrint.printSingleNode(tree);
        if (tree.getChildren() != null) {
            for (HiddenTokenAwareTree ie : tree.getChildren()) {
                DebugPrint.print(ie, level + 1);
            }
        }
    }

    public static void indent(int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("--");
        }
    }

    public static void printSingleNode(HiddenTokenAwareTree tree) {
        String optionalsuffix;
        String invalid = "";
        if (tree.getType() == 0) {
            invalid = " (" + PrintUtils.toName(tree.getType()) + ")";
        }
        String base = "  " + DebugPrint.toOneLine(tree.getText()) + invalid;
        if (printIndexes) {
            optionalsuffix = " " + tree.getTokenStartIndex() + "-" + tree.getTokenStopIndex() + " " + (tree.getToken() == null ? "" : Integer.valueOf(tree.getToken().getTokenIndex()));
            base = base + optionalsuffix;
        }
        if (printComments) {
            optionalsuffix = " PC:" + DebugPrint.printComments(tree.getPreceding()) + " FC:" + DebugPrint.printComments(tree.getFollowing());
            base = base + optionalsuffix;
        }
        System.out.println(base);
    }

    public static String printComments(List<Token> list) {
        String result = "" + list.size();
        for (Token token : list) {
            if (token.getType() != 136) continue;
            result = result + token.getText();
        }
        return result;
    }
}

