/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.parser;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ArgumentDeclaration;
import com.github.sommeri.less4j.core.ast.CharsetDeclaration;
import com.github.sommeri.less4j.core.ast.ComparisonExpression;
import com.github.sommeri.less4j.core.ast.ComparisonExpressionOperator;
import com.github.sommeri.less4j.core.ast.ComposedExpression;
import com.github.sommeri.less4j.core.ast.CssClass;
import com.github.sommeri.less4j.core.ast.Declaration;
import com.github.sommeri.less4j.core.ast.ElementSubsequent;
import com.github.sommeri.less4j.core.ast.EscapedSelector;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.ExpressionOperator;
import com.github.sommeri.less4j.core.ast.FixedNamePart;
import com.github.sommeri.less4j.core.ast.FontFace;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.Guard;
import com.github.sommeri.less4j.core.ast.GuardCondition;
import com.github.sommeri.less4j.core.ast.IdSelector;
import com.github.sommeri.less4j.core.ast.IdentifierExpression;
import com.github.sommeri.less4j.core.ast.IndirectVariable;
import com.github.sommeri.less4j.core.ast.InterpolableName;
import com.github.sommeri.less4j.core.ast.Keyframes;
import com.github.sommeri.less4j.core.ast.KeyframesBody;
import com.github.sommeri.less4j.core.ast.KeyframesName;
import com.github.sommeri.less4j.core.ast.Media;
import com.github.sommeri.less4j.core.ast.MediaExpression;
import com.github.sommeri.less4j.core.ast.MediaExpressionFeature;
import com.github.sommeri.less4j.core.ast.MediaQuery;
import com.github.sommeri.less4j.core.ast.Medium;
import com.github.sommeri.less4j.core.ast.MediumModifier;
import com.github.sommeri.less4j.core.ast.MediumType;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.ast.Name;
import com.github.sommeri.less4j.core.ast.NestedSelectorAppender;
import com.github.sommeri.less4j.core.ast.Nth;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.ast.Page;
import com.github.sommeri.less4j.core.ast.PageMarginBox;
import com.github.sommeri.less4j.core.ast.Pseudo;
import com.github.sommeri.less4j.core.ast.PseudoClass;
import com.github.sommeri.less4j.core.ast.PseudoElement;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.ast.ReusableStructureName;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.RuleSetsBody;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.ast.SelectorAttribute;
import com.github.sommeri.less4j.core.ast.SelectorOperator;
import com.github.sommeri.less4j.core.ast.SignedExpression;
import com.github.sommeri.less4j.core.ast.SimpleSelector;
import com.github.sommeri.less4j.core.ast.StyleSheet;
import com.github.sommeri.less4j.core.ast.Variable;
import com.github.sommeri.less4j.core.ast.VariableDeclaration;
import com.github.sommeri.less4j.core.ast.VariableNamePart;
import com.github.sommeri.less4j.core.ast.Viewport;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.parser.SelectorBuilder;
import com.github.sommeri.less4j.core.parser.TermBuilder;
import com.github.sommeri.less4j.core.parser.TokenTypeSwitch;
import com.github.sommeri.less4j.core.problems.BugHappened;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class ASTBuilderSwitch
extends TokenTypeSwitch<ASTCssNode> {
    private static final String GRAMMAR_MISMATCH = "ASTBuilderSwitch grammar mismatch";
    private final ProblemsHandler problemsHandler;
    private final TermBuilder termBuilder = new TermBuilder(this);
    private static Set<String> COLONLESS_PSEUDOELEMENTS = new HashSet<String>();

    public ASTBuilderSwitch(ProblemsHandler problemsHandler) {
        this.problemsHandler = problemsHandler;
    }

    @Override
    public StyleSheet handleStyleSheet(HiddenTokenAwareTree token) {
        StyleSheet result = new StyleSheet(token);
        if (token.getChildren() == null || token.getChildren().isEmpty()) {
            return result;
        }
        for (HiddenTokenAwareTree kid : token.getChildren()) {
            result.addMember((ASTCssNode)this.switchOn(kid));
        }
        return result;
    }

    @Override
    public Expression handleTerm(HiddenTokenAwareTree token) {
        return this.termBuilder.buildFromTerm(token);
    }

    @Override
    public Expression handleExpression(HiddenTokenAwareTree token) {
        LinkedList<HiddenTokenAwareTree> children = new LinkedList<HiddenTokenAwareTree>(token.getChildren());
        if (children.size() == 0) {
            throw new BugHappened(GRAMMAR_MISMATCH, token);
        }
        if (children.size() == 1) {
            Expression head = (Expression)this.switchOn(children.get(0));
            head.setUnderlyingStructure(token);
            return head;
        }
        return this.createExpression(token, children);
    }

    private Expression createExpression(HiddenTokenAwareTree parent, LinkedList<HiddenTokenAwareTree> members) {
        Expression head = (Expression)this.switchOn(members.removeFirst());
        while (!members.isEmpty()) {
            ExpressionOperator operator = this.readExpressionOperator(members);
            if (members.isEmpty()) {
                return new ComposedExpression(parent, head, operator, null);
            }
            Expression next = (Expression)this.switchOn(members.removeFirst());
            head = new ComposedExpression(parent, head, operator, next);
        }
        return head;
    }

    public ExpressionOperator readExpressionOperator(LinkedList<HiddenTokenAwareTree> members) {
        HiddenTokenAwareTree token = members.removeFirst();
        ExpressionOperator operator = new ExpressionOperator(token, this.toExpressionOperator(token));
        return operator;
    }

    private ExpressionOperator.Operator toExpressionOperator(HiddenTokenAwareTree token) {
        switch (token.getType()) {
            case 99: {
                return ExpressionOperator.Operator.SOLIDUS;
            }
            case 52: {
                return ExpressionOperator.Operator.COMMA;
            }
            case 69: {
                return ExpressionOperator.Operator.STAR;
            }
            case 68: {
                return ExpressionOperator.Operator.MINUS;
            }
            case 66: {
                return ExpressionOperator.Operator.PLUS;
            }
            case 18: {
                return ExpressionOperator.Operator.EMPTY_OPERATOR;
            }
        }
        throw new BugHappened(GRAMMAR_MISMATCH, token);
    }

    @Override
    public Variable handleVariable(HiddenTokenAwareTree token) {
        return this.termBuilder.buildFromVariable(token);
    }

    @Override
    public IndirectVariable handleIndirectVariable(HiddenTokenAwareTree token) {
        return this.termBuilder.buildFromIndirectVariable(token);
    }

    @Override
    public Declaration handleDeclaration(HiddenTokenAwareTree token) {
        Iterator<HiddenTokenAwareTree> iterator = token.getChildren().iterator();
        HiddenTokenAwareTree nameToken = iterator.next();
        String name = nameToken.getText();
        if (nameToken.getType() == 69) {
            nameToken = iterator.next();
            name = name + nameToken.getText();
        }
        if (!iterator.hasNext()) {
            return new Declaration(token, name);
        }
        HiddenTokenAwareTree expressionToken = iterator.next();
        if (expressionToken.getType() == 95) {
            return new Declaration(token, name, null, true);
        }
        Expression expression = (Expression)this.switchOn(expressionToken);
        if (!iterator.hasNext()) {
            return new Declaration(token, name, expression);
        }
        HiddenTokenAwareTree importantToken = iterator.next();
        if (importantToken.getType() == 95) {
            return new Declaration(token, name, expression, true);
        }
        throw new BugHappened(GRAMMAR_MISMATCH, token);
    }

    @Override
    public FontFace handleFontFace(HiddenTokenAwareTree token) {
        FontFace result = new FontFace(token);
        List<HiddenTokenAwareTree> children = token.getChildren();
        ArrayList<Declaration> declarations = new ArrayList<Declaration>();
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getType() != 8) continue;
            declarations.add(this.handleDeclaration(kid));
        }
        result.addMembers(declarations);
        return result;
    }

    @Override
    public CharsetDeclaration handleCharsetDeclaration(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        if (children.isEmpty()) {
            throw new BugHappened(GRAMMAR_MISMATCH, token);
        }
        return new CharsetDeclaration(token, children.get(0).getText());
    }

    @Override
    public RuleSet handleRuleSet(HiddenTokenAwareTree token) {
        RuleSet ruleSet = new RuleSet(token);
        ArrayList<Selector> selectors = new ArrayList<Selector>();
        List<HiddenTokenAwareTree> children = token.getChildren();
        ASTCssNode previousKid = null;
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getType() == 12) {
                Selector selector = this.handleSelector(kid);
                if (selector != null) {
                    selectors.add(selector);
                }
                previousKid = selector;
                continue;
            }
            if (kid.getType() == 33) {
                RuleSetsBody body = this.handleRuleSetsBody(kid);
                ruleSet.setBody(body);
                previousKid = body;
                continue;
            }
            if (kid.getType() != 52 || previousKid == null) continue;
            previousKid.getUnderlyingStructure().addFollowing(kid.getPreceding());
        }
        ruleSet.addSelectors(selectors);
        return ruleSet;
    }

    @Override
    public ReusableStructure handleReusableStructureDeclaration(HiddenTokenAwareTree token) {
        ReusableStructure result = new ReusableStructure(token);
        List<HiddenTokenAwareTree> children = token.getChildren();
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getType() == 44) {
                result.addName(this.handleReusableStructureName(kid));
                continue;
            }
            if (kid.getType() == 33) {
                result.setBody(this.handleRuleSetsBody(kid));
                continue;
            }
            if (kid.getType() == 39) {
                result.addGuard(this.handleGuard(kid));
                continue;
            }
            if (kid.getType() == 61) {
                result.addParameter(new ArgumentDeclaration(kid, new Variable(kid, "@"), null, true));
                continue;
            }
            result.addParameter((ASTCssNode)this.switchOn(kid));
        }
        return result;
    }

    @Override
    public ElementSubsequent handleElementSubsequent(HiddenTokenAwareTree token) {
        return (ElementSubsequent)this.switchOn(token.getChild(0));
    }

    @Override
    public ReusableStructureName handleReusableStructureName(HiddenTokenAwareTree token) {
        ReusableStructureName result = new ReusableStructureName(token);
        List<HiddenTokenAwareTree> children = token.getChildren();
        for (HiddenTokenAwareTree kid : children) {
            result.addNamePart(this.handleElementSubsequent(kid));
        }
        return result;
    }

    @Override
    public MixinReference handleMixinReference(HiddenTokenAwareTree token) {
        MixinReference result = new MixinReference(token);
        List<HiddenTokenAwareTree> children = token.getChildren();
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getType() == 44) {
                result.setFinalName(this.handleReusableStructureName(kid));
                continue;
            }
            if (kid.getType() == 95) {
                result.setImportant(true);
                continue;
            }
            ASTCssNode parameter = (ASTCssNode)this.switchOn(kid);
            if (parameter.getType() == ASTCssNodeType.VARIABLE_DECLARATION) {
                result.addNamedParameter((VariableDeclaration)parameter);
                continue;
            }
            result.addPositionalParameter((Expression)parameter);
        }
        return result;
    }

    @Override
    public MixinReference handleNamespaceReference(HiddenTokenAwareTree token) {
        ASTCssNode reference = null;
        ArrayList<ReusableStructureName> nameChain = new ArrayList<ReusableStructureName>();
        List<HiddenTokenAwareTree> children = token.getChildren();
        for (HiddenTokenAwareTree kid : children) {
            ASTCssNode buildKid = (ASTCssNode)this.switchOn(kid);
            if (buildKid.getType() == ASTCssNodeType.MIXIN_REFERENCE) {
                reference = (MixinReference)this.switchOn(kid);
                continue;
            }
            if (buildKid.getType() == ASTCssNodeType.REUSABLE_STRUCTURE_NAME) {
                nameChain.add(this.handleReusableStructureName(kid));
                continue;
            }
            throw new BugHappened(GRAMMAR_MISMATCH, token);
        }
        reference.setUnderlyingStructure(token);
        ((MixinReference)reference).addNames(nameChain);
        return reference;
    }

    @Override
    public Expression handleMixinPattern(HiddenTokenAwareTree token) {
        return this.termBuilder.buildFromTerm(token.getChild(0));
    }

    @Override
    public Guard handleGuard(HiddenTokenAwareTree token) {
        Guard result = new Guard(token);
        Iterator<HiddenTokenAwareTree> iterator = token.getChildren().iterator();
        result.addCondition(this.handleGuardCondition(iterator.next()));
        while (iterator.hasNext()) {
            this.validateGuardAnd(iterator.next());
            result.addCondition(this.handleGuardCondition(iterator.next()));
        }
        return result;
    }

    @Override
    public GuardCondition handleGuardCondition(HiddenTokenAwareTree token) {
        Iterator<HiddenTokenAwareTree> iterator = token.getChildren().iterator();
        HiddenTokenAwareTree kid = iterator.next();
        boolean isNegated = false;
        if (kid.getType() != 7) {
            this.validateGuardNegation(kid);
            isNegated = true;
            kid = iterator.next();
        }
        Expression condition = this.handleExpression(kid);
        if (iterator.hasNext()) {
            HiddenTokenAwareTree operatorToken = iterator.next();
            Expression followingExpression = this.handleExpression(iterator.next());
            condition = new ComparisonExpression(token, condition, this.toComparisonOperator(operatorToken), followingExpression);
        }
        return new GuardCondition(token, isNegated, condition);
    }

    private ComparisonExpressionOperator toComparisonOperator(HiddenTokenAwareTree token) {
        switch (token.getType()) {
            case 65: {
                return new ComparisonExpressionOperator(token, ComparisonExpressionOperator.Operator.GREATER);
            }
            case 96: {
                return new ComparisonExpressionOperator(token, ComparisonExpressionOperator.Operator.GREATER_OR_EQUAL);
            }
            case 88: {
                return new ComparisonExpressionOperator(token, ComparisonExpressionOperator.Operator.OPEQ);
            }
            case 97: {
                return new ComparisonExpressionOperator(token, ComparisonExpressionOperator.Operator.LOWER_OR_EQUAL);
            }
            case 98: {
                return new ComparisonExpressionOperator(token, ComparisonExpressionOperator.Operator.LOWER);
            }
        }
        throw new BugHappened(GRAMMAR_MISMATCH, token);
    }

    public void validateGuardNegation(HiddenTokenAwareTree token) {
        String operator = token.getText().trim();
        if (!"not".equals(operator)) {
            throw new BugHappened(GRAMMAR_MISMATCH, token);
        }
    }

    public void validateGuardAnd(HiddenTokenAwareTree token) {
        String operator = token.getText().trim();
        if (!"and".equals(operator)) {
            throw new BugHappened(GRAMMAR_MISMATCH, token);
        }
    }

    @Override
    public RuleSetsBody handleRuleSetsBody(HiddenTokenAwareTree token) {
        List<ASTCssNode> members = this.handleBodyMembers(token);
        return new RuleSetsBody(token, members);
    }

    public KeyframesBody handleKeyframesBody(HiddenTokenAwareTree token) {
        List<ASTCssNode> members = this.handleBodyMembers(token);
        return new KeyframesBody(token, members);
    }

    private List<ASTCssNode> handleBodyMembers(HiddenTokenAwareTree token) {
        if (token.getChildren() == null) {
            return new ArrayList<ASTCssNode>();
        }
        ArrayList<ASTCssNode> members = new ArrayList<ASTCssNode>();
        Iterator<HiddenTokenAwareTree> iterator = token.getChildren().iterator();
        HiddenTokenAwareTree lbrace = iterator.next();
        token.addPreceding(lbrace.getPreceding());
        if (iterator.hasNext()) {
            token.getChildren().get(1).addBeforePreceding(lbrace.getFollowing());
        } else {
            token.addOrphans(lbrace.getFollowing());
        }
        while (iterator.hasNext()) {
            members.add((ASTCssNode)this.switchOn(iterator.next()));
        }
        return members;
    }

    @Override
    public Selector handleSelector(HiddenTokenAwareTree token) {
        SelectorBuilder builder = new SelectorBuilder(token, this);
        return builder.buildSelector();
    }

    @Override
    public CssClass handleCssClass(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        return new CssClass(token, this.toInterpolableName(token, children));
    }

    @Override
    public SelectorAttribute handleSelectorAttribute(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        if (children.size() == 0) {
            throw new BugHappened(GRAMMAR_MISMATCH, token);
        }
        if (children.size() == 1) {
            return new SelectorAttribute(token, children.get(0).getText());
        }
        if (children.size() < 3) {
            throw new BugHappened(GRAMMAR_MISMATCH, token);
        }
        return new SelectorAttribute(token, children.get(0).getText(), this.handleSelectorOperator(children.get(1)), children.get(2).getText());
    }

    @Override
    public SelectorOperator handleSelectorOperator(HiddenTokenAwareTree token) {
        return new SelectorOperator(token, this.toSelectorOperator(token));
    }

    private SelectorOperator.Operator toSelectorOperator(HiddenTokenAwareTree token) {
        switch (token.getType()) {
            case 88: {
                return SelectorOperator.Operator.EQUALS;
            }
            case 89: {
                return SelectorOperator.Operator.INCLUDES;
            }
            case 90: {
                return SelectorOperator.Operator.SPECIAL_PREFIX;
            }
            case 91: {
                return SelectorOperator.Operator.PREFIXMATCH;
            }
            case 92: {
                return SelectorOperator.Operator.SUFFIXMATCH;
            }
            case 93: {
                return SelectorOperator.Operator.SUBSTRINGMATCH;
            }
        }
        throw new BugHappened(GRAMMAR_MISMATCH, token);
    }

    @Override
    public Pseudo handlePseudo(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        if (children.size() == 0 || children.size() == 1) {
            throw new BugHappened(GRAMMAR_MISMATCH, token);
        }
        HiddenTokenAwareTree t = children.get(1);
        if (t.getType() == 59) {
            return this.createPseudoElement(token, 2, false);
        }
        if (COLONLESS_PSEUDOELEMENTS.contains(t.getText().toLowerCase())) {
            return this.createPseudoElement(token, 1, true);
        }
        if (children.size() == 2) {
            return new PseudoClass(token, children.get(1).getText());
        }
        if (children.size() == 3) {
            HiddenTokenAwareTree parameter = children.get(2);
            if (parameter.getType() == 77) {
                return new PseudoClass(token, children.get(1).getText(), new NumberExpression(parameter, parameter.getText()));
            }
            if (parameter.getType() == 57) {
                return new PseudoClass(token, children.get(1).getText(), new IdentifierExpression(parameter, parameter.getText()));
            }
            return new PseudoClass(token, children.get(1).getText(), (ASTCssNode)this.switchOn(parameter));
        }
        throw new BugHappened(GRAMMAR_MISMATCH, token);
    }

    @Override
    public Nth handleNth(HiddenTokenAwareTree token) {
        Expression first = null;
        Expression second = null;
        if (this.hasChildren(token.getChild(0))) {
            first = this.termBuilder.buildFromTerm(token.getChild(0));
            String sign = "";
            if (first.getType() == ASTCssNodeType.SIGNED_EXPRESSION) {
                SignedExpression negated = (SignedExpression)first;
                first = negated.getExpression();
                sign = negated.getSign().toSymbol();
            }
            if (first.getType() == ASTCssNodeType.IDENTIFIER_EXPRESSION) {
                IdentifierExpression ident = (IdentifierExpression)first;
                String lowerCaseValue = ident.getValue().toLowerCase();
                lowerCaseValue = sign + lowerCaseValue;
                if ("even".equals(lowerCaseValue)) {
                    return new Nth(token, null, null, Nth.Form.EVEN);
                }
                if ("odd".equals(lowerCaseValue)) {
                    return new Nth(token, null, null, Nth.Form.ODD);
                }
                if ("n".equals(lowerCaseValue) || "-n".equals(lowerCaseValue) || "+n".equals(lowerCaseValue)) {
                    first = new NumberExpression(token.getChild(0), lowerCaseValue, NumberExpression.Dimension.REPEATER);
                } else {
                    throw new IllegalStateException("Unexpected identifier value for nth: " + ident.getValue());
                }
            }
        }
        if (token.getChild(1) != null && this.hasChildren(token.getChild(1))) {
            second = this.termBuilder.buildFromTerm(token.getChild(1));
        }
        return new Nth(token, (NumberExpression)first, (NumberExpression)second);
    }

    private boolean hasChildren(HiddenTokenAwareTree token) {
        return token.getChildren() != null && !token.getChildren().isEmpty();
    }

    private PseudoElement createPseudoElement(HiddenTokenAwareTree token, int startIndex, boolean level12Form) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        String name = children.get(startIndex).getText();
        return new PseudoElement(token, name, level12Form);
    }

    @Override
    public IdSelector handleIdSelector(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        return new IdSelector(token, this.toInterpolableName(token, children));
    }

    private InterpolableName toInterpolableName(HiddenTokenAwareTree token, List<HiddenTokenAwareTree> children) {
        InterpolableName result = new InterpolableName(token);
        for (HiddenTokenAwareTree kid : children) {
            String text = kid.getText();
            if (text == null || text.length() < 1) {
                throw new BugHappened(GRAMMAR_MISMATCH, kid);
            }
            if (kid.getType() == 75) {
                result.add(new VariableNamePart(kid, new Variable(kid, "@" + text.substring(2, text.length() - 1))));
                continue;
            }
            if (kid.getType() == 74) continue;
            result.add(new FixedNamePart(kid, this.toFixedName(kid.getType(), text)));
        }
        return result;
    }

    private String toFixedName(int typeCode, String text) {
        if (typeCode == 73) {
            return text.substring(1);
        }
        return text;
    }

    @Override
    public Media handleMedia(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> originalChildren = token.getChildren();
        ArrayList<HiddenTokenAwareTree> children = new ArrayList<HiddenTokenAwareTree>(originalChildren);
        HiddenTokenAwareTree lbrace = (HiddenTokenAwareTree)((Object)children.remove(1));
        ((HiddenTokenAwareTree)((Object)children.get(0))).addFollowing(lbrace.getPreceding());
        ((HiddenTokenAwareTree)((Object)children.get(1))).addBeforePreceding(lbrace.getFollowing());
        HiddenTokenAwareTree rbrace = (HiddenTokenAwareTree)((Object)children.remove(children.size() - 1));
        ((HiddenTokenAwareTree)((Object)children.get(children.size() - 1))).addFollowing(rbrace.getPreceding());
        rbrace.getParent().addBeforeFollowing(rbrace.getFollowing());
        Media result = new Media(token);
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getType() == 29) {
                kid.pushHiddenToKids();
                this.handleMediaDeclaration(result, kid);
                continue;
            }
            result.addChild((ASTCssNode)this.switchOn(kid));
        }
        return result;
    }

    private void handleMediaDeclaration(Media result, HiddenTokenAwareTree declaration) {
        List<HiddenTokenAwareTree> children = declaration.getChildren();
        ASTCssNode previousKid = null;
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getType() == 52) {
                previousKid.getUnderlyingStructure().addFollowing(kid.getPreceding());
                continue;
            }
            previousKid = (ASTCssNode)this.switchOn(kid);
            result.addChild(previousKid);
        }
    }

    @Override
    public MediaQuery handleMediaQuery(HiddenTokenAwareTree token) {
        MediaQuery result = new MediaQuery(token);
        List<HiddenTokenAwareTree> originalChildren = token.getChildren();
        LinkedList<HiddenTokenAwareTree> children = new LinkedList<HiddenTokenAwareTree>();
        for (HiddenTokenAwareTree kid : originalChildren) {
            if (kid.getType() == 57) {
                HiddenTokenAwareTree lastKid = (HiddenTokenAwareTree)((Object)children.peekLast());
                if (lastKid == null) continue;
                lastKid.addFollowing(kid.getPreceding());
                continue;
            }
            children.add(kid);
        }
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getType() == 57) continue;
            result.addMember((ASTCssNode)this.switchOn(kid));
        }
        return result;
    }

    @Override
    public Medium handleMedium(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        if (children.size() == 1) {
            HiddenTokenAwareTree type = children.get(0);
            return new Medium(token, new MediumModifier(type), new MediumType(type, type.getText()));
        }
        HiddenTokenAwareTree type = children.get(1);
        return new Medium(token, this.toMediumModifier(children.get(0)), new MediumType(type, type.getText()));
    }

    @Override
    public MediaExpression handleMediaExpression(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        HiddenTokenAwareTree featureNode = children.get(0);
        if (children.size() == 1) {
            return new MediaExpression(token, new MediaExpressionFeature(featureNode, featureNode.getText()), null);
        }
        if (children.size() == 2) {
            throw new BugHappened(GRAMMAR_MISMATCH, token);
        }
        HiddenTokenAwareTree colonNode = children.get(1);
        featureNode.addFollowing(colonNode.getPreceding());
        HiddenTokenAwareTree expressionNode = children.get(2);
        Expression expression = (Expression)this.switchOn(expressionNode);
        return new MediaExpression(token, new MediaExpressionFeature(featureNode, featureNode.getText()), expression);
    }

    private MediumModifier toMediumModifier(HiddenTokenAwareTree token) {
        String modifier = token.getText().toLowerCase();
        if ("not".equals(modifier)) {
            return new MediumModifier(token, MediumModifier.Modifier.NOT);
        }
        if ("only".equals(modifier)) {
            return new MediumModifier(token, MediumModifier.Modifier.ONLY);
        }
        throw new IllegalStateException("Unexpected medium modifier: " + modifier);
    }

    @Override
    public VariableDeclaration handleVariableDeclaration(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        HiddenTokenAwareTree name = children.get(0);
        HiddenTokenAwareTree colon = children.get(1);
        HiddenTokenAwareTree expression = children.get(2);
        if (children.size() > 3) {
            HiddenTokenAwareTree semi = children.get(3);
            colon.giveHidden(name, expression);
            semi.giveHidden(expression, null);
            token.addBeforeFollowing(semi.getFollowing());
        }
        return new VariableDeclaration(token, new Variable(name, name.getText()), (Expression)this.switchOn(expression));
    }

    @Override
    public ArgumentDeclaration handleArgumentDeclaration(HiddenTokenAwareTree token) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        HiddenTokenAwareTree name = children.get(0);
        if (children.size() == 1) {
            return new ArgumentDeclaration(token, new Variable(name, name.getText()), null);
        }
        HiddenTokenAwareTree separator = children.get(1);
        if (separator.getType() == 61) {
            return new ArgumentDeclaration(token, new Variable(name, name.getText()), null, true);
        }
        HiddenTokenAwareTree expression = children.get(2);
        separator.giveHidden(name, expression);
        return new ArgumentDeclaration(token, new Variable(name, name.getText()), (Expression)this.switchOn(expression));
    }

    @Override
    public ASTCssNode handleNestedAppender(HiddenTokenAwareTree token) {
        boolean directlyBefore = true;
        boolean directlyAfter = true;
        if (token.getChildren().size() == 2) {
            directlyBefore = this.isMeaningfullWhitespace(token);
            directlyAfter = !directlyBefore;
        } else if (token.getChildren().size() == 3) {
            directlyBefore = false;
            directlyAfter = false;
        }
        return new NestedSelectorAppender(token, directlyBefore, directlyAfter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ASTCssNode handleSimpleSelector(HiddenTokenAwareTree token) {
        SimpleSelector result = null;
        token.pushHiddenToKids();
        Iterator<HiddenTokenAwareTree> iterator = token.getChildren().iterator();
        HiddenTokenAwareTree kid = iterator.next();
        if (kid.getType() == 19) {
            List<HiddenTokenAwareTree> elementNameParts = kid.getChildren();
            InterpolableName interpolableName = this.toInterpolableName(kid, elementNameParts);
            result = new SimpleSelector(kid, interpolableName, this.isStarElementName(elementNameParts));
            if (!iterator.hasNext()) return result;
            kid = iterator.next();
        } else {
            result = new SimpleSelector(kid, null, true);
            result.setEmptyForm(true);
        }
        do {
            result.addSubsequent((ElementSubsequent)this.switchOn(kid));
        } while ((kid = iterator.hasNext() ? iterator.next() : null) != null);
        return result;
    }

    private boolean isStarElementName(List<HiddenTokenAwareTree> elementNameParts) {
        if (elementNameParts.size() != 1) {
            return false;
        }
        return elementNameParts.get(0).getType() == 69;
    }

    @Override
    public EscapedSelector handleEscapedSelector(HiddenTokenAwareTree token) {
        token.pushHiddenToKids();
        HiddenTokenAwareTree valueToken = token.getChild(0);
        String quotedText = valueToken.getText();
        return new EscapedSelector(valueToken, quotedText.substring(2, quotedText.length() - 1), "" + quotedText.charAt(1));
    }

    private boolean isMeaningfullWhitespace(HiddenTokenAwareTree kid) {
        int type = kid.getChild(0).getType();
        return type == 70 || type == 40;
    }

    @Override
    public Keyframes handleKeyframes(HiddenTokenAwareTree token) {
        Iterator<HiddenTokenAwareTree> children = token.getChildren().iterator();
        Keyframes result = new Keyframes(token, children.next().getText());
        result.addNames(this.handleKeyframesDeclaration(children.next()));
        result.setBody(this.handleKeyframesBody(children.next()));
        return result;
    }

    @Override
    public Viewport handleViewport(HiddenTokenAwareTree token) {
        Viewport result = new Viewport(token);
        HiddenTokenAwareTree body = token.getChild(1);
        result.setBody(new GeneralBody(body, this.handleBodyMembers(body)));
        return result;
    }

    private List<KeyframesName> handleKeyframesDeclaration(HiddenTokenAwareTree declaration) {
        ArrayList<KeyframesName> result = new ArrayList<KeyframesName>();
        for (HiddenTokenAwareTree token : declaration.getChildren()) {
            if (token.getType() == 52) {
                token.pushHiddenToSiblings();
                continue;
            }
            if (token.getType() == 57) {
                result.add(new KeyframesName(token, token.getText()));
                continue;
            }
            throw new BugHappened(GRAMMAR_MISMATCH, token);
        }
        return result;
    }

    @Override
    public Page handlePage(HiddenTokenAwareTree token) {
        Page result = new Page(token);
        List<HiddenTokenAwareTree> children = token.getChildren();
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getType() == 57) {
                result.setName(new Name(kid, kid.getText()));
                continue;
            }
            if (kid.getType() == 45) {
                int pseudoPageIndex = 1;
                if (kid.getChild(0).getType() == 70) {
                    pseudoPageIndex = 2;
                    result.setDockedPseudopage(false);
                }
                result.setPseudopage(new Name(kid, ":" + kid.getChild(pseudoPageIndex).getText()));
                continue;
            }
            if (kid.getType() == 33) {
                result.setBody(new GeneralBody(kid, this.handleBodyMembers(kid)));
                continue;
            }
            throw new BugHappened(GRAMMAR_MISMATCH, kid);
        }
        return result;
    }

    @Override
    public PageMarginBox handlePageMarginBox(HiddenTokenAwareTree token) {
        PageMarginBox result = new PageMarginBox(token);
        List<HiddenTokenAwareTree> children = token.getChildren();
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getType() == 56) {
                result.setName(new Name(kid, kid.getText()));
                continue;
            }
            if (kid.getType() == 33) {
                result.setBody(new GeneralBody(kid, this.handleBodyMembers(kid)));
                continue;
            }
            throw new BugHappened(GRAMMAR_MISMATCH, kid);
        }
        return result;
    }

    static {
        COLONLESS_PSEUDOELEMENTS.add("first-line");
        COLONLESS_PSEUDOELEMENTS.add("first-letter");
        COLONLESS_PSEUDOELEMENTS.add("before");
        COLONLESS_PSEUDOELEMENTS.add("after");
    }
}

