/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.scopes;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.AbstractVariableDeclaration;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.ast.NamespaceReference;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.ast.Variable;
import com.github.sommeri.less4j.core.compiler.scopes.FullMixinDefinition;
import com.github.sommeri.less4j.core.compiler.scopes.MixinsScope;
import com.github.sommeri.less4j.core.compiler.scopes.VariablesScope;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Scope {
    private final ASTCssNode owner;
    private boolean presentInTree = true;
    private VariablesScope variables = new VariablesScope();
    private MixinsScope mixins = new MixinsScope();
    private Scope parent;
    private List<Scope> childs = new ArrayList<Scope>();
    private String name;

    protected Scope(ASTCssNode owner, String name, Scope parent) {
        this.name = name;
        this.owner = owner;
        this.setParent(parent);
    }

    protected Scope(ASTCssNode owner, String name) {
        this(owner, name, null);
    }

    private void addChild(Scope child) {
        this.childs.add(child);
    }

    public Scope getParent() {
        return this.parent;
    }

    public List<Scope> getChilds() {
        return this.childs;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasParent() {
        return this.getParent() != null;
    }

    public String toString() {
        if (this.hasParent()) {
            return this.getParent() + " > " + this.getName();
        }
        return this.getName();
    }

    public void registerVariable(AbstractVariableDeclaration declaration) {
        this.variables.addDeclaration(declaration);
    }

    public void registerVariable(AbstractVariableDeclaration node, Expression replacementValue) {
        this.variables.addDeclaration(node, replacementValue);
    }

    public void registerVariableIfNotPresent(String name, Expression replacementValue) {
        this.variables.addDeclarationIfNotPresent(name, replacementValue);
    }

    public Expression getValue(Variable variable) {
        return this.getValue(variable.getName());
    }

    public Expression getValue(String name) {
        Expression value = this.variables.getValue(name);
        if (value == null && this.hasParent()) {
            return this.getParent().getValue(name);
        }
        return value;
    }

    public void registerMixin(ReusableStructure mixin, Scope mixinsBodyScope) {
        this.mixins.registerMixin(new FullMixinDefinition(mixin, mixinsBodyScope));
    }

    public List<FullMixinDefinition> getNearestMixins(MixinReference reference) {
        return this.getNearestMixins(reference.getName());
    }

    public List<FullMixinDefinition> getNearestMixins(String name) {
        ArrayList value = this.mixins.getMixins(name);
        if ((value == null || value.isEmpty()) && this.hasParent()) {
            return this.getParent().getNearestMixins(name);
        }
        return value == null ? new ArrayList() : value;
    }

    public List<FullMixinDefinition> getNearestMixins(NamespaceReference reference, ProblemsHandler problemsHandler) {
        List<Scope> namespaces = this.getNearestNamespaces(reference);
        if (namespaces.isEmpty()) {
            problemsHandler.undefinedNamespace(reference);
        }
        ArrayList<FullMixinDefinition> result = new ArrayList<FullMixinDefinition>();
        for (Scope scope : namespaces) {
            result.addAll(scope.getNearestMixins(reference.getFinalReference()));
        }
        return result;
    }

    private List<Scope> getNearestNamespaces(NamespaceReference reference) {
        List<String> nameChain = reference.getNameChain();
        Scope space = this;
        List<Scope> result = this.findMatchingChilds(nameChain);
        while (result.isEmpty() && space.hasParent()) {
            space = space.getParent();
            result = space.findMatchingChilds(nameChain);
        }
        return result;
    }

    public List<Scope> findMatchingChilds(List<String> nameChain) {
        if (nameChain.isEmpty()) {
            return Arrays.asList(this);
        }
        String fistName = nameChain.get(0);
        List<String> theRest = nameChain.subList(1, nameChain.size());
        ArrayList<Scope> result = new ArrayList<Scope>();
        for (Scope kid : this.getChilds()) {
            if (!kid.getName().equals(fistName)) continue;
            result.addAll(kid.findMatchingChilds(theRest));
        }
        return result;
    }

    public static Scope createDefaultScope(ASTCssNode owner) {
        return new Scope(owner, "#default#");
    }

    public static Scope createUnnamedScope(ASTCssNode owner, Scope parent) {
        return new Scope(owner, "#unnamed#", parent);
    }

    public static Scope createScope(ASTCssNode owner, String name, Scope parent) {
        return new Scope(owner, name, parent);
    }

    public String toLongString() {
        return this.toLongString(0).toString();
    }

    private StringBuilder toLongString(int level) {
        String prefix = "";
        for (int i = 0; i < level; ++i) {
            prefix = prefix + "  ";
        }
        StringBuilder text = new StringBuilder(prefix);
        text.append(this.getName()).append("(").append(this.variables.size()).append(", ").append(this.mixins.size());
        text.append(") {").append("\n");
        for (Scope kid : this.getChilds()) {
            text.append((CharSequence)kid.toLongString(level + 1));
        }
        text.append(prefix).append("}").append("\n");
        return text;
    }

    public Scope copyWithChildChain() {
        return this.copyWithChildChain(null);
    }

    public Scope copyWithChildChain(Scope parent) {
        Scope result = new Scope(this.owner, this.getName(), parent);
        result.variables = this.variables;
        result.mixins = this.mixins;
        result.presentInTree = this.presentInTree;
        for (Scope kid : this.getChilds()) {
            kid.copyWithChildChain(result);
        }
        return result;
    }

    public Scope copyWithParentsChain() {
        Scope parent = this.hasParent() ? this.getParent().copyWithParentsChain() : null;
        Scope result = new Scope(this.owner, this.getName(), parent);
        result.variables = this.variables;
        result.mixins = this.mixins;
        result.presentInTree = this.presentInTree;
        return result;
    }

    public void setParent(Scope parent) {
        if (parent == null && this.hasParent()) {
            this.getParent().getChilds().remove(this);
        }
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public void removedFromTree() {
        this.presentInTree = false;
    }

    public boolean isPresentInTree() {
        return this.presentInTree;
    }

    public Scope getRootScope() {
        if (!this.hasParent()) {
            return this;
        }
        return this.getParent().getRootScope();
    }

    public Scope getChildOwnerOf(ASTCssNode body) {
        for (Scope kid : this.getChilds()) {
            if (kid.owner != body) continue;
            return kid;
        }
        return null;
    }
}

