/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import java.util.Collections;
import java.util.List;

public class NumberExpression
extends Expression
implements Cloneable {
    private String originalString;
    private Dimension dimension = Dimension.NUMBER;
    private Double valueAsDouble;
    private String suffix = "";
    private boolean expliciteSign = false;

    public NumberExpression(HiddenTokenAwareTree token) {
        super(token);
    }

    public NumberExpression(HiddenTokenAwareTree token, String originalString) {
        super(token);
        this.originalString = originalString;
    }

    public NumberExpression(HiddenTokenAwareTree token, String originalString, Dimension dimension) {
        this(token, originalString);
        this.dimension = dimension;
    }

    public NumberExpression(HiddenTokenAwareTree token, Double valueAsDouble, String suffix, String originalString, Dimension dimension) {
        this(token, originalString, dimension);
        this.valueAsDouble = valueAsDouble;
        this.suffix = suffix;
    }

    public String getOriginalString() {
        return this.originalString;
    }

    public void setOriginalString(String originalString) {
        this.originalString = originalString;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public Double getValueAsDouble() {
        return this.valueAsDouble;
    }

    public void setValueAsDouble(Double number) {
        this.valueAsDouble = number;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean hasExpliciteSign() {
        return this.expliciteSign;
    }

    public void setExpliciteSign(boolean expliciteSign) {
        this.expliciteSign = expliciteSign;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void negate() {
        if (this.valueAsDouble == null) {
            return;
        }
        this.valueAsDouble = this.valueAsDouble * -1.0;
    }

    @Override
    public List<? extends ASTCssNode> getChilds() {
        return Collections.emptyList();
    }

    public boolean hasOriginalString() {
        return this.getOriginalString() != null;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.NUMBER;
    }

    public String toString() {
        if (this.originalString != null) {
            return this.originalString;
        }
        return "" + this.valueAsDouble + this.suffix;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dimension == null ? 0 : this.dimension.hashCode());
        result = 31 * result + (this.expliciteSign ? 1231 : 1237);
        result = 31 * result + (this.suffix == null ? 0 : this.suffix.hashCode());
        result = 31 * result + (this.valueAsDouble == null ? 0 : this.valueAsDouble.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumberExpression other = (NumberExpression)obj;
        if (this.dimension != other.dimension) {
            return false;
        }
        if (this.expliciteSign != other.expliciteSign) {
            return false;
        }
        if (this.suffix == null ? other.suffix != null : !this.suffix.equals(other.suffix)) {
            return false;
        }
        return !(this.valueAsDouble == null ? other.valueAsDouble != null : !this.valueAsDouble.equals(other.valueAsDouble));
    }

    @Override
    public NumberExpression clone() {
        NumberExpression clone = (NumberExpression)super.clone();
        return clone;
    }

    public static enum Dimension {
        NUMBER,
        PERCENTAGE,
        LENGTH,
        EMS,
        EXS,
        ANGLE,
        TIME,
        FREQ,
        REPEATER,
        UNKNOWN;

    }
}

