/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.StyleSheet;
import com.github.sommeri.less4j.core.compiler.LessToCssCompiler;
import com.github.sommeri.less4j.core.parser.ANTLRParser;
import com.github.sommeri.less4j.core.parser.ASTBuilder;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import com.github.sommeri.less4j.utils.CssPrinter;

public class ThreadUnsafeLessCompiler
implements LessCompiler {
    private ProblemsHandler problemsHandler;
    private ASTBuilder astBuilder;
    private LessToCssCompiler compiler;
    private ANTLRParser parser = new ANTLRParser();

    @Override
    public LessCompiler.CompilationResult compile(String lessContent) throws Less4jException {
        this.problemsHandler = new ProblemsHandler();
        this.astBuilder = new ASTBuilder(this.problemsHandler);
        this.compiler = new LessToCssCompiler(this.problemsHandler);
        String css = this.doCompile(lessContent);
        LessCompiler.CompilationResult compilationResult = new LessCompiler.CompilationResult(css, this.problemsHandler.getWarnings());
        if (this.problemsHandler.hasErrors()) {
            throw new Less4jException(this.problemsHandler.getErrors(), compilationResult);
        }
        return compilationResult;
    }

    private String doCompile(String lessContent) throws Less4jException {
        ANTLRParser.ParseResult result = this.parser.parseStyleSheet(lessContent);
        if (result.hasErrors()) {
            LessCompiler.CompilationResult compilationResult = new LessCompiler.CompilationResult("Errors during parsing phase, partial result is not available.");
            throw new Less4jException(result.getErrors(), compilationResult);
        }
        StyleSheet lessStyleSheet = this.astBuilder.parse(result.getTree());
        ASTCssNode cssStyleSheet = this.compiler.compileToCss(lessStyleSheet);
        CssPrinter builder = new CssPrinter();
        builder.append(cssStyleSheet);
        return builder.toString();
    }
}

