/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.StyleSheet;
import com.github.sommeri.less4j.core.compiler.LessToCssCompiler;
import com.github.sommeri.less4j.core.parser.ANTLRParser;
import com.github.sommeri.less4j.core.parser.ASTBuilder;
import com.github.sommeri.less4j.core.problems.GeneralProblem;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import com.github.sommeri.less4j.utils.CssPrinter;
import java.io.File;
import java.net.URL;

public class ThreadUnsafeLessCompiler
implements LessCompiler {
    private ProblemsHandler problemsHandler;
    private ASTBuilder astBuilder;
    private LessToCssCompiler compiler;
    private ANTLRParser parser = new ANTLRParser();

    @Override
    public LessCompiler.CompilationResult compile(String lessContent) throws Less4jException {
        return this.compile(new LessSource.StringSource(lessContent));
    }

    @Override
    public LessCompiler.CompilationResult compile(File inputFile) throws Less4jException {
        return this.compile(new LessSource.FileSource(inputFile));
    }

    @Override
    public LessCompiler.CompilationResult compile(URL inputURL) throws Less4jException {
        return this.compile(new LessSource.URLSource(inputURL));
    }

    @Override
    public LessCompiler.CompilationResult compile(LessSource source) throws Less4jException {
        this.problemsHandler = new ProblemsHandler();
        this.astBuilder = new ASTBuilder(this.problemsHandler);
        this.compiler = new LessToCssCompiler(this.problemsHandler);
        String css = this.doCompile(source);
        LessCompiler.CompilationResult compilationResult = new LessCompiler.CompilationResult(css, this.problemsHandler.getWarnings());
        if (this.problemsHandler.hasErrors()) {
            throw new Less4jException(this.problemsHandler.getErrors(), compilationResult);
        }
        return compilationResult;
    }

    private String doCompile(LessSource source) throws Less4jException {
        ANTLRParser.ParseResult result;
        try {
            result = this.parser.parseStyleSheet(source.getContent(), source);
        }
        catch (LessSource.FileNotFound ex) {
            throw new Less4jException(new GeneralProblem("The file " + source + " does not exists."), new LessCompiler.CompilationResult(null));
        }
        catch (LessSource.CannotReadFile ex) {
            throw new Less4jException(new GeneralProblem("Cannot read the file " + source + "."), new LessCompiler.CompilationResult(null));
        }
        if (result.hasErrors()) {
            LessCompiler.CompilationResult compilationResult = new LessCompiler.CompilationResult("Errors during parsing phase, partial result is not available.");
            throw new Less4jException(result.getErrors(), compilationResult);
        }
        StyleSheet lessStyleSheet = this.astBuilder.parse(result.getTree());
        ASTCssNode cssStyleSheet = this.compiler.compileToCss(lessStyleSheet, source);
        CssPrinter builder = new CssPrinter();
        builder.append(cssStyleSheet);
        return builder.toString();
    }
}

