/*
 * Decompiled with CFR 0.152.
 */
package edu.ufl.cise.amd.tdouble;

import edu.ufl.cise.amd.tdouble.Damd_internal;
import edu.ufl.cise.amd.tdouble.Damd_valid;

public class Damd_aat
extends Damd_internal {
    public static int amd_aat(int n, int[] Ap, int[] Ai, int[] Len, int[] Tp, double[] Info) {
        int pj;
        int j;
        int i;
        int k;
        if (!NDEBUG) {
            for (k = 0; k < n; ++k) {
                Tp[k] = -1;
            }
            Damd_aat.ASSERT(Damd_valid.amd_valid(n, n, Ap, Ai) == 0);
        }
        if (Info != null) {
            for (i = 0; i < 20; ++i) {
                Info[i] = -1.0;
            }
            Info[0] = 0.0;
        }
        for (k = 0; k < n; ++k) {
            Len[k] = 0;
        }
        int nzdiag = 0;
        int nzboth = 0;
        int nz = Ap[n];
        for (k = 0; k < n; ++k) {
            int p1 = Ap[k];
            int p2 = Ap[k + 1];
            Damd_aat.AMD_DEBUG2("\nAAT Column: " + ID + " p1: " + ID + " p2: " + ID + "\n", k, p1, p2);
            int p = p1;
            while (p < p2) {
                j = Ai[p];
                if (j < k) {
                    int n2 = j;
                    Len[n2] = Len[n2] + 1;
                    int n3 = k;
                    Len[n3] = Len[n3] + 1;
                    Damd_aat.AMD_DEBUG3("    upper (" + ID + "," + ID + ") (" + ID + "," + ID + ")\n", j, k, k, j);
                    ++p;
                } else {
                    if (j != k) break;
                    ++nzdiag;
                    break;
                }
                Damd_aat.ASSERT(Tp[j] != -1);
                Damd_aat.ASSERT(Ap[j] <= Tp[j] && Tp[j] <= Ap[j + 1]);
                int pj2 = Ap[j + 1];
                for (pj = Tp[j]; pj < pj2; ++pj) {
                    i = Ai[pj];
                    if (i < k) {
                        int n4 = i;
                        Len[n4] = Len[n4] + 1;
                        int n5 = j;
                        Len[n5] = Len[n5] + 1;
                        Damd_aat.AMD_DEBUG3("    lower (" + ID + "," + ID + ") (" + ID + "," + ID + ")\n", i, j, j, i);
                        continue;
                    }
                    if (i != k) break;
                    ++nzboth;
                    break;
                }
                Tp[j] = ++pj;
            }
            Tp[k] = ++p;
        }
        for (j = 0; j < n; ++j) {
            for (pj = Tp[j]; pj < Ap[j + 1]; ++pj) {
                int n6 = i = Ai[pj];
                Len[n6] = Len[n6] + 1;
                int n7 = j;
                Len[n7] = Len[n7] + 1;
                Damd_aat.AMD_DEBUG3("    lower cleanup (" + ID + "," + ID + ") (" + ID + "," + ID + ")\n", i, j, j, i);
            }
        }
        double sym = nz == nzdiag ? 1.0 : 2.0 * (double)nzboth / (double)(nz - nzdiag);
        int nzaat = 0;
        for (k = 0; k < n; ++k) {
            nzaat += Len[k];
        }
        Damd_aat.AMD_DEBUG1("AMD nz in A+A', excluding diagonal (nzaat) = %d\n", nzaat);
        Damd_aat.AMD_DEBUG1("   nzboth: " + ID + " nz: " + ID + " nzdiag: " + ID + " symmetry: %.3f\n", nzboth, nz, nzdiag, sym);
        if (Info != null) {
            Info[0] = 0.0;
            Info[1] = n;
            Info[2] = nz;
            Info[3] = sym;
            Info[4] = nzdiag;
            Info[5] = nzaat;
        }
        return nzaat;
    }
}

