/*
 * Decompiled with CFR 0.152.
 */
package smile.vq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import smile.math.MathEx;
import smile.util.IntPair;
import smile.vq.VectorQuantizer;

public class BIRCH
implements VectorQuantizer {
    private static final long serialVersionUID = 2L;
    public final int B;
    public final int L;
    public final double T;
    public final int d;
    private Node root;

    public BIRCH(int d, int B, int L, double T) {
        this.d = d;
        this.B = B;
        this.L = L;
        this.T = T;
    }

    @Override
    public void update(double[] x) {
        if (this.root == null) {
            this.root = new Leaf(this, x);
        } else {
            Optional<Node> sister = this.root.add(x);
            sister.ifPresent(child -> {
                this.root = new InternalNode(this, this.root, (Node)child);
            });
        }
    }

    @Override
    public double[] quantize(double[] x) {
        ClusteringFeature cluster = this.root.nearest(x);
        return cluster.centroid();
    }

    public double[][] centroids() {
        ArrayList<double[]> list = new ArrayList<double[]>();
        this.centroids(this.root, list);
        return (double[][])list.toArray((T[])new double[list.size()][]);
    }

    private void centroids(Node node, ArrayList<double[]> list) {
        if (node instanceof Leaf) {
            Leaf leaf = (Leaf)node;
            for (int i = 0; i < leaf.k; ++i) {
                list.add(leaf.clusters[i].centroid());
            }
        } else {
            InternalNode parent = (InternalNode)node;
            for (int i = 0; i < parent.k; ++i) {
                this.centroids(parent.children[i], list);
            }
        }
    }

    private abstract class Node
    implements Serializable {
        protected ClusteringFeature cluster;
        final /* synthetic */ BIRCH this$0;

        public Node(BIRCH bIRCH, ClusteringFeature ... clusters) {
            BIRCH bIRCH2 = bIRCH;
            Objects.requireNonNull(bIRCH2);
            this.this$0 = bIRCH2;
            this.cluster = new ClusteringFeature(bIRCH, clusters);
        }

        public Node(BIRCH bIRCH, Node ... nodes) {
            BIRCH bIRCH2 = bIRCH;
            Objects.requireNonNull(bIRCH2);
            this.this$0 = bIRCH2;
            ClusteringFeature[] clusters = (ClusteringFeature[])Arrays.stream(nodes).map(node -> node.cluster).toArray(ClusteringFeature[]::new);
            this.cluster = new ClusteringFeature(bIRCH, clusters);
        }

        public abstract ClusteringFeature nearest(double[] var1);

        public abstract Optional<Node> add(double[] var1);

        public double distance(double[] x) {
            return this.cluster.distance(x);
        }

        public double[][] pdist(ClusteringFeature[] clusters) {
            int k = clusters.length;
            double[][] dist = new double[k][k];
            for (int i = 0; i < k; ++i) {
                for (int j = i + 1; j < k; ++j) {
                    dist[i][j] = clusters[i].distance(clusters[j]);
                    dist[j][i] = dist[i][j];
                }
            }
            return dist;
        }

        public double[][] pdist(Node[] nodes) {
            ClusteringFeature[] clusters = (ClusteringFeature[])Arrays.stream(nodes).map(node -> node.cluster).toArray(ClusteringFeature[]::new);
            return this.pdist(clusters);
        }
    }

    private class Leaf
    extends Node {
        private final ClusteringFeature[] clusters;
        private int k;
        final /* synthetic */ BIRCH this$0;

        public Leaf(BIRCH bIRCH, ClusteringFeature ... clusters) {
            BIRCH bIRCH2 = bIRCH;
            Objects.requireNonNull(bIRCH2);
            this.this$0 = bIRCH2;
            super(bIRCH, clusters);
            this.k = clusters.length;
            this.clusters = new ClusteringFeature[bIRCH.L];
            System.arraycopy(clusters, 0, this.clusters, 0, clusters.length);
        }

        public Leaf(BIRCH bIRCH, double[] x) {
            this(bIRCH, new ClusteringFeature(bIRCH, x));
        }

        @Override
        public ClusteringFeature nearest(double[] x) {
            int index = 0;
            double nearest = this.clusters[0].distance(x);
            for (int i = 1; i < this.k; ++i) {
                double dist = this.clusters[i].distance(x);
                if (!(dist < nearest)) continue;
                index = i;
                nearest = dist;
            }
            return this.clusters[index];
        }

        @Override
        public Optional<Node> add(double[] x) {
            ClusteringFeature cluster = this.nearest(x);
            Optional<ClusteringFeature> sister = cluster.add(x);
            if (sister.isPresent()) {
                if (this.k < this.this$0.L) {
                    this.clusters[this.k++] = sister.get();
                } else {
                    return Optional.of(this.split(sister.get()));
                }
            }
            this.cluster.update(x);
            return Optional.empty();
        }

        private Node split(ClusteringFeature cluster) {
            int i;
            ClusteringFeature[] clusters = new ClusteringFeature[this.this$0.L + 1];
            System.arraycopy(this.clusters, 0, clusters, 0, this.this$0.L);
            clusters[this.this$0.L] = cluster;
            double[][] dist = this.pdist(clusters);
            IntPair farthest = MathEx.whichMax((double[][])dist);
            this.k = 0;
            int n = 0;
            ClusteringFeature[] sister = new ClusteringFeature[this.this$0.L];
            for (i = 0; i <= this.this$0.L; ++i) {
                if (dist[i][farthest._1()] < dist[i][farthest._2()]) {
                    this.clusters[this.k++] = clusters[i];
                    continue;
                }
                sister[n++] = clusters[i];
            }
            for (i = this.k; i < this.this$0.L; ++i) {
                this.clusters[i] = null;
            }
            this.cluster = new ClusteringFeature(this.this$0, Arrays.copyOf(this.clusters, this.k));
            return new Leaf(this.this$0, Arrays.copyOf(sister, n));
        }
    }

    private class ClusteringFeature
    implements Serializable {
        private int n;
        private final double[] sum;
        private final double[] ss;
        final /* synthetic */ BIRCH this$0;

        public ClusteringFeature(BIRCH bIRCH, double[] x) {
            BIRCH bIRCH2 = bIRCH;
            Objects.requireNonNull(bIRCH2);
            this.this$0 = bIRCH2;
            this.sum = new double[this.this$0.d];
            this.ss = new double[this.this$0.d];
            this.n = 1;
            System.arraycopy(x, 0, this.sum, 0, bIRCH.d);
            for (int i = 0; i < bIRCH.d; ++i) {
                this.ss[i] = x[i] * x[i];
            }
        }

        public ClusteringFeature(BIRCH bIRCH, ClusteringFeature ... clusters) {
            BIRCH bIRCH2 = bIRCH;
            Objects.requireNonNull(bIRCH2);
            this.this$0 = bIRCH2;
            this.sum = new double[this.this$0.d];
            this.ss = new double[this.this$0.d];
            this.n = 0;
            for (ClusteringFeature cluster : clusters) {
                this.n += cluster.n;
                for (int i = 0; i < bIRCH.d; ++i) {
                    int n = i;
                    this.sum[n] = this.sum[n] + cluster.sum[i];
                    int n2 = i;
                    this.ss[n2] = this.ss[n2] + cluster.ss[i];
                }
            }
        }

        public double[] centroid() {
            double[] centroid = new double[this.this$0.d];
            for (int i = 0; i < this.this$0.d; ++i) {
                centroid[i] = this.sum[i] / (double)this.n;
            }
            return centroid;
        }

        public double radius() {
            double r = 0.0;
            for (int i = 0; i < this.this$0.d; ++i) {
                double mu = this.sum[i] / (double)this.n;
                r += this.ss[i] / (double)this.n - mu * mu;
            }
            return Math.sqrt(r);
        }

        public double radius(double[] x) {
            int n1 = this.n + 1;
            double r = 0.0;
            for (int i = 0; i < this.this$0.d; ++i) {
                double mu = (this.sum[i] + x[i]) / (double)n1;
                r += (this.ss[i] + x[i] * x[i]) / (double)n1 - mu * mu;
            }
            return Math.sqrt(r);
        }

        public void update(double[] x) {
            ++this.n;
            for (int i = 0; i < this.this$0.d; ++i) {
                int n = i;
                this.sum[n] = this.sum[n] + x[i];
                int n2 = i;
                this.ss[n2] = this.ss[n2] + x[i] * x[i];
            }
        }

        public Optional<ClusteringFeature> add(double[] x) {
            if (this.radius(x) > this.this$0.T) {
                return Optional.of(new ClusteringFeature(this.this$0, x));
            }
            this.update(x);
            return Optional.empty();
        }

        public double distance(double[] x) {
            double dist = 0.0;
            for (int i = 0; i < this.this$0.d; ++i) {
                double diff = this.sum[i] / (double)this.n - x[i];
                dist += diff * diff;
            }
            return Math.sqrt(dist);
        }

        public double distance(ClusteringFeature o) {
            double dist = 0.0;
            for (int i = 0; i < this.this$0.d; ++i) {
                double diff = this.sum[i] / (double)this.n - o.sum[i] / (double)o.n;
                dist += diff * diff;
            }
            return Math.sqrt(dist);
        }
    }

    private class InternalNode
    extends Node {
        private final Node[] children;
        private int k;
        final /* synthetic */ BIRCH this$0;

        public InternalNode(BIRCH bIRCH, Node ... nodes) {
            BIRCH bIRCH2 = bIRCH;
            Objects.requireNonNull(bIRCH2);
            this.this$0 = bIRCH2;
            super(bIRCH, nodes);
            this.k = nodes.length;
            this.children = new Node[bIRCH.B];
            System.arraycopy(nodes, 0, this.children, 0, nodes.length);
        }

        @Override
        public ClusteringFeature nearest(double[] x) {
            int index = 0;
            double nearest = this.children[0].distance(x);
            for (int i = 1; i < this.k; ++i) {
                double dist = this.children[i].distance(x);
                if (!(dist < nearest)) continue;
                index = i;
                nearest = dist;
            }
            return this.children[index].nearest(x);
        }

        @Override
        public Optional<Node> add(double[] x) {
            int index = 0;
            double nearest = this.children[0].distance(x);
            for (int i = 1; i < this.k; ++i) {
                double dist = this.children[i].distance(x);
                if (!(dist < nearest)) continue;
                index = i;
                nearest = dist;
            }
            Optional<Node> sister = this.children[index].add(x);
            if (sister.isPresent()) {
                if (this.k < this.this$0.B) {
                    this.children[this.k++] = sister.get();
                } else {
                    return Optional.of(this.split(sister.get()));
                }
            }
            this.cluster.update(x);
            return Optional.empty();
        }

        private Node split(Node node) {
            int i;
            Node[] nodes = new Node[this.this$0.B + 1];
            System.arraycopy(this.children, 0, nodes, 0, this.this$0.B);
            nodes[this.this$0.B] = node;
            double[][] dist = this.pdist(nodes);
            IntPair farthest = MathEx.whichMax((double[][])dist);
            this.k = 0;
            int n = 0;
            Node[] sister = new Node[this.this$0.B];
            for (i = 0; i <= this.this$0.B; ++i) {
                if (dist[i][farthest._1()] < dist[i][farthest._2()]) {
                    this.children[this.k++] = nodes[i];
                    continue;
                }
                sister[n++] = nodes[i];
            }
            for (i = this.k; i < this.this$0.B; ++i) {
                this.children[i] = null;
            }
            this.cluster = new ClusteringFeature(this.this$0, (ClusteringFeature[])Arrays.stream(this.children).limit(this.k).map(child -> child.cluster).toArray(ClusteringFeature[]::new));
            return new InternalNode(this.this$0, Arrays.copyOf(sister, n));
        }
    }
}

