/*
 * Decompiled with CFR 0.152.
 */
package smile.manifold;

import java.util.Arrays;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.manifold.MDS;
import smile.math.MathEx;
import smile.util.AlgoStatus;
import smile.util.IterativeAlgorithmController;

public record SammonMapping(double stress, double[][] coordinates) {
    private static final Logger logger = LoggerFactory.getLogger(SammonMapping.class);

    public static SammonMapping fit(double[][] proximity) {
        return SammonMapping.fit(proximity, new Options(2, 0.2, 100));
    }

    public static SammonMapping fit(double[][] proximity, Options options) {
        MDS mds = MDS.fit(proximity, new MDS.Options(options.d, false));
        return SammonMapping.fit(proximity, mds.coordinates(), options);
    }

    public static SammonMapping fit(double[][] proximity, double[][] coordinates, Options options) {
        if (proximity.length != proximity[0].length) {
            throw new IllegalArgumentException("The proximity matrix is not square.");
        }
        if (proximity.length != coordinates.length) {
            throw new IllegalArgumentException("The proximity matrix and the initial coordinates are of different size.");
        }
        int n = proximity.length;
        double c = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                c += proximity[i][j];
            }
        }
        int d = options.d;
        double[][] xu = new double[n][d];
        double stress = SammonMapping.stress(proximity, coordinates);
        double epast = stress /= c;
        double eprev = stress;
        double[] xv = new double[d];
        double[] e1 = new double[d];
        double[] e2 = new double[d];
        double step = options.step;
        double tol = options.tol;
        double stepTol = options.stepTol;
        int maxIter = options.maxIter;
        logger.info("Initial stress: {}", (Object)stress);
        if (options.controller != null) {
            options.controller.submit((Object)new AlgoStatus(0, stress, (Object)step));
        }
        for (int iter = 1; iter <= maxIter; ++iter) {
            int j;
            for (int i = 0; i < n; ++i) {
                double[] ri = coordinates[i];
                Arrays.fill(e1, 0.0);
                Arrays.fill(e2, 0.0);
                for (j = 0; j < n; ++j) {
                    if (i == j) continue;
                    double[] rj = coordinates[j];
                    double dij = proximity[i][j];
                    if (dij == 0.0) {
                        dij = 1.0E-10;
                    }
                    double rij = 0.0;
                    for (int l = 0; l < d; ++l) {
                        double xd = ri[l] - rj[l];
                        rij += xd * xd;
                        xv[l] = xd;
                    }
                    if ((rij = Math.sqrt(rij)) == 0.0) {
                        rij = 1.0E-10;
                    }
                    double dq = dij - rij;
                    double dr = dij * rij;
                    for (int l = 0; l < d; ++l) {
                        int n2 = l;
                        e1[n2] = e1[n2] + xv[l] * dq / dr;
                        int n3 = l;
                        e2[n3] = e2[n3] + (dq - xv[l] * xv[l] * (1.0 + dq / rij) / rij) / dr;
                    }
                }
                for (int l = 0; l < d; ++l) {
                    xu[i][l] = ri[l] + step * e1[l] / Math.abs(e2[l]);
                }
            }
            stress = SammonMapping.stress(proximity, xu);
            if ((stress /= c) > eprev) {
                stress = eprev;
                if ((step *= 0.2) < stepTol) {
                    logger.info("Iteration {}: early stop with stress = {}, step = {}", new Object[]{iter, stress, step});
                    break;
                }
                logger.info("Decreases step size = {}", (Object)step);
                --iter;
                continue;
            }
            step = Math.min(0.5, step * 1.5);
            eprev = stress;
            double[] mu = MathEx.colMeans((double[][])xu);
            for (int i = 0; i < n; ++i) {
                for (j = 0; j < d; ++j) {
                    coordinates[i][j] = xu[i][j] - mu[j];
                }
            }
            if (iter % 10 == 0) {
                logger.info("Iteration {}: stress = {}, step = {}", new Object[]{iter, stress, step});
                if (stress > epast - tol) break;
                epast = stress;
            }
            if (options.controller == null) continue;
            options.controller.submit((Object)new AlgoStatus(iter, stress, (Object)step));
            if (options.controller.isInterrupted()) break;
        }
        return new SammonMapping(stress, coordinates);
    }

    private static double stress(double[][] proximity, double[][] coordinates) {
        double stress = 0.0;
        int n = proximity.length;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double dij = proximity[i][j];
                if (dij == 0.0) {
                    dij = 1.0E-10;
                }
                double rij = MathEx.distance((double[])coordinates[i], (double[])coordinates[j]);
                stress += MathEx.pow2((double)(dij - rij)) / dij;
            }
        }
        return stress;
    }

    public record Options(int d, double step, int maxIter, double tol, double stepTol, IterativeAlgorithmController<AlgoStatus> controller) {
        public Options {
            if (d < 2) {
                throw new IllegalArgumentException("Invalid dimension of feature space: " + d);
            }
            if (step < 0.0) {
                throw new IllegalArgumentException("Invalid step size: " + step);
            }
            if (maxIter <= 0) {
                throw new IllegalArgumentException("Invalid maximum number of iterations: " + maxIter);
            }
            if (tol <= 0.0) {
                throw new IllegalArgumentException("Invalid tolerance: " + tol);
            }
            if (stepTol <= 0.0) {
                throw new IllegalArgumentException("Invalid step size tolerance: " + stepTol);
            }
        }

        public Options(int d, double step, int maxIter) {
            this(d, step, maxIter, 1.0E-4, 0.001, null);
        }

        public Properties toProperties() {
            Properties props = new Properties();
            props.setProperty("smile.sammon.d", Integer.toString(this.d));
            props.setProperty("smile.sammon.step", Double.toString(this.step));
            props.setProperty("smile.sammon.iterations", Integer.toString(this.maxIter));
            props.setProperty("smile.sammon.tolerance", Double.toString(this.tol));
            props.setProperty("smile.sammon.step_tolerance", Double.toString(this.stepTol));
            return props;
        }

        public static Options of(Properties props) {
            int d = Integer.parseInt(props.getProperty("smile.sammon.d", "2"));
            double step = Double.parseDouble(props.getProperty("smile.sammon.step", "0.2"));
            int maxIter = Integer.parseInt(props.getProperty("smile.sammon.iterations", "100"));
            double tol = Double.parseDouble(props.getProperty("smile.sammon.tolerance", "1E-4"));
            double stepTol = Double.parseDouble(props.getProperty("smile.sammon.step_tolerance", "1E-3"));
            return new Options(d, step, maxIter, tol, stepTol, null);
        }
    }
}

