/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

import java.util.Arrays;
import smile.math.MathEx;

public class IntArray2D {
    private final int[] A;
    private final int nrow;
    private final int ncol;

    public IntArray2D(int[][] A) {
        this.nrow = A.length;
        this.ncol = A[0].length;
        this.A = new int[this.nrow * this.ncol];
        int pos = 0;
        for (int i = 0; i < this.nrow; ++i) {
            System.arraycopy(A[i], 0, this.A, pos, this.ncol);
            pos += this.ncol;
        }
    }

    public IntArray2D(int nrow, int ncol) {
        this.nrow = nrow;
        this.ncol = ncol;
        this.A = new int[nrow * ncol];
    }

    public IntArray2D(int nrow, int ncol, int value) {
        this(nrow, ncol);
        if ((double)value != 0.0) {
            Arrays.fill(this.A, value);
        }
    }

    public IntArray2D(int nrow, int ncol, int[] value) {
        this.nrow = nrow;
        this.ncol = ncol;
        this.A = value;
    }

    public int nrow() {
        return this.nrow;
    }

    public int ncol() {
        return this.ncol;
    }

    public int apply(int i, int j) {
        return this.A[i * this.ncol + j];
    }

    public int get(int i, int j) {
        return this.A[i * this.ncol + j];
    }

    public void set(int i, int j, int x) {
        this.A[i * this.ncol + j] = x;
    }

    public int add(int i, int j, int x) {
        int n = i * this.ncol + j;
        int n2 = this.A[n] + x;
        this.A[n] = n2;
        return n2;
    }

    public int sub(int i, int j, int x) {
        int n = i * this.ncol + j;
        int n2 = this.A[n] - x;
        this.A[n] = n2;
        return n2;
    }

    public int mul(int i, int j, int x) {
        int n = i * this.ncol + j;
        int n2 = this.A[n] * x;
        this.A[n] = n2;
        return n2;
    }

    public int div(int i, int j, int x) {
        int n = i * this.ncol + j;
        int n2 = this.A[n] / x;
        this.A[n] = n2;
        return n2;
    }

    public IntArray2D add(IntArray2D B) {
        if (this.nrow != B.nrow || this.ncol != B.ncol) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] + B.A[i];
        }
        return this;
    }

    public IntArray2D sub(IntArray2D B) {
        if (this.nrow != B.nrow || this.ncol != B.ncol) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] - B.A[i];
        }
        return this;
    }

    public IntArray2D mul(IntArray2D B) {
        if (this.nrow != B.nrow || this.ncol != B.ncol) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] * B.A[i];
        }
        return this;
    }

    public IntArray2D div(IntArray2D B) {
        if (this.nrow != B.nrow || this.ncol != B.ncol) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] / B.A[i];
        }
        return this;
    }

    public IntArray2D add(int x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] + x;
        }
        return this;
    }

    public IntArray2D sub(int x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] - x;
        }
        return this;
    }

    public IntArray2D mul(int x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] * x;
        }
        return this;
    }

    public IntArray2D div(int x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] / x;
        }
        return this;
    }

    public long sum() {
        return MathEx.sum(this.A);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean full) {
        return full ? this.toString(this.nrow, this.ncol) : this.toString(7, 7);
    }

    public String toString(int m, int n) {
        StringBuilder sb = new StringBuilder();
        m = Math.min(m, this.nrow);
        String newline = (n = Math.min(n, this.ncol)) < this.ncol ? "...\n" : "\n";
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                sb.append(String.format("%d  ", this.get(i, j)));
            }
            sb.append(newline);
        }
        if (m < this.nrow) {
            sb.append("  ...\n");
        }
        return sb.toString();
    }
}

