/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model;

import com.github.filosganga.geogson.model.Geometry;
import com.github.filosganga.geogson.model.LinearGeometry;
import com.github.filosganga.geogson.model.LinearRing;
import com.github.filosganga.geogson.model.MultiLineString;
import com.github.filosganga.geogson.model.positions.AreaPositions;
import com.github.filosganga.geogson.model.positions.LinearPositions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;

public class Polygon
extends MultiLineString {
    private static final long serialVersionUID = 1L;

    public Polygon(AreaPositions positions) {
        super(Polygon.checkPositions(positions));
    }

    private static AreaPositions checkPositions(AreaPositions src) {
        Preconditions.checkArgument((src.size() >= 1 ? 1 : 0) != 0);
        for (LinearPositions child : src.children()) {
            Preconditions.checkArgument((boolean)child.isClosed());
        }
        return src;
    }

    public static Polygon of(LinearRing perimeter, LinearRing ... holes) {
        return Polygon.of(perimeter, Arrays.asList(holes));
    }

    public static Polygon of(LinearRing perimeter, Iterable<LinearRing> holes) {
        AreaPositions positions = new AreaPositions((ImmutableList<LinearPositions>)ImmutableList.builder().add(perimeter.positions()).addAll(Iterables.transform(holes, Polygon.positionsFn(LinearPositions.class))).build());
        return new Polygon(positions);
    }

    @Override
    public Geometry.Type type() {
        return Geometry.Type.POLYGON;
    }

    public Iterable<LinearRing> linearRings() {
        return Iterables.transform(this.lineStrings(), LinearGeometry.toLinearRingFn());
    }

    public LinearRing perimeter() {
        return (LinearRing)Iterables.getFirst(this.linearRings(), null);
    }

    public Iterable<LinearRing> holes() {
        return Iterables.skip(this.linearRings(), (int)1);
    }
}

