/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model;

import com.github.filosganga.geogson.model.AbstractGeometry;
import com.github.filosganga.geogson.model.Geometry;
import com.github.filosganga.geogson.model.Polygon;
import com.github.filosganga.geogson.model.positions.AreaPositions;
import com.github.filosganga.geogson.model.positions.MultiDimensionalPositions;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;

public class MultiPolygon
extends AbstractGeometry<MultiDimensionalPositions> {
    private static final long serialVersionUID = 1L;

    public MultiPolygon(MultiDimensionalPositions positions) {
        super(positions);
    }

    public static MultiPolygon of(Polygon ... polygons) {
        return MultiPolygon.of((Iterable<Polygon>)ImmutableList.copyOf((Object[])polygons));
    }

    public static MultiPolygon of(Iterable<Polygon> polygons) {
        return new MultiPolygon(new MultiDimensionalPositions(Iterables.transform(polygons, MultiPolygon.positionsFn(AreaPositions.class))));
    }

    @Override
    public Geometry.Type type() {
        return Geometry.Type.MULTI_POLYGON;
    }

    public Iterable<Polygon> polygons() {
        return FluentIterable.from(((MultiDimensionalPositions)this.positions()).children()).transform((Function)new Function<AreaPositions, Polygon>(){

            public Polygon apply(AreaPositions input) {
                return new Polygon(input);
            }
        });
    }
}

